<?php
/**
 * GoodsPriceListResponse
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * GoodsPriceListResponse Class - Response for GoodsPriceList API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsPriceListResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static $openAPIModelName = 'GoodsPriceListResponse';

    protected static $openAPITypes = [
        'success' => 'bool',
        'error_code' => 'int',
        'error_msg' => 'string',
        'request_id' => 'string',
        'result' => 'array'
    ];

    protected static $openAPIFormats = [
        'success' => null,
        'error_code' => null,
        'error_msg' => null,
        'request_id' => null,
        'result' => null
    ];

    protected static array $openAPINullables = [
        'success' => false,
        'error_code' => false,
        'error_msg' => false,
        'request_id' => false,
        'result' => false
    ];

    protected array $openAPINullablesSetToNull = [];

    protected static $attributeMap = [
        'success' => 'success',
        'error_code' => 'errorCode',
        'error_msg' => 'errorMsg',
        'request_id' => 'requestId',
        'result' => 'result'
    ];

    protected static $setters = [
        'success' => 'setSuccess',
        'error_code' => 'setErrorCode',
        'error_msg' => 'setErrorMsg',
        'request_id' => 'setRequestId',
        'result' => 'setResult'
    ];

    protected static $getters = [
        'success' => 'getSuccess',
        'error_code' => 'getErrorCode',
        'error_msg' => 'getErrorMsg',
        'request_id' => 'getRequestId',
        'result' => 'getResult'
    ];

    protected $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['success'] = $data['success'] ?? null;
        $this->container['error_code'] = $data['error_code'] ?? $data['errorCode'] ?? null;
        $this->container['error_msg'] = $data['error_msg'] ?? $data['errorMsg'] ?? null;
        $this->container['request_id'] = $data['request_id'] ?? $data['requestId'] ?? null;
        $this->container['result'] = $data['result'] ?? null;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    public static function setters(): array
    {
        return self::$setters;
    }

    public static function getters(): array
    {
        return self::$getters;
    }

    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    public function listInvalidProperties(): array
    {
        return [];
    }

    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    public function getSuccess(): ?bool
    {
        return $this->container['success'];
    }

    public function setSuccess(?bool $success): self
    {
        $this->container['success'] = $success;
        return $this;
    }

    public function getErrorCode(): ?int
    {
        return $this->container['error_code'];
    }

    public function setErrorCode(?int $errorCode): self
    {
        $this->container['error_code'] = $errorCode;
        return $this;
    }

    public function getErrorMsg(): ?string
    {
        return $this->container['error_msg'];
    }

    public function setErrorMsg(?string $errorMsg): self
    {
        $this->container['error_msg'] = $errorMsg;
        return $this;
    }

    public function getRequestId(): ?string
    {
        return $this->container['request_id'];
    }

    public function setRequestId(?string $requestId): self
    {
        $this->container['request_id'] = $requestId;
        return $this;
    }

    public function getResult(): ?array
    {
        return $this->container['result'];
    }

    public function setResult(?array $result): self
    {
        $this->container['result'] = $result;
        return $this;
    }

    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    public function jsonSerialize(): mixed
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }
}
