<?php
/**
 * GoodsPriceListRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsPriceListRequest Class - Request model for getGoodsPriceList API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsPriceListRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsPriceListRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'querySupplierPriceBaseList' => 'array'
    ];

    protected string $responseClass = GoodsPriceListResponse::class;

    public function __construct(array $querySupplierPriceBaseList)
    {
        parent::__construct();
        $this->setType('bg.local.goods.sku.list.price.query');
        $this->setQuerySupplierPriceBaseList($querySupplierPriceBaseList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getQuerySupplierPriceBaseList(): ?array
    {
        return $this->container['querySupplierPriceBaseList'] ?? null;
    }

    public function setQuerySupplierPriceBaseList(array $querySupplierPriceBaseList): self
    {
        $this->container['querySupplierPriceBaseList'] = $querySupplierPriceBaseList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
