<?php
/**
 * GoodsListResult
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsListResult Class - Result object for goods list response
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsListResult implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsListResult';

    protected static array $openAPITypes = [
        'total' => 'int',
        'page_no' => 'int',
        'goods_list' => '\Temu\Model\GoodsItem[]'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['total'] = $data['total'] ?? null;
        $this->container['page_no'] = $data['page_no'] ?? $data['pageNo'] ?? null;

        // Convert goods_list array to GoodsItem objects
        if (isset($data['goods_list']) || isset($data['goodsList'])) {
            $goodsList = $data['goods_list'] ?? $data['goodsList'];
            $this->container['goods_list'] = array_map(
                fn($item) => $item instanceof GoodsItem ? $item : new GoodsItem($item),
                $goodsList
            );
        } else {
            $this->container['goods_list'] = [];
        }
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Get total count of goods
     *
     * @return int|null
     */
    public function getTotal(): ?int
    {
        return $this->container['total'];
    }

    /**
     * Set total count
     *
     * @param int|null $total
     * @return self
     */
    public function setTotal(?int $total): self
    {
        $this->container['total'] = $total;
        return $this;
    }

    /**
     * Get current page number
     *
     * @return int|null
     */
    public function getPageNo(): ?int
    {
        return $this->container['page_no'];
    }

    /**
     * Set page number
     *
     * @param int|null $pageNo
     * @return self
     */
    public function setPageNo(?int $pageNo): self
    {
        $this->container['page_no'] = $pageNo;
        return $this;
    }

    /**
     * Get list of goods items
     *
     * @return \Temu\Model\GoodsItem[]
     */
    public function getGoodsList(): array
    {
        return $this->container['goods_list'] ?? [];
    }

    /**
     * Set goods list
     *
     * @param \Temu\Model\GoodsItem[] $goodsList
     * @return self
     */
    public function setGoodsList(array $goodsList): self
    {
        $this->container['goods_list'] = $goodsList;
        return $this;
    }

    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    public function __toString(): string
    {
        return json_encode($this->jsonSerialize());
    }

    public function jsonSerialize(): mixed
    {
        return $this->container;
    }
}
