<?php
/**
 * GoodsListResponse
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsListResponse Class - Specific response for getGoodsList API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsListResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsListResponse';

    protected static array $openAPITypes = [
        'success' => 'bool',
        'error_code' => 'int',
        'error_msg' => 'string',
        'request_id' => 'string',
        'result' => '\Temu\Model\GoodsListResult'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['success'] = $data['success'] ?? null;
        $this->container['error_code'] = $data['error_code'] ?? $data['errorCode'] ?? null;
        $this->container['error_msg'] = $data['error_msg'] ?? $data['errorMsg'] ?? null;
        $this->container['request_id'] = $data['request_id'] ?? $data['requestId'] ?? null;
        $this->container['result'] = isset($data['result'])
            ? ($data['result'] instanceof GoodsListResult ? $data['result'] : new GoodsListResult($data['result']))
            : null;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Check if request was successful
     *
     * @return bool|null
     */
    public function getSuccess(): ?bool
    {
        return $this->container['success'];
    }

    /**
     * Set success status
     *
     * @param bool|null $success
     * @return self
     */
    public function setSuccess(?bool $success): self
    {
        $this->container['success'] = $success;
        return $this;
    }

    /**
     * Get error code
     *
     * @return int|null
     */
    public function getErrorCode(): ?int
    {
        return $this->container['error_code'];
    }

    /**
     * Set error code
     *
     * @param int|null $errorCode
     * @return self
     */
    public function setErrorCode(?int $errorCode): self
    {
        $this->container['error_code'] = $errorCode;
        return $this;
    }

    /**
     * Get error message
     *
     * @return string|null
     */
    public function getErrorMsg(): ?string
    {
        return $this->container['error_msg'];
    }

    /**
     * Set error message
     *
     * @param string|null $errorMsg
     * @return self
     */
    public function setErrorMsg(?string $errorMsg): self
    {
        $this->container['error_msg'] = $errorMsg;
        return $this;
    }

    /**
     * Get request ID
     *
     * @return string|null
     */
    public function getRequestId(): ?string
    {
        return $this->container['request_id'];
    }

    /**
     * Set request ID
     *
     * @param string|null $requestId
     * @return self
     */
    public function setRequestId(?string $requestId): self
    {
        $this->container['request_id'] = $requestId;
        return $this;
    }

    /**
     * Get result object containing goods list and pagination info
     *
     * @return \Temu\Model\GoodsListResult|null
     */
    public function getResult(): ?GoodsListResult
    {
        return $this->container['result'];
    }

    /**
     * Set result object
     *
     * @param \Temu\Model\GoodsListResult|null $result
     * @return self
     */
    public function setResult(?GoodsListResult $result): self
    {
        $this->container['result'] = $result;
        return $this;
    }

    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    public function __toString(): string
    {
        return json_encode($this->jsonSerialize());
    }

    public function jsonSerialize(): mixed
    {
        return $this->container;
    }
}
