<?php
/**
 * GoodsListRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsListRequest Class - Request model for getGoodsList API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsListRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsListRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsSearchType' => 'int',
        'orderType' => 'int',
        'pageNo' => 'int',
        'pageSize' => 'int'
    ];

    /**
     * The response class for this request
     *
     * @var string
     */
    protected string $responseClass = GoodsListResponse::class;

    /**
     * Constructor
     *
     * @param int $goodsSearchType Goods search type (default: 1)
     * @param int $orderType Order type (default: 1)
     * @param int $pageNo Page number (default: 1)
     * @param int $pageSize Page size (default: 100)
     */
    public function __construct(int $goodsSearchType = 1, int $orderType = 1, int $pageNo = 1, int $pageSize = 100)
    {
        parent::__construct();
        $this->setType('bg.local.goods.list.query');
        $this->setGoodsSearchType($goodsSearchType);
        $this->setOrderType($orderType);
        $this->setPageNo($pageNo);
        $this->setPageSize($pageSize);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Get goods search type
     *
     * @return int|null
     */
    public function getGoodsSearchType(): ?int
    {
        return $this->container['goodsSearchType'] ?? null;
    }

    /**
     * Set goods search type
     *
     * @param int $goodsSearchType
     * @return self
     */
    public function setGoodsSearchType(int $goodsSearchType): self
    {
        $this->container['goodsSearchType'] = $goodsSearchType;
        return $this;
    }

    /**
     * Get order type
     *
     * @return int|null
     */
    public function getOrderType(): ?int
    {
        return $this->container['orderType'] ?? null;
    }

    /**
     * Set order type
     *
     * @param int $orderType
     * @return self
     */
    public function setOrderType(int $orderType): self
    {
        $this->container['orderType'] = $orderType;
        return $this;
    }

    /**
     * Get page number
     *
     * @return int|null
     */
    public function getPageNo(): ?int
    {
        return $this->container['pageNo'] ?? null;
    }

    /**
     * Set page number
     *
     * @param int $pageNo
     * @return self
     */
    public function setPageNo(int $pageNo): self
    {
        $this->container['pageNo'] = $pageNo;
        return $this;
    }

    /**
     * Get page size
     *
     * @return int|null
     */
    public function getPageSize(): ?int
    {
        return $this->container['pageSize'] ?? null;
    }

    /**
     * Set page size
     *
     * @param int $pageSize
     * @return self
     */
    public function setPageSize(int $pageSize): self
    {
        $this->container['pageSize'] = $pageSize;
        return $this;
    }

    /**
     * Get the response class for this request
     *
     * @return string
     */
    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}