<?php
/**
 * GoodsItem
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use \ArrayAccess;
use \Temu\ObjectSerializer;

/**
 * GoodsItem Class - Represents a single goods/product item
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GoodsItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'goods_id' => 'int',
        'goods_name' => 'string',
        'out_goods_sn' => 'string',
        'cat_id' => 'int',
        'thumb_url' => 'string',
        'price' => 'float',
        'currency' => 'string',
        'market_price' => 'int',
        'quantity' => 'int',
        'status4_vo' => 'int',
        'sub_status4_vo' => 'int',
        'goods_status_change_time' => 'string',
        'crt_time' => 'int',
        'spec_name' => 'string',
        'sku_id_list' => 'int[]',
        'out_sku_sn_list' => 'string[]',
        'sku_info_list' => 'array[]',
        'retail_price' => '\Temu\Model\Price',
        'list_price' => '\Temu\Model\Price',
        'cost_template_id' => 'string',
        'brand_id' => 'int',
        'trademark_id' => 'int',
        'low_traffic_tag' => 'int',
        'restricted_traffic_tag' => 'int',
        'shipment_limit_second' => 'int',
        'goods_show_sub_status' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'goods_id' => null,
        'goods_name' => null,
        'out_goods_sn' => null,
        'cat_id' => null,
        'thumb_url' => null,
        'price' => null,
        'currency' => null,
        'market_price' => null,
        'quantity' => null,
        'status4_vo' => null,
        'sub_status4_vo' => null,
        'goods_status_change_time' => null,
        'crt_time' => null,
        'spec_name' => null,
        'sku_id_list' => null,
        'out_sku_sn_list' => null,
        'sku_info_list' => null,
        'retail_price' => null,
        'list_price' => null,
        'cost_template_id' => null,
        'brand_id' => null,
        'trademark_id' => null,
        'low_traffic_tag' => null,
        'restricted_traffic_tag' => null,
        'shipment_limit_second' => null,
        'goods_show_sub_status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'goods_id' => false,
        'goods_name' => false,
        'out_goods_sn' => false,
        'cat_id' => false,
        'thumb_url' => false,
        'price' => false,
        'currency' => false,
        'market_price' => false,
        'quantity' => false,
        'status4_vo' => false,
        'sub_status4_vo' => false,
        'goods_status_change_time' => false,
        'crt_time' => false,
        'spec_name' => false,
        'sku_id_list' => false,
        'out_sku_sn_list' => false,
        'sku_info_list' => false,
        'retail_price' => false,
        'list_price' => false,
        'cost_template_id' => false,
        'brand_id' => false,
        'trademark_id' => false,
        'low_traffic_tag' => false,
        'restricted_traffic_tag' => false,
        'shipment_limit_second' => false,
        'goods_show_sub_status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'goods_id' => 'goodsId',
        'goods_name' => 'goodsName',
        'out_goods_sn' => 'outGoodsSn',
        'cat_id' => 'catId',
        'thumb_url' => 'thumbUrl',
        'price' => 'price',
        'currency' => 'currency',
        'market_price' => 'marketPrice',
        'quantity' => 'quantity',
        'status4_vo' => 'status4VO',
        'sub_status4_vo' => 'subStatus4VO',
        'goods_status_change_time' => 'goodsStatusChangeTime',
        'crt_time' => 'crtTime',
        'spec_name' => 'specName',
        'sku_id_list' => 'skuIdList',
        'out_sku_sn_list' => 'outSkuSnList',
        'sku_info_list' => 'skuInfoList',
        'retail_price' => 'retailPrice',
        'list_price' => 'listPrice',
        'cost_template_id' => 'costTemplateId',
        'brand_id' => 'brandId',
        'trademark_id' => 'trademarkId',
        'low_traffic_tag' => 'lowTrafficTag',
        'restricted_traffic_tag' => 'restrictedTrafficTag',
        'shipment_limit_second' => 'shipmentLimitSecond',
        'goods_show_sub_status' => 'goodsShowSubStatus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'goods_id' => 'setGoodsId',
        'goods_name' => 'setGoodsName',
        'out_goods_sn' => 'setOutGoodsSn',
        'cat_id' => 'setCatId',
        'thumb_url' => 'setThumbUrl',
        'price' => 'setPrice',
        'currency' => 'setCurrency',
        'market_price' => 'setMarketPrice',
        'quantity' => 'setQuantity',
        'status4_vo' => 'setStatus4Vo',
        'sub_status4_vo' => 'setSubStatus4Vo',
        'goods_status_change_time' => 'setGoodsStatusChangeTime',
        'crt_time' => 'setCrtTime',
        'spec_name' => 'setSpecName',
        'sku_id_list' => 'setSkuIdList',
        'out_sku_sn_list' => 'setOutSkuSnList',
        'sku_info_list' => 'setSkuInfoList',
        'retail_price' => 'setRetailPrice',
        'list_price' => 'setListPrice',
        'cost_template_id' => 'setCostTemplateId',
        'brand_id' => 'setBrandId',
        'trademark_id' => 'setTrademarkId',
        'low_traffic_tag' => 'setLowTrafficTag',
        'restricted_traffic_tag' => 'setRestrictedTrafficTag',
        'shipment_limit_second' => 'setShipmentLimitSecond',
        'goods_show_sub_status' => 'setGoodsShowSubStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'goods_id' => 'getGoodsId',
        'goods_name' => 'getGoodsName',
        'out_goods_sn' => 'getOutGoodsSn',
        'cat_id' => 'getCatId',
        'thumb_url' => 'getThumbUrl',
        'price' => 'getPrice',
        'currency' => 'getCurrency',
        'market_price' => 'getMarketPrice',
        'quantity' => 'getQuantity',
        'status4_vo' => 'getStatus4Vo',
        'sub_status4_vo' => 'getSubStatus4Vo',
        'goods_status_change_time' => 'getGoodsStatusChangeTime',
        'crt_time' => 'getCrtTime',
        'spec_name' => 'getSpecName',
        'sku_id_list' => 'getSkuIdList',
        'out_sku_sn_list' => 'getOutSkuSnList',
        'sku_info_list' => 'getSkuInfoList',
        'retail_price' => 'getRetailPrice',
        'list_price' => 'getListPrice',
        'cost_template_id' => 'getCostTemplateId',
        'brand_id' => 'getBrandId',
        'trademark_id' => 'getTrademarkId',
        'low_traffic_tag' => 'getLowTrafficTag',
        'restricted_traffic_tag' => 'getRestrictedTrafficTag',
        'shipment_limit_second' => 'getShipmentLimitSecond',
        'goods_show_sub_status' => 'getGoodsShowSubStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('goods_id', $data ?? [], null);
        $this->setIfExists('goods_name', $data ?? [], null);
        $this->setIfExists('out_goods_sn', $data ?? [], null);
        $this->setIfExists('cat_id', $data ?? [], null);
        $this->setIfExists('thumb_url', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('market_price', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('status4_vo', $data ?? [], null);
        $this->setIfExists('sub_status4_vo', $data ?? [], null);
        $this->setIfExists('goods_status_change_time', $data ?? [], null);
        $this->setIfExists('crt_time', $data ?? [], null);
        $this->setIfExists('spec_name', $data ?? [], null);
        $this->setIfExists('sku_id_list', $data ?? [], null);
        $this->setIfExists('out_sku_sn_list', $data ?? [], null);
        $this->setIfExists('sku_info_list', $data ?? [], null);
        $this->setIfExists('cost_template_id', $data ?? [], null);
        $this->setIfExists('brand_id', $data ?? [], null);
        $this->setIfExists('trademark_id', $data ?? [], null);
        $this->setIfExists('low_traffic_tag', $data ?? [], null);
        $this->setIfExists('restricted_traffic_tag', $data ?? [], null);
        $this->setIfExists('shipment_limit_second', $data ?? [], null);
        $this->setIfExists('goods_show_sub_status', $data ?? [], null);

        // Handle nested Price objects for retail_price and list_price
        if (isset($data['retail_price']) || isset($data['retailPrice'])) {
            $retailPriceData = $data['retail_price'] ?? $data['retailPrice'];
            $this->container['retail_price'] = $retailPriceData instanceof Price
                ? $retailPriceData
                : new Price($retailPriceData);
        } else {
            $this->container['retail_price'] = null;
        }

        if (isset($data['list_price']) || isset($data['listPrice'])) {
            $listPriceData = $data['list_price'] ?? $data['listPrice'];
            $this->container['list_price'] = $listPriceData instanceof Price
                ? $listPriceData
                : new Price($listPriceData);
        } else {
            $this->container['list_price'] = null;
        }
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets goods_id
     *
     * @return int|null
     */
    public function getGoodsId()
    {
        return $this->container['goods_id'];
    }

    /**
     * Sets goods_id
     *
     * @param int|null $goods_id goods_id
     *
     * @return self
     */
    public function setGoodsId($goods_id)
    {
        if (is_null($goods_id)) {
            throw new \InvalidArgumentException('non-nullable goods_id cannot be null');
        }
        $this->container['goods_id'] = $goods_id;

        return $this;
    }

    /**
     * Gets goods_name
     *
     * @return string|null
     */
    public function getGoodsName()
    {
        return $this->container['goods_name'];
    }

    /**
     * Sets goods_name
     *
     * @param string|null $goods_name goods_name
     *
     * @return self
     */
    public function setGoodsName($goods_name)
    {
        if (is_null($goods_name)) {
            throw new \InvalidArgumentException('non-nullable goods_name cannot be null');
        }
        $this->container['goods_name'] = $goods_name;

        return $this;
    }

    /**
     * Gets out_goods_sn
     *
     * @return string|null
     */
    public function getOutGoodsSn()
    {
        return $this->container['out_goods_sn'];
    }

    /**
     * Sets out_goods_sn
     *
     * @param string|null $out_goods_sn out_goods_sn
     *
     * @return self
     */
    public function setOutGoodsSn($out_goods_sn)
    {
        if (is_null($out_goods_sn)) {
            throw new \InvalidArgumentException('non-nullable out_goods_sn cannot be null');
        }
        $this->container['out_goods_sn'] = $out_goods_sn;

        return $this;
    }

    /**
     * Gets cat_id
     *
     * @return int|null
     */
    public function getCatId()
    {
        return $this->container['cat_id'];
    }

    /**
     * Sets cat_id
     *
     * @param int|null $cat_id cat_id
     *
     * @return self
     */
    public function setCatId($cat_id)
    {
        if (is_null($cat_id)) {
            throw new \InvalidArgumentException('non-nullable cat_id cannot be null');
        }
        $this->container['cat_id'] = $cat_id;

        return $this;
    }

    /**
     * Gets thumb_url
     *
     * @return string|null
     */
    public function getThumbUrl()
    {
        return $this->container['thumb_url'];
    }

    /**
     * Sets thumb_url
     *
     * @param string|null $thumb_url thumb_url
     *
     * @return self
     */
    public function setThumbUrl($thumb_url)
    {
        if (is_null($thumb_url)) {
            throw new \InvalidArgumentException('non-nullable thumb_url cannot be null');
        }
        $this->container['thumb_url'] = $thumb_url;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets market_price
     *
     * @return int|null
     */
    public function getMarketPrice()
    {
        return $this->container['market_price'];
    }

    /**
     * Sets market_price
     *
     * @param int|null $market_price market_price
     *
     * @return self
     */
    public function setMarketPrice($market_price)
    {
        if (is_null($market_price)) {
            throw new \InvalidArgumentException('non-nullable market_price cannot be null');
        }
        $this->container['market_price'] = $market_price;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets status4_vo
     *
     * @return int|null
     */
    public function getStatus4Vo()
    {
        return $this->container['status4_vo'];
    }

    /**
     * Sets status4_vo
     *
     * @param int|null $status4_vo status4_vo
     *
     * @return self
     */
    public function setStatus4Vo($status4_vo)
    {
        if (is_null($status4_vo)) {
            throw new \InvalidArgumentException('non-nullable status4_vo cannot be null');
        }
        $this->container['status4_vo'] = $status4_vo;

        return $this;
    }

    /**
     * Gets sub_status4_vo
     *
     * @return int|null
     */
    public function getSubStatus4Vo()
    {
        return $this->container['sub_status4_vo'];
    }

    /**
     * Sets sub_status4_vo
     *
     * @param int|null $sub_status4_vo sub_status4_vo
     *
     * @return self
     */
    public function setSubStatus4Vo($sub_status4_vo)
    {
        if (is_null($sub_status4_vo)) {
            throw new \InvalidArgumentException('non-nullable sub_status4_vo cannot be null');
        }
        $this->container['sub_status4_vo'] = $sub_status4_vo;

        return $this;
    }

    /**
     * Gets goods_status_change_time
     *
     * @return string|null
     */
    public function getGoodsStatusChangeTime()
    {
        return $this->container['goods_status_change_time'];
    }

    /**
     * Sets goods_status_change_time
     *
     * @param string|null $goods_status_change_time goods_status_change_time
     *
     * @return self
     */
    public function setGoodsStatusChangeTime($goods_status_change_time)
    {
        if (is_null($goods_status_change_time)) {
            throw new \InvalidArgumentException('non-nullable goods_status_change_time cannot be null');
        }
        $this->container['goods_status_change_time'] = $goods_status_change_time;

        return $this;
    }

    /**
     * Gets crt_time
     *
     * @return int|null
     */
    public function getCrtTime()
    {
        return $this->container['crt_time'];
    }

    /**
     * Sets crt_time
     *
     * @param int|null $crt_time crt_time
     *
     * @return self
     */
    public function setCrtTime($crt_time)
    {
        if (is_null($crt_time)) {
            throw new \InvalidArgumentException('non-nullable crt_time cannot be null');
        }
        $this->container['crt_time'] = $crt_time;

        return $this;
    }

    /**
     * Gets spec_name
     *
     * @return string|null
     */
    public function getSpecName()
    {
        return $this->container['spec_name'];
    }

    /**
     * Sets spec_name
     *
     * @param string|null $spec_name spec_name
     *
     * @return self
     */
    public function setSpecName($spec_name)
    {
        if (is_null($spec_name)) {
            throw new \InvalidArgumentException('non-nullable spec_name cannot be null');
        }
        $this->container['spec_name'] = $spec_name;

        return $this;
    }

    /**
     * Gets sku_id_list
     *
     * @return int[]|null
     */
    public function getSkuIdList()
    {
        return $this->container['sku_id_list'];
    }

    /**
     * Sets sku_id_list
     *
     * @param int[]|null $sku_id_list sku_id_list
     *
     * @return self
     */
    public function setSkuIdList($sku_id_list)
    {
        if (is_null($sku_id_list)) {
            throw new \InvalidArgumentException('non-nullable sku_id_list cannot be null');
        }
        $this->container['sku_id_list'] = $sku_id_list;

        return $this;
    }

    /**
     * Gets out_sku_sn_list
     *
     * @return string[]|null
     */
    public function getOutSkuSnList()
    {
        return $this->container['out_sku_sn_list'];
    }

    /**
     * Sets out_sku_sn_list
     *
     * @param string[]|null $out_sku_sn_list out_sku_sn_list
     *
     * @return self
     */
    public function setOutSkuSnList($out_sku_sn_list)
    {
        if (is_null($out_sku_sn_list)) {
            throw new \InvalidArgumentException('non-nullable out_sku_sn_list cannot be null');
        }
        $this->container['out_sku_sn_list'] = $out_sku_sn_list;

        return $this;
    }

    /**
     * Gets sku_info_list
     *
     * @return array[]|null
     */
    public function getSkuInfoList()
    {
        return $this->container['sku_info_list'];
    }

    /**
     * Sets sku_info_list
     *
     * @param array[]|null $sku_info_list sku_info_list
     *
     * @return self
     */
    public function setSkuInfoList($sku_info_list)
    {
        if (is_null($sku_info_list)) {
            throw new \InvalidArgumentException('non-nullable sku_info_list cannot be null');
        }
        $this->container['sku_info_list'] = $sku_info_list;

        return $this;
    }

    /**
     * Gets retail_price
     *
     * @return \Temu\Model\Price|null
     */
    public function getRetailPrice()
    {
        return $this->container['retail_price'];
    }

    /**
     * Sets retail_price
     *
     * @param \Temu\Model\Price|null $retail_price retail_price
     *
     * @return self
     */
    public function setRetailPrice($retail_price)
    {
        if (is_null($retail_price)) {
            throw new \InvalidArgumentException('non-nullable retail_price cannot be null');
        }
        $this->container['retail_price'] = $retail_price;

        return $this;
    }

    /**
     * Gets list_price
     *
     * @return \Temu\Model\Price|null
     */
    public function getListPrice()
    {
        return $this->container['list_price'];
    }

    /**
     * Sets list_price
     *
     * @param \Temu\Model\Price|null $list_price list_price
     *
     * @return self
     */
    public function setListPrice($list_price)
    {
        if (is_null($list_price)) {
            throw new \InvalidArgumentException('non-nullable list_price cannot be null');
        }
        $this->container['list_price'] = $list_price;

        return $this;
    }

    /**
     * Gets cost_template_id
     *
     * @return string|null
     */
    public function getCostTemplateId()
    {
        return $this->container['cost_template_id'];
    }

    /**
     * Sets cost_template_id
     *
     * @param string|null $cost_template_id cost_template_id
     *
     * @return self
     */
    public function setCostTemplateId($cost_template_id)
    {
        if (is_null($cost_template_id)) {
            throw new \InvalidArgumentException('non-nullable cost_template_id cannot be null');
        }
        $this->container['cost_template_id'] = $cost_template_id;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return int|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param int|null $brand_id brand_id
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        if (is_null($brand_id)) {
            throw new \InvalidArgumentException('non-nullable brand_id cannot be null');
        }
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets trademark_id
     *
     * @return int|null
     */
    public function getTrademarkId()
    {
        return $this->container['trademark_id'];
    }

    /**
     * Sets trademark_id
     *
     * @param int|null $trademark_id trademark_id
     *
     * @return self
     */
    public function setTrademarkId($trademark_id)
    {
        if (is_null($trademark_id)) {
            throw new \InvalidArgumentException('non-nullable trademark_id cannot be null');
        }
        $this->container['trademark_id'] = $trademark_id;

        return $this;
    }

    /**
     * Gets low_traffic_tag
     *
     * @return int|null
     */
    public function getLowTrafficTag()
    {
        return $this->container['low_traffic_tag'];
    }

    /**
     * Sets low_traffic_tag
     *
     * @param int|null $low_traffic_tag low_traffic_tag
     *
     * @return self
     */
    public function setLowTrafficTag($low_traffic_tag)
    {
        if (is_null($low_traffic_tag)) {
            throw new \InvalidArgumentException('non-nullable low_traffic_tag cannot be null');
        }
        $this->container['low_traffic_tag'] = $low_traffic_tag;

        return $this;
    }

    /**
     * Gets restricted_traffic_tag
     *
     * @return int|null
     */
    public function getRestrictedTrafficTag()
    {
        return $this->container['restricted_traffic_tag'];
    }

    /**
     * Sets restricted_traffic_tag
     *
     * @param int|null $restricted_traffic_tag restricted_traffic_tag
     *
     * @return self
     */
    public function setRestrictedTrafficTag($restricted_traffic_tag)
    {
        if (is_null($restricted_traffic_tag)) {
            throw new \InvalidArgumentException('non-nullable restricted_traffic_tag cannot be null');
        }
        $this->container['restricted_traffic_tag'] = $restricted_traffic_tag;

        return $this;
    }

    /**
     * Gets shipment_limit_second
     *
     * @return int|null
     */
    public function getShipmentLimitSecond()
    {
        return $this->container['shipment_limit_second'];
    }

    /**
     * Sets shipment_limit_second
     *
     * @param int|null $shipment_limit_second shipment_limit_second
     *
     * @return self
     */
    public function setShipmentLimitSecond($shipment_limit_second)
    {
        if (is_null($shipment_limit_second)) {
            throw new \InvalidArgumentException('non-nullable shipment_limit_second cannot be null');
        }
        $this->container['shipment_limit_second'] = $shipment_limit_second;

        return $this;
    }

    /**
     * Gets goods_show_sub_status
     *
     * @return int|null
     */
    public function getGoodsShowSubStatus()
    {
        return $this->container['goods_show_sub_status'];
    }

    /**
     * Sets goods_show_sub_status
     *
     * @param int|null $goods_show_sub_status goods_show_sub_status
     *
     * @return self
     */
    public function setGoodsShowSubStatus($goods_show_sub_status)
    {
        if (is_null($goods_show_sub_status)) {
            throw new \InvalidArgumentException('non-nullable goods_show_sub_status cannot be null');
        }
        $this->container['goods_show_sub_status'] = $goods_show_sub_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT) ?: '';

    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue() :string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
