<?php
/**
 * GoodsDetailRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsDetailRequest Class - Request model for getGoodsDetail API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsDetailRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsDetailRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsId' => 'int'
    ];

    protected string $responseClass = GoodsDetailResponse::class;

    public function __construct(int $goodsId)
    {
        parent::__construct();
        $this->setType('bg.local.goods.detail.query');
        $this->setGoodsId($goodsId);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    public function setGoodsId(int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
