<?php
/**
 * GoodsAppealPriceOrderRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsAppealPriceOrderRequest Class - Request model for getGoodsAppealPriceOrder API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsAppealPriceOrderRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsAppealPriceOrderRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsId' => 'int',
        'tabCode' => 'string'
    ];

    protected string $responseClass = GoodsAppealPriceOrderResponse::class;

    public function __construct(int $goodsId, string $tabCode)
    {
        parent::__construct();
        $this->setType('temu.local.goods.appealorder.query');
        $this->setGoodsId($goodsId);
        $this->setTabCode($tabCode);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    public function setGoodsId(int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getTabCode(): ?string
    {
        return $this->container['tabCode'] ?? null;
    }

    public function setTabCode(string $tabCode): self
    {
        $this->container['tabCode'] = $tabCode;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
