<?php
/**
 * GoodsAppealPriceOrderRecordRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsAppealPriceOrderRecordRequest Class - Request model for getGoodsAppealPriceOrderRecord API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsAppealPriceOrderRecordRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsAppealPriceOrderRecordRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'skuId' => 'string'
    ];

    protected string $responseClass = GoodsAppealPriceOrderRecordResponse::class;

    public function __construct(string $skuId)
    {
        parent::__construct();
        $this->setType('temu.local.goods.appealorder.record.query');
        $this->setSkuId($skuId);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getSkuId(): ?string
    {
        return $this->container['skuId'] ?? null;
    }

    public function setSkuId(string $skuId): self
    {
        $this->container['skuId'] = $skuId;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
