<?php
/**
 * CustomOrderDetailRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * CustomOrderDetailRequest Class - Request model for getCustomOrderDetail API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class CustomOrderDetailRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'CustomOrderDetailRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'orderSnList' => 'array'
    ];

    protected string $responseClass = CustomOrderDetailResponse::class;

    public function __construct(array $orderSnList)
    {
        parent::__construct();
        $this->setType('bg.order.customization.get');
        $this->setOrderSnList($orderSnList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getOrderSnList(): ?array
    {
        return $this->container['orderSnList'] ?? null;
    }

    public function setOrderSnList(array $orderSnList): self
    {
        $this->container['orderSnList'] = $orderSnList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
