<?php
/**
 * CreateSpecIdRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * CreateSpecIdRequest Class - Request for CreateSpecId API
 *
 * @category Class
 * @package  Temu
 */
class CreateSpecIdRequest extends BaseRequest
{
    protected string $responseClass = CreateSpecIdResponse::class;

    protected static $openAPITypes = [
        'cat_id' => 'int',
        'parent_spec_id' => 'int',
        'child_spec_name' => 'string'
    ];

    protected static $attributeMap = [
        'cat_id' => 'catId',
        'parent_spec_id' => 'parentSpecId',
        'child_spec_name' => 'childSpecName'
    ];

    public function __construct(
        int $catId,
        int $parentSpecId,
        string $childSpecName
    ) {
        parent::__construct();
        $this->setType('bg.local.goods.spec.id.get');
        $this->setCatId($catId);
        $this->setParentSpecId($parentSpecId);
        $this->setChildSpecName($childSpecName);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getCatId(): int
    {
        return $this->container['cat_id'];
    }

    public function setCatId(int $catId): self
    {
        $this->container['cat_id'] = $catId;
        return $this;
    }

    public function getParentSpecId(): int
    {
        return $this->container['parent_spec_id'];
    }

    public function setParentSpecId(int $parentSpecId): self
    {
        $this->container['parent_spec_id'] = $parentSpecId;
        return $this;
    }

    public function getChildSpecName(): string
    {
        return $this->container['child_spec_name'];
    }

    public function setChildSpecName(string $childSpecName): self
    {
        $this->container['child_spec_name'] = $childSpecName;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
