<?php
/**
 * CreateGoodsRequestAllOfGoodsBasic
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Temu Open APIs
 *
 * Comprehensive API collection for Temu marketplace operations including product management, order processing, inventory management, pricing, and fulfillment services.  All endpoints use POST method with operation type specified in request body. Authentication uses MD5 signature with app_key, app_secret, access_token, and timestamp.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.1.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Temu\Model;

use \ArrayAccess;
use \Temu\ObjectSerializer;

/**
 * CreateGoodsRequestAllOfGoodsBasic Class Doc Comment
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateGoodsRequestAllOfGoodsBasic implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateGoodsRequest_allOf_goodsBasic';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'cat_id' => 'int',
        'goods_name' => 'string',
        'brand_id' => 'int',
        'trademark_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'cat_id' => null,
        'goods_name' => null,
        'brand_id' => null,
        'trademark_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'cat_id' => false,
		'goods_name' => false,
		'brand_id' => false,
		'trademark_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'cat_id' => 'catId',
        'goods_name' => 'goodsName',
        'brand_id' => 'brandId',
        'trademark_id' => 'trademarkId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'cat_id' => 'setCatId',
        'goods_name' => 'setGoodsName',
        'brand_id' => 'setBrandId',
        'trademark_id' => 'setTrademarkId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'cat_id' => 'getCatId',
        'goods_name' => 'getGoodsName',
        'brand_id' => 'getBrandId',
        'trademark_id' => 'getTrademarkId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('cat_id', $data ?? [], null);
        $this->setIfExists('goods_name', $data ?? [], null);
        $this->setIfExists('brand_id', $data ?? [], null);
        $this->setIfExists('trademark_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets cat_id
     *
     * @return int|null
     */
    public function getCatId()
    {
        return $this->container['cat_id'];
    }

    /**
     * Sets cat_id
     *
     * @param int|null $cat_id cat_id
     *
     * @return self
     */
    public function setCatId($cat_id)
    {
        if (is_null($cat_id)) {
            throw new \InvalidArgumentException('non-nullable cat_id cannot be null');
        }
        $this->container['cat_id'] = $cat_id;

        return $this;
    }

    /**
     * Gets goods_name
     *
     * @return string|null
     */
    public function getGoodsName()
    {
        return $this->container['goods_name'];
    }

    /**
     * Sets goods_name
     *
     * @param string|null $goods_name goods_name
     *
     * @return self
     */
    public function setGoodsName($goods_name)
    {
        if (is_null($goods_name)) {
            throw new \InvalidArgumentException('non-nullable goods_name cannot be null');
        }
        $this->container['goods_name'] = $goods_name;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return int|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param int|null $brand_id brand_id
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        if (is_null($brand_id)) {
            throw new \InvalidArgumentException('non-nullable brand_id cannot be null');
        }
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets trademark_id
     *
     * @return int|null
     */
    public function getTrademarkId()
    {
        return $this->container['trademark_id'];
    }

    /**
     * Sets trademark_id
     *
     * @param int|null $trademark_id trademark_id
     *
     * @return self
     */
    public function setTrademarkId($trademark_id)
    {
        if (is_null($trademark_id)) {
            throw new \InvalidArgumentException('non-nullable trademark_id cannot be null');
        }
        $this->container['trademark_id'] = $trademark_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT) ?: '';

    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue() :string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}


