<?php
/**
 * CreateGoodsAppealPriceOrderRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * CreateGoodsAppealPriceOrderRequest Class - Request model for createGoodsAppealPriceOrder API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class CreateGoodsAppealPriceOrderRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'CreateGoodsAppealPriceOrderRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsId' => 'int',
        'merchantAppealReasonCodeList' => 'array',
        'skuInfoList' => 'array'
    ];

    protected string $responseClass = CreateGoodsAppealPriceOrderResponse::class;

    public function __construct(int $goodsId, array $merchantAppealReasonCodeList, array $skuInfoList)
    {
        parent::__construct();
        $this->setType('temu.local.goods.appealorder.create');
        $this->setGoodsId($goodsId);
        $this->setMerchantAppealReasonCodeList($merchantAppealReasonCodeList);
        $this->setSkuInfoList($skuInfoList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    public function setGoodsId(int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getMerchantAppealReasonCodeList(): ?array
    {
        return $this->container['merchantAppealReasonCodeList'] ?? null;
    }

    public function setMerchantAppealReasonCodeList(array $merchantAppealReasonCodeList): self
    {
        $this->container['merchantAppealReasonCodeList'] = $merchantAppealReasonCodeList;
        return $this;
    }

    public function getSkuInfoList(): ?array
    {
        return $this->container['skuInfoList'] ?? null;
    }

    public function setSkuInfoList(array $skuInfoList): self
    {
        $this->container['skuInfoList'] = $skuInfoList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
