<?php
/**
 * ConfirmShipLaterPackagesShippedRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * ConfirmShipLaterPackagesShippedRequest Class - Request for ConfirmShipLaterPackagesShipped API
 *
 * @category Class
 * @package  Temu
 */
class ConfirmShipLaterPackagesShippedRequest extends BaseRequest
{
    protected string $responseClass = ConfirmShipLaterPackagesShippedResponse::class;

    protected static $openAPITypes = [
        'package_send_info_list' => 'array'
    ];

    protected static $attributeMap = [
        'package_send_info_list' => 'packageSendInfoList'
    ];

    public function __construct(array $packageSendInfoList)
    {
        parent::__construct();
        $this->setType('bg.logistics.shipped.package.confirm');
        $this->setPackageSendInfoList($packageSendInfoList);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getPackageSendInfoList(): array
    {
        return $this->container['package_send_info_list'];
    }

    public function setPackageSendInfoList(array $packageSendInfoList): self
    {
        $this->container['package_send_info_list'] = $packageSendInfoList;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
