<?php
/**
 * ConfirmOrderShipmentRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * ConfirmOrderShipmentRequest Class - Request model for confirmOrderShipment API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class ConfirmOrderShipmentRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'ConfirmOrderShipmentRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'sendRequestList' => 'array',
        'sendType' => 'int'
    ];

    protected string $responseClass = ConfirmOrderShipmentResponse::class;

    public function __construct(array $sendRequestList, int $sendType = 0)
    {
        parent::__construct();
        $this->setType('bg.logistics.shipment.v2.confirm');
        $this->setSendRequestList($sendRequestList);
        $this->setSendType($sendType);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getSendRequestList(): ?array
    {
        return $this->container['sendRequestList'] ?? null;
    }

    public function setSendRequestList(array $sendRequestList): self
    {
        $this->container['sendRequestList'] = $sendRequestList;
        return $this;
    }

    public function getSendType(): ?int
    {
        return $this->container['sendType'] ?? null;
    }

    public function setSendType(int $sendType): self
    {
        $this->container['sendType'] = $sendType;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
