<?php
/**
 * AvailableBrandAndTrademarkRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * AvailableBrandAndTrademarkRequest Class - Request for GetAvailableBrandAndTrademark API
 *
 * @category Class
 * @package  Temu
 */
class AvailableBrandAndTrademarkRequest extends BaseRequest
{
    protected string $responseClass = AvailableBrandAndTrademarkResponse::class;

    protected static $openAPITypes = [
        'brand_id' => 'int',
        'page' => 'int',
        'size' => 'int'
    ];

    protected static $attributeMap = [
        'brand_id' => 'brandId',
        'page' => 'page',
        'size' => 'size'
    ];

    public function __construct(int $brandId, int $page = 1, int $size = 25)
    {
        parent::__construct();
        $this->setType('bg.local.goods.brand.trademark.get');
        $this->setBrandId($brandId);
        $this->setPage($page);
        $this->setSize($size);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getBrandId(): int
    {
        return $this->container['brand_id'];
    }

    public function setBrandId(int $brandId): self
    {
        $this->container['brand_id'] = $brandId;
        return $this;
    }

    public function getPage(): int
    {
        return $this->container['page'];
    }

    public function setPage(int $page): self
    {
        $this->container['page'] = $page;
        return $this;
    }

    public function getSize(): int
    {
        return $this->container['size'];
    }

    public function setSize(int $size): self
    {
        $this->container['size'] = $size;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
