<?php
/**
 * AftersaleOrderListRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * AftersaleOrderListRequest Class - Request for GetAftersaleOrderList API
 *
 * @category Class
 * @package  Temu
 */
class AftersaleOrderListRequest extends BaseRequest
{
    protected string $responseClass = AftersaleOrderListResponse::class;

    protected static $openAPITypes = [
        'page_no' => 'int',
        'page_size' => 'int',
        'parent_after_sales_sn_list' => 'array'
    ];

    protected static $attributeMap = [
        'page_no' => 'pageNo',
        'page_size' => 'pageSize',
        'parent_after_sales_sn_list' => 'parentAfterSalesSnList'
    ];

    public function __construct(
        int $pageNo,
        int $pageSize,
        array $parentAfterSalesSnList = []
    ) {
        parent::__construct();
        $this->setType('bg.aftersales.aftersales.list.get');
        $this->setPageNo($pageNo);
        $this->setPageSize($pageSize);
        if (!empty($parentAfterSalesSnList)) {
            $this->setParentAfterSalesSnList($parentAfterSalesSnList);
        }
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getPageNo(): int
    {
        return $this->container['page_no'];
    }

    public function setPageNo(int $pageNo): self
    {
        $this->container['page_no'] = $pageNo;
        return $this;
    }

    public function getPageSize(): int
    {
        return $this->container['page_size'];
    }

    public function setPageSize(int $pageSize): self
    {
        $this->container['page_size'] = $pageSize;
        return $this;
    }

    public function getParentAfterSalesSnList(): ?array
    {
        return $this->container['parent_after_sales_sn_list'] ?? [];
    }

    public function setParentAfterSalesSnList(array $parentAfterSalesSnList): self
    {
        $this->container['parent_after_sales_sn_list'] = $parentAfterSalesSnList;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
