<?php
/**
 * AddressWarning
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * AddressWarning Class - Address restriction warning information
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class AddressWarning implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;
    protected static string $openAPIModelName = 'AddressWarning';

    protected static array $openAPITypes = [
        'isRestriction' => 'bool',
        'reason' => 'int'
    ];

    protected static array $openAPIFormats = [
        'isRestriction' => null,
        'reason' => null
    ];

    protected static array $openAPINullables = [
        'isRestriction' => false,
        'reason' => false
    ];

    protected array $openAPINullablesSetToNull = [];

    protected static array $attributeMap = [
        'isRestriction' => 'isRestriction',
        'reason' => 'reason'
    ];

    protected static array $setters = [
        'isRestriction' => 'setIsRestriction',
        'reason' => 'setReason'
    ];

    protected static array $getters = [
        'isRestriction' => 'getIsRestriction',
        'reason' => 'getReason'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->setIfExists('isRestriction', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
    }

    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }
        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return self::$openAPIFormats; }
    protected static function openAPINullables(): array { return self::$openAPINullables; }
    public static function isNullable(string $property): bool { return self::openAPINullables()[$property] ?? false; }
    public function isNullableSetToNull(string $property): bool { return in_array($property, $this->openAPINullablesSetToNull, true); }
    public static function attributeMap(): array { return self::$attributeMap; }
    public static function setters(): array { return self::$setters; }
    public static function getters(): array { return self::$getters; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return count($this->listInvalidProperties()) === 0; }

    public function getIsRestriction(): ?bool { return $this->container['isRestriction']; }
    public function setIsRestriction(?bool $isRestriction): self { $this->container['isRestriction'] = $isRestriction; return $this; }
    public function getReason(): ?int { return $this->container['reason']; }
    public function setReason(?int $reason): self { $this->container['reason'] = $reason; return $this; }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize() { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString() { return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT); }
    public function toHeaderValue() { return json_encode(ObjectSerializer::sanitizeForSerialization($this)); }
}
