<?php
/**
 * AcceptGoodsPriceOrderRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * AcceptGoodsPriceOrderRequest Class - Request model for acceptGoodsPriceOrder API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class AcceptGoodsPriceOrderRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'AcceptGoodsPriceOrderRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'priceOrderInfoList' => 'array'
    ];

    protected string $responseClass = AcceptGoodsPriceOrderResponse::class;

    public function __construct(array $priceOrderInfoList)
    {
        parent::__construct();
        $this->setType('bg.local.goods.priceorder.accept');
        $this->setPriceOrderInfoList($priceOrderInfoList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getPriceOrderInfoList(): ?array
    {
        return $this->container['priceOrderInfoList'] ?? null;
    }

    public function setPriceOrderInfoList(array $priceOrderInfoList): self
    {
        $this->container['priceOrderInfoList'] = $priceOrderInfoList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
