<?php
/**
 * Configuration
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Temu Open APIs
 *
 * Comprehensive API collection for Temu marketplace operations including product management, order processing, inventory management, pricing, and fulfillment services.  All endpoints use POST method with operation type specified in request body. Authentication uses MD5 signature with app_key, app_secret, access_token, and timestamp.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.1.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Temu;

/**
 * Configuration Class Doc Comment
 * PHP version 8.1
 *
 * Configuration class for Temu Open API SDK
 *
 * This class manages all configuration settings for the Temu API client including:
 * - API endpoints for different regions (US, EU, APAC)
 * - Authentication credentials (access tokens, API keys)
 * - HTTP client settings (user agent, debug mode)
 * - Environment selection (production, sandbox)
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 *
 * @example Basic Usage
 * ```php
 * use Temu\Configuration;
 * use Temu\Api\OrderManagementApi;
 *
 * // Create configuration for US production
 * $config = new Configuration();
 * $config->setAccessToken('your-access-token-here');
 *
 * // Use with API client
 * $orderApi = new OrderManagementApi(null, $config);
 * $orders = $orderApi->getOrderList(1, 840);
 * ```
 *
 * @example Regional Endpoints
 * ```php
 * // EU Production
 * $config = new Configuration();
 * $config->setHostByRegion(Configuration::REGION_EU);
 * $config->setAccessToken('your-token');
 *
 * // APAC Production
 * $config->setHostByRegion(Configuration::REGION_APAC);
 *
 * // US Sandbox for Testing
 * $config->setHostByRegion(Configuration::REGION_US, true);
 * ```
 *
 * @example Debug Mode
 * ```php
 * $config = new Configuration();
 * $config->setDebug(true);
 * $config->setDebugFile('/path/to/debug.log');
 * ```
 */
class Configuration
{
    /**
     * Boolean format for query strings - integer representation (0 or 1)
     */
    public const BOOLEAN_FORMAT_INT = 'int';

    /**
     * Boolean format for query strings - string representation ('true' or 'false')
     */
    public const BOOLEAN_FORMAT_STRING = 'string';

    // ========================================
    // Regional Endpoint Constants
    // ========================================

    /**
     * Host index for US Production Server
     * Endpoint: https://openapi-b-us.temu.com/openapi/router
     */
    public const HOST_US_PRODUCTION = 0;

    /**
     * Host index for EU Production Server
     * Endpoint: https://openapi-b-eu.temu.com/openapi/router
     */
    public const HOST_EU_PRODUCTION = 1;

    /**
     * Host index for APAC Production Server
     * Endpoint: https://openapi-b-ap.temu.com/openapi/router
     */
    public const HOST_APAC_PRODUCTION = 2;

    /**
     * Host index for US Sandbox/Testing Server
     * Endpoint: https://openapi-sandbox-us.temu.com/openapi/router
     */
    public const HOST_US_SANDBOX = 3;

    // ========================================
    // Region Code Constants
    // ========================================

    /**
     * Region code for United States / North America
     */
    public const REGION_US = 'us';

    /**
     * Region code for Europe
     */
    public const REGION_EU = 'eu';

    /**
     * Region code for Asia Pacific
     */
    public const REGION_APAC = 'ap';

    /**
     * @var Configuration
     */
    private static $defaultConfiguration;

    /**
     * Associate array to store API key(s)
     *
     * @var string[]
     */
    protected $apiKeys = [];

    /**
     * Associate array to store API prefix (e.g. Bearer)
     *
     * @var string[]
     */
    protected $apiKeyPrefixes = [];

    /**
     * Access token for OAuth/Bearer authentication
     *
     * @var string
     */
    protected $accessToken = '';

    /**
     * Boolean format for query string
     *
     * @var string
     */
    protected $booleanFormatForQueryString = self::BOOLEAN_FORMAT_INT;

    /**
     * Username for HTTP basic authentication
     *
     * @var string
     */
    protected $username = '';

    /**
     * Password for HTTP basic authentication
     *
     * @var string
     */
    protected $password = '';

    /**
     * The host
     *
     * @var string
     */
    protected $host = 'https://openapi-b-us.temu.com/openapi/router';

    /**
     * User agent of the HTTP request, set to "OpenAPI-Generator/{version}/PHP" by default
     *
     * @var string
     */
    protected $userAgent = 'OpenAPI-Generator/1.0/PHP';

    /**
     * Debug switch (default set to false)
     *
     * @var bool
     */
    protected $debug = false;

    /**
     * Debug file location (log to STDOUT by default)
     *
     * @var string
     */
    protected $debugFile = 'php://output';

    /**
     * Debug file location (log to STDOUT by default)
     *
     * @var string
     */
    protected $tempFolderPath;

    /**
     * Constructor
     *
     * Initializes a new Configuration instance with default settings:
     * - Default host: US Production (https://openapi-b-us.temu.com/openapi/router)
     * - Default temp folder: System temp directory
     * - Debug mode: Disabled
     *
     * @example
     * ```php
     * $config = new Configuration();
     * $config->setAccessToken('your-token');
     * $config->setHostByRegion(Configuration::REGION_EU);
     * ```
     */
    public function __construct()
    {
        $this->tempFolderPath = sys_get_temp_dir();
    }

    /**
     * Sets API key
     *
     * @param string $apiKeyIdentifier API key identifier (authentication scheme)
     * @param string $key              API key or token
     *
     * @return $this
     */
    public function setApiKey($apiKeyIdentifier, $key)
    {
        $this->apiKeys[$apiKeyIdentifier] = $key;
        return $this;
    }

    /**
     * Gets API key
     *
     * @param string $apiKeyIdentifier API key identifier (authentication scheme)
     *
     * @return null|string API key or token
     */
    public function getApiKey($apiKeyIdentifier)
    {
        return isset($this->apiKeys[$apiKeyIdentifier]) ? $this->apiKeys[$apiKeyIdentifier] : null;
    }

    /**
     * Sets the prefix for API key (e.g. Bearer)
     *
     * @param string $apiKeyIdentifier API key identifier (authentication scheme)
     * @param string $prefix           API key prefix, e.g. Bearer
     *
     * @return $this
     */
    public function setApiKeyPrefix($apiKeyIdentifier, $prefix)
    {
        $this->apiKeyPrefixes[$apiKeyIdentifier] = $prefix;
        return $this;
    }

    /**
     * Gets API key prefix
     *
     * @param string $apiKeyIdentifier API key identifier (authentication scheme)
     *
     * @return null|string
     */
    public function getApiKeyPrefix($apiKeyIdentifier)
    {
        return isset($this->apiKeyPrefixes[$apiKeyIdentifier]) ? $this->apiKeyPrefixes[$apiKeyIdentifier] : null;
    }

    /**
     * Sets the access token for OAuth/Bearer authentication
     *
     * The access token is required for all Temu API requests and should be obtained
     * through the OAuth authorization flow using the AuthorizationApi.
     *
     * @param string $accessToken Access token obtained from Temu OAuth
     *
     * @return $this
     *
     * @see \Temu\Api\AuthorizationApi::createAccessToken()
     *
     * @example
     * ```php
     * $config->setAccessToken('eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...');
     * ```
     */
    public function setAccessToken($accessToken)
    {
        $this->accessToken = $accessToken;
        return $this;
    }

    /**
     * Gets the access token for OAuth
     *
     * @return string Access token for OAuth
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }

    /**
     * Sets boolean format for query string.
     *
     * @param string $booleanFormatForQueryString Boolean format for query string
     *
     * @return $this
     */
    public function setBooleanFormatForQueryString(string $booleanFormat)
    {
        $this->booleanFormatForQueryString = $booleanFormat;

        return $this;
    }

    /**
     * Gets boolean format for query string.
     *
     * @return string Boolean format for query string
     */
    public function getBooleanFormatForQueryString(): string
    {
        return $this->booleanFormatForQueryString;
    }

    /**
     * Sets the username for HTTP basic authentication
     *
     * @param string $username Username for HTTP basic authentication
     *
     * @return $this
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * Gets the username for HTTP basic authentication
     *
     * @return string Username for HTTP basic authentication
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * Sets the password for HTTP basic authentication
     *
     * @param string $password Password for HTTP basic authentication
     *
     * @return $this
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * Gets the password for HTTP basic authentication
     *
     * @return string Password for HTTP basic authentication
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Sets the host
     *
     * @param string $host Host
     *
     * @return $this
     */
    public function setHost($host)
    {
        $this->host = $host;
        return $this;
    }

    /**
     * Gets the host
     *
     * @return string Host
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * Sets the API host endpoint by region code
     *
     * This is the recommended way to configure the API endpoint. It automatically
     * selects the correct regional endpoint URL based on your target market.
     *
     * Available regions:
     * - Configuration::REGION_US (or 'us') - United States / North America
     * - Configuration::REGION_EU (or 'eu') - Europe
     * - Configuration::REGION_APAC (or 'ap') - Asia Pacific
     *
     * @param string $region Region code (use REGION_* constants or 'us', 'eu', 'ap')
     * @param bool $sandbox Set to true to use sandbox/testing environment (US only)
     *
     * @return $this
     *
     * @throws \InvalidArgumentException If invalid region code is provided
     *
     * @example Production Endpoints
     * ```php
     * // US Production
     * $config->setHostByRegion(Configuration::REGION_US);
     *
     * // EU Production
     * $config->setHostByRegion(Configuration::REGION_EU);
     *
     * // APAC Production
     * $config->setHostByRegion(Configuration::REGION_APAC);
     * ```
     *
     * @example Sandbox Environment
     * ```php
     * // US Sandbox for testing
     * $config->setHostByRegion(Configuration::REGION_US, true);
     * ```
     */
    public function setHostByRegion(string $region, bool $sandbox = false)
    {
        $hostSettings = $this->getHostSettings();

        if ($sandbox && $region === self::REGION_US) {
            $this->host = $hostSettings[self::HOST_US_SANDBOX]['url'];
        } else {
            switch (strtolower($region)) {
                case self::REGION_US:
                    $this->host = $hostSettings[self::HOST_US_PRODUCTION]['url'];
                    break;
                case self::REGION_EU:
                    $this->host = $hostSettings[self::HOST_EU_PRODUCTION]['url'];
                    break;
                case self::REGION_APAC:
                    $this->host = $hostSettings[self::HOST_APAC_PRODUCTION]['url'];
                    break;
                default:
                    throw new \InvalidArgumentException("Invalid region: $region. Must be one of: us, eu, ap");
            }
        }

        return $this;
    }

    /**
     * Sets the API host endpoint by numeric index
     *
     * Alternative way to set the endpoint using the host index directly.
     * Use setHostByRegion() for a more readable approach.
     *
     * Available indices:
     * - 0 (HOST_US_PRODUCTION) - US Production
     * - 1 (HOST_EU_PRODUCTION) - EU Production
     * - 2 (HOST_APAC_PRODUCTION) - APAC Production
     * - 3 (HOST_US_SANDBOX) - US Sandbox/Testing
     *
     * @param int $hostIndex Host index from 0 to 3 (use HOST_* constants)
     *
     * @return $this
     *
     * @throws \InvalidArgumentException If host index is out of bounds
     *
     * @example
     * ```php
     * $config->setHostByIndex(Configuration::HOST_EU_PRODUCTION);
     * $config->setHostByIndex(Configuration::HOST_US_SANDBOX);
     * ```
     */
    public function setHostByIndex(int $hostIndex)
    {
        $hostSettings = $this->getHostSettings();

        if ($hostIndex < 0 || $hostIndex >= count($hostSettings)) {
            throw new \InvalidArgumentException(
                "Invalid host index: $hostIndex. Must be between 0 and " . (count($hostSettings) - 1)
            );
        }

        $this->host = $hostSettings[$hostIndex]['url'];
        return $this;
    }

    /**
     * Sets the user agent of the api client
     *
     * @param string $userAgent the user agent of the api client
     *
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setUserAgent($userAgent)
    {
        if (!is_string($userAgent)) {
            throw new \InvalidArgumentException('User-agent must be a string.');
        }

        $this->userAgent = $userAgent;
        return $this;
    }

    /**
     * Gets the user agent of the api client
     *
     * @return string user agent
     */
    public function getUserAgent()
    {
        return $this->userAgent;
    }

    /**
     * Sets debug flag
     *
     * @param bool $debug Debug flag
     *
     * @return $this
     */
    public function setDebug($debug)
    {
        $this->debug = $debug;
        return $this;
    }

    /**
     * Gets the debug flag
     *
     * @return bool
     */
    public function getDebug()
    {
        return $this->debug;
    }

    /**
     * Sets the debug file
     *
     * @param string $debugFile Debug file
     *
     * @return $this
     */
    public function setDebugFile($debugFile)
    {
        $this->debugFile = $debugFile;
        return $this;
    }

    /**
     * Gets the debug file
     *
     * @return string
     */
    public function getDebugFile()
    {
        return $this->debugFile;
    }

    /**
     * Sets the temp folder path
     *
     * @param string $tempFolderPath Temp folder path
     *
     * @return $this
     */
    public function setTempFolderPath($tempFolderPath)
    {
        $this->tempFolderPath = $tempFolderPath;
        return $this;
    }

    /**
     * Gets the temp folder path
     *
     * @return string Temp folder path
     */
    public function getTempFolderPath()
    {
        return $this->tempFolderPath;
    }

    /**
     * Gets the default configuration instance
     *
     * @return Configuration
     */
    public static function getDefaultConfiguration()
    {
        if (self::$defaultConfiguration === null) {
            self::$defaultConfiguration = new Configuration();
        }

        return self::$defaultConfiguration;
    }

    /**
     * Sets the default configuration instance
     *
     * @param Configuration $config An instance of the Configuration Object
     *
     * @return void
     */
    public static function setDefaultConfiguration(Configuration $config)
    {
        self::$defaultConfiguration = $config;
    }

    /**
     * Gets the essential information for debugging
     *
     * @return string The report for debugging
     */
    public static function toDebugReport()
    {
        $report  = 'PHP SDK (Temu) Debug Report:' . PHP_EOL;
        $report .= '    OS: ' . php_uname() . PHP_EOL;
        $report .= '    PHP Version: ' . PHP_VERSION . PHP_EOL;
        $report .= '    The version of the OpenAPI document: 1.0.0' . PHP_EOL;
        $report .= '    SDK Package Version: 1.0' . PHP_EOL;
        $report .= '    Temp Folder Path: ' . self::getDefaultConfiguration()->getTempFolderPath() . PHP_EOL;

        return $report;
    }

    /**
     * Get API key (with prefix if set)
     *
     * @param  string $apiKeyIdentifier name of apikey
     *
     * @return null|string API key with the prefix
     */
    public function getApiKeyWithPrefix($apiKeyIdentifier)
    {
        $prefix = $this->getApiKeyPrefix($apiKeyIdentifier);
        $apiKey = $this->getApiKey($apiKeyIdentifier);

        if ($apiKey === null) {
            return null;
        }

        if ($prefix === null) {
            $keyWithPrefix = $apiKey;
        } else {
            $keyWithPrefix = $prefix . ' ' . $apiKey;
        }

        return $keyWithPrefix;
    }

    /**
     * Returns an array of all available host/endpoint settings
     *
     * Each host setting contains:
     * - url: The full API endpoint URL
     * - description: Human-readable description of the endpoint
     *
     * Available endpoints:
     * - Index 0: US Production Server (default)
     * - Index 1: EU Production Server
     * - Index 2: APAC Production Server
     * - Index 3: US Sandbox Server
     *
     * @return array<int, array{url: string, description: string}> Array of host settings
     *
     * @example
     * ```php
     * $hosts = $config->getHostSettings();
     * foreach ($hosts as $index => $host) {
     *     echo "$index: {$host['description']} - {$host['url']}\n";
     * }
     * ```
     */
    public function getHostSettings()
    {
        return [
            [
                "url" => "https://openapi-b-us.temu.com/openapi/router",
                "description" => "US Production Server - North America region",
            ],
            [
                "url" => "https://openapi-b-eu.temu.com/openapi/router",
                "description" => "EU Production Server - European region",
            ],
            [
                "url" => "https://openapi-b-ap.temu.com/openapi/router",
                "description" => "APAC Production Server - Asia Pacific region",
            ],
            [
                "url" => "https://openapi-sandbox-us.temu.com/openapi/router",
                "description" => "US Sandbox Server - Testing environment",
            ]
        ];
    }

    /**
    * Returns URL based on host settings, index and variables
    *
    * @param array      $hostSettings array of host settings, generated from getHostSettings() or equivalent from the API clients
    * @param int        $hostIndex    index of the host settings
    * @param array|null $variables    hash of variable and the corresponding value (optional)
    * @return string URL based on host settings
    */
    public static function getHostString(array $hostsSettings, int $hostIndex, ?array $variables = null)
    {
        if (null === $variables) {
            $variables = [];
        }

        // check array index out of bound
        if ($hostIndex < 0 || $hostIndex >= count($hostsSettings)) {
            throw new \InvalidArgumentException("Invalid index $hostIndex when selecting the host. Must be less than ".count($hostsSettings));
        }

        $host = $hostsSettings[$hostIndex];
        $url = $host["url"];

        // go through variable and assign a value
        foreach ($host["variables"] ?? [] as $name => $variable) {
            if (array_key_exists($name, $variables)) { // check to see if it's in the variables provided by the user
                if (!isset($variable['enum_values']) || in_array($variables[$name], $variable["enum_values"], true)) { // check to see if the value is in the enum
                    $url = str_replace("{".$name."}", $variables[$name], $url);
                } else {
                    throw new \InvalidArgumentException("The variable `$name` in the host URL has invalid value ".$variables[$name].". Must be ".join(',', $variable["enum_values"]).".");
                }
            } else {
                // use default value
                $url = str_replace("{".$name."}", $variable["default_value"], $url);
            }
        }

        return $url;
    }

    /**
     * Returns URL based on the index and variables
     *
     * @param int        $index     index of the host settings
     * @param array|null $variables hash of variable and the corresponding value (optional)
     * @return string URL based on host settings
     */
    public function getHostFromSettings(int $index, ?array $variables = null)
    {
        return self::getHostString($this->getHostSettings(), $index, $variables);
    }
}
