<?php
/**
 * ApiException
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Temu Open APIs
 *
 * Comprehensive API collection for Temu marketplace operations including product management, order processing, inventory management, pricing, and fulfillment services.  All endpoints use POST method with operation type specified in request body. Authentication uses MD5 signature with app_key, app_secret, access_token, and timestamp.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.1.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Temu;

use \Exception;

/**
 * ApiException Class Doc Comment
 *
 * Custom exception class for Temu API HTTP errors.
 *
 * This exception is thrown when API requests fail at the HTTP level (network errors,
 * invalid status codes, etc.). It provides access to the full HTTP response including
 * headers, body, and status code for detailed error handling and debugging.
 *
 * For API-level errors (where HTTP request succeeds but API returns an error), check
 * the BaseResponse::success field and BaseResponse::error_code instead.
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 *
 * @example Basic Exception Handling
 * ```php
 * try {
 *     $response = $api->getGoodsList($request);
 * } catch (ApiException $e) {
 *     echo "HTTP Status: " . $e->getCode() . "\n";
 *     echo "Message: " . $e->getMessage() . "\n";
 *     echo "Response Body: " . $e->getResponseBody() . "\n";
 * }
 * ```
 *
 * @example Accessing Response Headers
 * ```php
 * try {
 *     $response = $api->createGoods($request);
 * } catch (ApiException $e) {
 *     $headers = $e->getResponseHeaders();
 *     if (isset($headers['X-RateLimit-Remaining'])) {
 *         echo "Rate limit remaining: " . $headers['X-RateLimit-Remaining'];
 *     }
 * }
 * ```
 *
 * @example Retry Logic with Exception Handling
 * ```php
 * $maxRetries = 3;
 * $attempt = 0;
 *
 * while ($attempt < $maxRetries) {
 *     try {
 *         return $api->updateInventory($request);
 *     } catch (ApiException $e) {
 *         $statusCode = $e->getCode();
 *         // Retry on server errors or rate limiting
 *         if ($statusCode >= 500 || $statusCode === 429) {
 *             $attempt++;
 *             if ($attempt < $maxRetries) {
 *                 sleep(pow(2, $attempt)); // Exponential backoff
 *                 continue;
 *             }
 *         }
 *         throw $e;
 *     }
 * }
 * ```
 */
class ApiException extends Exception
{
    /**
     * The HTTP body of the server response either as Json or string.
     *
     * Contains the raw response body from the API server. This may be:
     * - JSON object (\stdClass) if response was valid JSON
     * - String if response was plain text or malformed JSON
     * - null if response had no body
     *
     * @var \stdClass|string|null
     */
    protected $responseBody;

    /**
     * The HTTP header of the server response.
     *
     * Associative array of HTTP response headers. Useful for accessing
     * rate limit information, request IDs, and other metadata.
     *
     * Common headers:
     * - X-Request-Id: Unique identifier for the request
     * - X-RateLimit-Limit: Maximum requests allowed
     * - X-RateLimit-Remaining: Remaining requests in current window
     * - Content-Type: Response content type
     *
     * @var string[]|null
     */
    protected $responseHeaders;

    /**
     * The deserialized response object
     *
     * Contains the response object after deserialization attempt. Used internally
     * during the deserialization process to capture partially deserialized data
     * when an exception occurs.
     *
     * @var \stdClass|string|null
     */
    protected $responseObject;

    /**
     * Constructor
     *
     * @param string                $message         Error message
     * @param int                   $code            HTTP status code
     * @param string[]|null         $responseHeaders HTTP response header
     * @param \stdClass|string|null $responseBody    HTTP decoded body of the server response either as \stdClass or string
     */
    public function __construct($message = "", $code = 0, $responseHeaders = [], $responseBody = null)
    {
        parent::__construct($message, $code);
        $this->responseHeaders = $responseHeaders;
        $this->responseBody = $responseBody;
    }

    /**
     * Gets the HTTP response header
     *
     * @return string[]|null HTTP response header
     */
    public function getResponseHeaders()
    {
        return $this->responseHeaders;
    }

    /**
     * Gets the HTTP body of the server response either as Json or string
     *
     * @return \stdClass|string|null HTTP body of the server response either as \stdClass or string
     */
    public function getResponseBody()
    {
        return $this->responseBody;
    }

    /**
     * Sets the deserialized response object (during deserialization)
     *
     * @param mixed $obj Deserialized response object
     *
     * @return void
     */
    public function setResponseObject($obj)
    {
        $this->responseObject = $obj;
    }

    /**
     * Gets the deserialized response object (during deserialization)
     *
     * @return mixed the deserialized response object
     */
    public function getResponseObject()
    {
        return $this->responseObject;
    }
}
