<?php
/**
 * RefundAndReturnApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Api;

use Temu\ApiException;
use Temu\Model\ParentAftersaleOrderListRequest;
use Temu\Model\ParentAftersaleOrderListResponse;
use Temu\Model\AftersaleOrderListRequest;
use Temu\Model\AftersaleOrderListResponse;
use Temu\Model\ReturnOrderListRequest;
use Temu\Model\ReturnOrderListResponse;

/**
 * RefundAndReturnApi Class
 */
class RefundAndReturnApi extends DefaultApi
{
    /**
     * Get parent aftersale order list
     *
     * @param ParentAftersaleOrderListRequest $request Request object with parent aftersale order parameters
     * @return ParentAftersaleOrderListResponse
     * @throws ApiException
     */
    public function getParentAftersaleOrderList(ParentAftersaleOrderListRequest $request): ParentAftersaleOrderListResponse
    {
        /** @var ParentAftersaleOrderListResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get aftersale order list
     *
     * @param AftersaleOrderListRequest $request Request object with aftersale order parameters
     * @return AftersaleOrderListResponse
     * @throws ApiException
     */
    public function getAftersaleOrderList(AftersaleOrderListRequest $request): AftersaleOrderListResponse
    {
        /** @var AftersaleOrderListResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get return order list
     *
     * @param ReturnOrderListRequest $request Request object with return order parameters
     * @return ReturnOrderListResponse
     * @throws ApiException
     */
    public function getReturnOrderList(ReturnOrderListRequest $request): ReturnOrderListResponse
    {
        /** @var ReturnOrderListResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }
}
