<?php
/**
 * ProductsManagementApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Api;

use Temu\ApiException;
use Temu\Model\GoodsListRequest;
use Temu\Model\GoodsListResponse;
use Temu\Model\GoodsSkuListRequest;
use Temu\Model\GoodsSkuListResponse;
use Temu\Model\GoodsDetailRequest;
use Temu\Model\GoodsDetailResponse;
use Temu\Model\GoodsSpecDetailRequest;
use Temu\Model\GoodsSpecDetailResponse;
use Temu\Model\UpdateGoodsInfoRequest;
use Temu\Model\UpdateGoodsInfoResponse;
use Temu\Model\UpdateGoodsInfoPartialRequest;
use Temu\Model\UpdateGoodsInfoPartialResponse;
use Temu\Model\GoodsSaleStatusRequest;
use Temu\Model\GoodsSaleStatusResponse;
use Temu\Model\UpdateGoodsSaleStatusRequest;
use Temu\Model\UpdateGoodsSaleStatusResponse;

/**
 * ProductsManagementApi Class
 *
 * Manages product information, details, and status updates for Temu marketplace.
 *
 * This API class provides comprehensive product management capabilities including:
 * - Retrieving product lists with pagination and filtering
 * - Getting detailed product information and specifications
 * - Updating product information (full and partial updates)
 * - Managing product sale status (on-sale/off-sale)
 * - Accessing SKU-level product data
 *
 * **Operation Type Prefix:** `bg.local.goods.*`, `bg.goods.*`
 *
 * **Common Use Cases:**
 * - Sync product catalog from Temu to your system
 * - Monitor product status and availability
 * - Update product details when inventory or prices change
 * - Bulk product information retrieval and updates
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 *
 * @example Initialize API client
 * ```php
 * use Temu\Api\ProductsManagementApi;
 * use Temu\Configuration;
 *
 * $config = Configuration::getDefaultConfiguration();
 * $config->setAccessToken('your_access_token');
 *
 * $productApi = new ProductsManagementApi(null, $config);
 * ```
 *
 * @example Get product list with pagination
 * ```php
 * $request = new GoodsListRequest([
 *     'page_num' => 1,
 *     'page_size' => 50,
 *     'goods_status' => 1  // 1 = on sale
 * ]);
 *
 * $response = $productApi->getGoodsList($request);
 * if ($response->getSuccess()) {
 *     $products = $response->getResult()->getGoodsList();
 *     foreach ($products as $product) {
 *         echo $product->getGoodsId() . ": " . $product->getGoodsName() . "\n";
 *     }
 * }
 * ```
 *
 * @example Update product sale status
 * ```php
 * $request = new UpdateGoodsSaleStatusRequest([
 *     'goods_id' => 12345,
 *     'on_sale' => true  // Set product on sale
 * ]);
 *
 * $response = $productApi->updateGoodsSaleStatus($request);
 * if ($response->getSuccess()) {
 *     echo "Product status updated successfully";
 * }
 * ```
 *
 * @see ProductsListingApi For product creation and listing operations
 */
class ProductsManagementApi extends DefaultApi
{
    /**
     * Get goods list
     *
     * @param GoodsListRequest $request Request object with goods list parameters
     * @return GoodsListResponse
     * @throws ApiException
     */
    public function getGoodsList(GoodsListRequest $request): GoodsListResponse
    {
        /** @var GoodsListResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get goods SKU list
     *
     * @param GoodsSkuListRequest $request Request object with SKU list parameters
     * @return GoodsSkuListResponse
     * @throws ApiException
     */
    public function getGoodsSkuList(GoodsSkuListRequest $request): GoodsSkuListResponse
    {
        /** @var GoodsSkuListResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());

        return $response;
    }

    /**
     * Get goods detail
     *
     * @param GoodsDetailRequest $request Request object with goods detail parameters
     * @return GoodsDetailResponse
     * @throws ApiException
     */
    public function getGoodsDetail(GoodsDetailRequest $request): GoodsDetailResponse
    {
        /** @var GoodsDetailResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get goods specification detail
     *
     * @param GoodsSpecDetailRequest $request Request object with spec detail parameters
     * @return GoodsSpecDetailResponse
     * @throws ApiException
     */
    public function getGoodsSpecDetail(GoodsSpecDetailRequest $request): GoodsSpecDetailResponse
    {
        /** @var GoodsSpecDetailResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Update goods information
     *
     * @param UpdateGoodsInfoRequest $request Request object with goods data to update
     * @return UpdateGoodsInfoResponse
     * @throws ApiException
     */
    public function updateGoodsInfo(UpdateGoodsInfoRequest $request): UpdateGoodsInfoResponse
    {
        /** @var UpdateGoodsInfoResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Update goods information partially
     *
     * @param UpdateGoodsInfoPartialRequest $request Request object with goods data to partially update
     * @return UpdateGoodsInfoPartialResponse
     * @throws ApiException
     */
    public function updateGoodsInfoPartial(UpdateGoodsInfoPartialRequest $request): UpdateGoodsInfoPartialResponse
    {
        /** @var UpdateGoodsInfoPartialResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get goods sale status
     *
     * @param GoodsSaleStatusRequest $request Request object with goods ID list
     * @return GoodsSaleStatusResponse
     * @throws ApiException
     */
    public function getGoodsSaleStatus(GoodsSaleStatusRequest $request): GoodsSaleStatusResponse
    {
        /** @var GoodsSaleStatusResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Update goods sale status
     *
     * @param UpdateGoodsSaleStatusRequest $request Request object with goods ID and sale status
     * @return UpdateGoodsSaleStatusResponse
     * @throws ApiException
     */
    public function updateGoodsSaleStatus(UpdateGoodsSaleStatusRequest $request): UpdateGoodsSaleStatusResponse
    {
        /** @var UpdateGoodsSaleStatusResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }
}
