<?php
/**
 * ProductsListingApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Api;

use Temu\ApiException;
use Temu\Model\GoodsCategoriesRequest;
use Temu\Model\GoodsCategoriesResponse;
use Temu\Model\GoodsTemplateRequest;
use Temu\Model\GoodsTemplateResponse;
use Temu\Model\AvailableBrandAndTrademarkRequest;
use Temu\Model\AvailableBrandAndTrademarkResponse;
use Temu\Model\ShippingTemplatesRequest;
use Temu\Model\ShippingTemplatesResponse;
use Temu\Model\SizeElementsRequest;
use Temu\Model\SizeElementsResponse;
use Temu\Model\UploadImageWithAutoTransformerRequest;
use Temu\Model\UploadImageWithAutoTransformerResponse;
use Temu\Model\CreateSpecIdRequest;
use Temu\Model\CreateSpecIdResponse;
use Temu\Model\CreateGoodsRequest;
use Temu\Model\CreateGoodsResponse;
use Temu\Model\RecommendCategoriesRequest;
use Temu\Model\RecommendCategoriesResponse;
use Temu\Model\RecommendPropertiesRequest;
use Temu\Model\RecommendPropertiesResponse;

/**
 * ProductsListingApi Class
 */
class ProductsListingApi extends DefaultApi
{
    /**
     * Get goods categories
     *
     * @param GoodsCategoriesRequest $request Request object with category parameters
     * @return GoodsCategoriesResponse
     * @throws ApiException
     */
    public function getGoodsCategories(GoodsCategoriesRequest $request): GoodsCategoriesResponse
    {
        /** @var GoodsCategoriesResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get goods template
     *
     * @param GoodsTemplateRequest $request Request object with template parameters
     * @return GoodsTemplateResponse
     * @throws ApiException
     */
    public function getGoodsTemplate(GoodsTemplateRequest $request): GoodsTemplateResponse
    {
        /** @var GoodsTemplateResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get available brand and trademark
     *
     * @param AvailableBrandAndTrademarkRequest $request Request object with brand trademark parameters
     * @return AvailableBrandAndTrademarkResponse
     * @throws ApiException
     */
    public function getAvailableBrandAndTrademark(AvailableBrandAndTrademarkRequest $request): AvailableBrandAndTrademarkResponse
    {
        /** @var AvailableBrandAndTrademarkResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get shipping templates
     *
     * @param ShippingTemplatesRequest $request Request object for shipping templates
     * @return ShippingTemplatesResponse
     * @throws ApiException
     */
    public function getShippingTemplates(ShippingTemplatesRequest $request): ShippingTemplatesResponse
    {
        /** @var ShippingTemplatesResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get size elements
     *
     * @param SizeElementsRequest $request Request object with size element parameters
     * @return SizeElementsResponse
     * @throws ApiException
     */
    public function getSizeElements(SizeElementsRequest $request): SizeElementsResponse
    {
        /** @var SizeElementsResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Upload image with auto transformer
     *
     * @param UploadImageWithAutoTransformerRequest $request Request object with image upload parameters
     * @return UploadImageWithAutoTransformerResponse
     * @throws ApiException
     */
    public function uploadImageWithAutoTransformer(UploadImageWithAutoTransformerRequest $request): UploadImageWithAutoTransformerResponse
    {
        /** @var UploadImageWithAutoTransformerResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Create spec ID
     *
     * @param CreateSpecIdRequest $request Request object with spec creation parameters
     * @return CreateSpecIdResponse
     * @throws ApiException
     */
    public function createSpecId(CreateSpecIdRequest $request): CreateSpecIdResponse
    {
        /** @var CreateSpecIdResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Create goods
     *
     * @param CreateGoodsRequest $request Goods creation request object
     * @return CreateGoodsResponse
     * @throws ApiException
     */
    public function createGoods(CreateGoodsRequest $request): CreateGoodsResponse
    {
        /** @var CreateGoodsResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Recommend categories
     *
     * @param RecommendCategoriesRequest $request Request object with goods name
     * @return RecommendCategoriesResponse
     * @throws ApiException
     */
    public function recommendCategories(RecommendCategoriesRequest $request): RecommendCategoriesResponse
    {
        /** @var RecommendCategoriesResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Recommend properties
     *
     * @param RecommendPropertiesRequest $request Request object with property recommendation parameters
     * @return RecommendPropertiesResponse
     * @throws ApiException
     */
    public function recommendProperties(RecommendPropertiesRequest $request): RecommendPropertiesResponse
    {
        /** @var RecommendPropertiesResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }
}
