<?php
/**
 * PricingApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Api;

use Temu\ApiException;
use Temu\Model\GoodsPriceListRequest;
use Temu\Model\GoodsPriceListResponse;
use Temu\Model\UpdateGoodsPriceRequest;
use Temu\Model\UpdateGoodsPriceResponse;
use Temu\Model\GoodsPriceOrderRequest;
use Temu\Model\GoodsPriceOrderResponse;
use Temu\Model\AcceptGoodsPriceOrderRequest;
use Temu\Model\AcceptGoodsPriceOrderResponse;
use Temu\Model\NegotiateGoodsPriceOrderRequest;
use Temu\Model\NegotiateGoodsPriceOrderResponse;
use Temu\Model\RejectGoodsPriceOrderRequest;
use Temu\Model\RejectGoodsPriceOrderResponse;
use Temu\Model\CreateGoodsAppealPriceOrderRequest;
use Temu\Model\CreateGoodsAppealPriceOrderResponse;
use Temu\Model\GoodsAppealPriceOrderRequest;
use Temu\Model\GoodsAppealPriceOrderResponse;
use Temu\Model\GoodsAppealPriceOrderRecordRequest;
use Temu\Model\GoodsAppealPriceOrderRecordResponse;
use Temu\Model\GoodsRecommendPriceRequest;
use Temu\Model\GoodsRecommendPriceResponse;
use Temu\Model\OrderPriceRequest;
use Temu\Model\OrderPriceResponse;

/**
 * PricingApi Class
 */
class PricingApi extends DefaultApi
{
    /**
     * Get goods price list
     *
     * @param GoodsPriceListRequest $request Request object with query supplier price base list
     * @return GoodsPriceListResponse
     * @throws ApiException
     */
    public function getGoodsPriceList(GoodsPriceListRequest $request): GoodsPriceListResponse
    {
        /** @var GoodsPriceListResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Update goods price
     *
     * @param UpdateGoodsPriceRequest $request Request object with goods ID and change SKU price DTO list
     * @return UpdateGoodsPriceResponse
     * @throws ApiException
     */
    public function updateGoodsPrice(UpdateGoodsPriceRequest $request): UpdateGoodsPriceResponse
    {
        /** @var UpdateGoodsPriceResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get goods price order
     *
     * @param GoodsPriceOrderRequest $request Request object with pagination and price order parameters
     * @return GoodsPriceOrderResponse
     * @throws ApiException
     */
    public function getGoodsPriceOrder(GoodsPriceOrderRequest $request): GoodsPriceOrderResponse
    {
        /** @var GoodsPriceOrderResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Accept goods price order
     *
     * @param AcceptGoodsPriceOrderRequest $request Request object with price order info list
     * @return AcceptGoodsPriceOrderResponse
     * @throws ApiException
     */
    public function acceptGoodsPriceOrder(AcceptGoodsPriceOrderRequest $request): AcceptGoodsPriceOrderResponse
    {
        /** @var AcceptGoodsPriceOrderResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Negotiate goods price order
     *
     * @param NegotiateGoodsPriceOrderRequest $request Request object with price negotiation parameters
     * @return NegotiateGoodsPriceOrderResponse
     * @throws ApiException
     */
    public function negotiateGoodsPriceOrder(NegotiateGoodsPriceOrderRequest $request): NegotiateGoodsPriceOrderResponse
    {
        /** @var NegotiateGoodsPriceOrderResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Reject goods price order
     *
     * @param RejectGoodsPriceOrderRequest $request Request object with reject delist flag and price order base list
     * @return RejectGoodsPriceOrderResponse
     * @throws ApiException
     */
    public function rejectGoodsPriceOrder(RejectGoodsPriceOrderRequest $request): RejectGoodsPriceOrderResponse
    {
        /** @var RejectGoodsPriceOrderResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Create goods appeal price order
     *
     * @param CreateGoodsAppealPriceOrderRequest $request Request object with appeal creation parameters
     * @return CreateGoodsAppealPriceOrderResponse
     * @throws ApiException
     */
    public function createGoodsAppealPriceOrder(CreateGoodsAppealPriceOrderRequest $request): CreateGoodsAppealPriceOrderResponse
    {
        /** @var CreateGoodsAppealPriceOrderResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get goods appeal price order
     *
     * @param GoodsAppealPriceOrderRequest $request Request object with goods ID and tab code
     * @return GoodsAppealPriceOrderResponse
     * @throws ApiException
     */
    public function getGoodsAppealPriceOrder(GoodsAppealPriceOrderRequest $request): GoodsAppealPriceOrderResponse
    {
        /** @var GoodsAppealPriceOrderResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get goods appeal price order record
     *
     * @param GoodsAppealPriceOrderRecordRequest $request Request object with SKU ID
     * @return GoodsAppealPriceOrderRecordResponse
     * @throws ApiException
     */
    public function getGoodsAppealPriceOrderRecord(GoodsAppealPriceOrderRecordRequest $request): GoodsAppealPriceOrderRecordResponse
    {
        /** @var GoodsAppealPriceOrderRecordResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get goods recommended price
     *
     * @param GoodsRecommendPriceRequest $request Request object with recommended price parameters
     * @return GoodsRecommendPriceResponse
     * @throws ApiException
     */
    public function getGoodsRecommendPrice(GoodsRecommendPriceRequest $request): GoodsRecommendPriceResponse
    {
        /** @var GoodsRecommendPriceResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get order price
     *
     * @param OrderPriceRequest $request Request object with parent order serial number
     * @return OrderPriceResponse
     * @throws ApiException
     */
    public function getOrderPrice(OrderPriceRequest $request): OrderPriceResponse
    {
        /** @var OrderPriceResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }
}
