<?php
/**
 * OrderManagementApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Api;

use Temu\ApiException;
use Temu\Model\OrderListRequest;
use Temu\Model\OrderListResponse;
use Temu\Model\OrderDetailRequest;
use Temu\Model\OrderDetailResponse;
use Temu\Model\CustomOrderDetailRequest;
use Temu\Model\CustomOrderDetailResponse;
use Temu\Model\OrderShippingInfoRequest;
use Temu\Model\OrderShippingInfoResponse;
use Temu\Model\OrderShippingCompaniesRequest;
use Temu\Model\OrderShippingCompaniesResponse;

/**
 * OrderManagementApi Class
 */
class OrderManagementApi extends DefaultApi
{
    /**
     * Get order list
     *
     * @param OrderListRequest $request Request object with order list parameters
     * @return OrderListResponse
     * @throws ApiException
     */
    public function getOrderList(OrderListRequest $request): OrderListResponse
    {
        /** @var OrderListResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get order detail
     *
     * @param OrderDetailRequest $request Request object with order detail parameters
     * @return OrderDetailResponse
     * @throws ApiException
     */
    public function getOrderDetail(OrderDetailRequest $request): OrderDetailResponse
    {
        /** @var OrderDetailResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get custom order detail
     *
     * @param CustomOrderDetailRequest $request Request object with order serial number list
     * @return CustomOrderDetailResponse
     * @throws ApiException
     */
    public function getCustomOrderDetail(CustomOrderDetailRequest $request): CustomOrderDetailResponse
    {
        /** @var CustomOrderDetailResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get order shipping info
     *
     * @param OrderShippingInfoRequest $request Request object with parent order serial number
     * @return OrderShippingInfoResponse
     * @throws ApiException
     */
    public function getOrderShippingInfo(OrderShippingInfoRequest $request): OrderShippingInfoResponse
    {
        /** @var OrderShippingInfoResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get order shipping companies
     *
     * @param OrderShippingCompaniesRequest $request Request object with region ID
     * @return OrderShippingCompaniesResponse
     * @throws ApiException
     */
    public function getOrderShippingCompanies(OrderShippingCompaniesRequest $request): OrderShippingCompaniesResponse
    {
        /** @var OrderShippingCompaniesResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }
}
