<?php
/**
 * OrderFulfillmentApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Api;

use Temu\ApiException;
use Temu\Model\ConfirmOrderShipmentRequest;
use Temu\Model\ConfirmOrderShipmentResponse;
use Temu\Model\OrderShipmentInfoRequest;
use Temu\Model\OrderShipmentInfoResponse;
use Temu\Model\UpdateOrderShipmentInfoRequest;
use Temu\Model\UpdateOrderShipmentInfoResponse;
use Temu\Model\CreateShipmentRequest;
use Temu\Model\CreateShipmentResponse;

/**
 * OrderFulfillmentApi Class
 */
class OrderFulfillmentApi extends DefaultApi
{
    /**
     * Confirm order shipment
     *
     * @param ConfirmOrderShipmentRequest $request Request object with shipment confirmation parameters
     * @return ConfirmOrderShipmentResponse
     * @throws ApiException
     */
    public function confirmOrderShipment(ConfirmOrderShipmentRequest $request): ConfirmOrderShipmentResponse
    {
        /** @var ConfirmOrderShipmentResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get order shipment info
     *
     * @param OrderShipmentInfoRequest $request Request object with parent order SN and order SN
     * @return OrderShipmentInfoResponse
     * @throws ApiException
     */
    public function getOrderShipmentInfo(OrderShipmentInfoRequest $request): OrderShipmentInfoResponse
    {
        /** @var OrderShipmentInfoResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Update order shipment info
     *
     * @param UpdateOrderShipmentInfoRequest $request Request object with shipment update parameters
     * @return UpdateOrderShipmentInfoResponse
     * @throws ApiException
     */
    public function updateOrderShipmentInfo(UpdateOrderShipmentInfoRequest $request): UpdateOrderShipmentInfoResponse
    {
        /** @var UpdateOrderShipmentInfoResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Create shipment
     *
     * @param CreateShipmentRequest $request Request object for shipment creation
     * @return CreateShipmentResponse
     * @throws ApiException
     */
    public function createShipment(CreateShipmentRequest $request): CreateShipmentResponse
    {
        $request->setType('bg.logistics.shipment.create');
        /** @var CreateShipmentResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }
}
