<?php
/**
 * BuyShippingApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Api;

use Temu\ApiException;
use Temu\Model\ShippingServicesRequest;
use Temu\Model\ShippingServicesResponse;
use Temu\Model\WarehouseListRequest;
use Temu\Model\WarehouseListResponse;
use Temu\Model\CreateShipmentRequest;
use Temu\Model\CreateShipmentResponse;
use Temu\Model\UpdateShipmentRequest;
use Temu\Model\UpdateShipmentResponse;
use Temu\Model\ShippingLabelRequest;
use Temu\Model\ShippingLabelResponse;
use Temu\Model\ShipLaterPackagesRequest;
use Temu\Model\ShipLaterPackagesResponse;
use Temu\Model\ConfirmShipLaterPackagesShippedRequest;
use Temu\Model\ConfirmShipLaterPackagesShippedResponse;

/**
 * BuyShippingApi Class
 */
class BuyShippingApi extends DefaultApi
{
    /**
     * Get shipping services
     *
     * @param ShippingServicesRequest $request Request object with shipping service parameters
     * @return ShippingServicesResponse
     * @throws ApiException
     */
    public function getShippingServices(ShippingServicesRequest $request): ShippingServicesResponse
    {
        /** @var ShippingServicesResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get warehouse list
     *
     * @param WarehouseListRequest $request Request object for warehouse list
     * @return WarehouseListResponse
     * @throws ApiException
     */
    public function getWarehouseList(WarehouseListRequest $request): WarehouseListResponse
    {
        /** @var WarehouseListResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Create shipment
     *
     * @param CreateShipmentRequest $request Request object for shipment creation
     * @return CreateShipmentResponse
     * @throws ApiException
     */
    public function createShipment(CreateShipmentRequest $request): CreateShipmentResponse
    {
        /** @var CreateShipmentResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Update shipment
     *
     * @param UpdateShipmentRequest $request Request object with shipment update parameters
     * @return UpdateShipmentResponse
     * @throws ApiException
     */
    public function updateShipment(UpdateShipmentRequest $request): UpdateShipmentResponse
    {
        /** @var UpdateShipmentResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get shipping label
     *
     * @param ShippingLabelRequest $request Request object with shipping label parameters
     * @return ShippingLabelResponse
     * @throws ApiException
     */
    public function getShippingLabel(ShippingLabelRequest $request): ShippingLabelResponse
    {
        /** @var ShippingLabelResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Get ship later packages
     *
     * @param ShipLaterPackagesRequest $request Request object with pagination parameters
     * @return ShipLaterPackagesResponse
     * @throws ApiException
     */
    public function getShipLaterPackages(ShipLaterPackagesRequest $request): ShipLaterPackagesResponse
    {
        /** @var ShipLaterPackagesResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }

    /**
     * Confirm ship later packages shipped
     *
     * @param ConfirmShipLaterPackagesShippedRequest $request Request object with package confirmation parameters
     * @return ConfirmShipLaterPackagesShippedResponse
     * @throws ApiException
     */
    public function confirmShipLaterPackagesShipped(ConfirmShipLaterPackagesShippedRequest $request): ConfirmShipLaterPackagesShippedResponse
    {
        /** @var ConfirmShipLaterPackagesShippedResponse $response */
        $response = $this->rootPost($request, 'application/json', $request->getResponseClass());
        return $response;
    }
}
