# Temu\DefaultApi

All URIs are relative to https://openapi-b-us.temu.com/openapi/router, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**rootPost()**](DefaultApi.md#rootPost) | **POST** / | Temu API Router |


## `rootPost()`

```php
rootPost($post_request): \Temu\Model\BaseResponse
```

Temu API Router

Universal endpoint for all Temu API operations. The specific operation is determined by the 'type' field in the request body.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer authorization: TemuAuth
$config = Temu\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Temu\Api\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$post_request = {"type":"bg.open.accesstoken.info.get"}; // \Temu\Model\PostRequest

try {
    $result = $apiInstance->rootPost($post_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->rootPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **post_request** | [**\Temu\Model\PostRequest**](../Model/PostRequest.md)|  | |

### Return type

[**\Temu\Model\BaseResponse**](../Model/BaseResponse.md)

### Authorization

[TemuAuth](../../README.md#TemuAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
