# OpenAPIClient-php

Comprehensive API collection for Temu marketplace operations including product management,
order processing, inventory management, pricing, and fulfillment services.

All endpoints use POST method with operation type specified in request body.
Authentication uses MD5 signature with app_key, app_secret, access_token, and timestamp.



## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/temu.git"
    }
  ],
  "require": {
    "talisman/temu": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure Bearer authorization: TemuAuth
$config = Temu\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Temu\Api\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$post_request = {"type":"bg.open.accesstoken.info.get"}; // \Temu\Model\PostRequest

try {
    $result = $apiInstance->rootPost($post_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->rootPost: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://openapi-b-us.temu.com/openapi/router*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**rootPost**](docs/Api/DefaultApi.md#rootpost) | **POST** / | Temu API Router

## Models

- [AccessTokenInfoRequest](docs/Model/AccessTokenInfoRequest.md)
- [BaseRequest](docs/Model/BaseRequest.md)
- [BaseResponse](docs/Model/BaseResponse.md)
- [CreateAccessTokenRequest](docs/Model/CreateAccessTokenRequest.md)
- [CreateGoodsRequest](docs/Model/CreateGoodsRequest.md)
- [CreateGoodsRequestAllOfGoodsBasic](docs/Model/CreateGoodsRequestAllOfGoodsBasic.md)
- [CreateGoodsRequestAllOfGoodsProperty](docs/Model/CreateGoodsRequestAllOfGoodsProperty.md)
- [CreateShipmentRequest](docs/Model/CreateShipmentRequest.md)
- [GoodsCategoriesRequest](docs/Model/GoodsCategoriesRequest.md)
- [OrderDetailRequest](docs/Model/OrderDetailRequest.md)
- [OrderListRequest](docs/Model/OrderListRequest.md)
- [PostRequest](docs/Model/PostRequest.md)
- [UpdateStockRequest](docs/Model/UpdateStockRequest.md)

## Authorization

Authentication schemes defined for the API:
### TemuAuth

- **Type**: Bearer authentication

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `1.0.0`
    - Package version: `1.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
