<?php
/**
 * TransferItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SmartVolution
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * SV Register Web-services
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 4.15
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SmartVolution\Model;

use \ArrayAccess;
use \SmartVolution\ObjectSerializer;

/**
 * TransferItem Class Doc Comment
 *
 * @category Class
 * @package  SmartVolution
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TransferItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransferItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'tenant' => 'int',
        'transfer' => 'int',
        'product' => 'int',
        'productType' => 'string',
        'productUomId' => 'int',
        'uomMultiplier' => 'double',
        'productName' => 'string',
        'productSKU' => 'string',
        'qtySent' => 'double',
        'qtyAccepted' => 'double',
        'qtyRejected' => 'double',
        'qtyLost' => 'double',
        'notes' => 'string',
        'created' => '\DateTime',
        'modified' => '\DateTime',
        'productSymbol' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int64',
        'tenant' => 'int64',
        'transfer' => 'int64',
        'product' => 'int64',
        'productType' => null,
        'productUomId' => 'int64',
        'uomMultiplier' => 'double',
        'productName' => null,
        'productSKU' => null,
        'qtySent' => 'double',
        'qtyAccepted' => 'double',
        'qtyRejected' => 'double',
        'qtyLost' => 'double',
        'notes' => null,
        'created' => 'date-time',
        'modified' => 'date-time',
        'productSymbol' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'tenant' => 'tenant',
        'transfer' => 'transfer',
        'product' => 'product',
        'productType' => 'productType',
        'productUomId' => 'productUomId',
        'uomMultiplier' => 'uomMultiplier',
        'productName' => 'productName',
        'productSKU' => 'productSKU',
        'qtySent' => 'qtySent',
        'qtyAccepted' => 'qtyAccepted',
        'qtyRejected' => 'qtyRejected',
        'qtyLost' => 'qtyLost',
        'notes' => 'notes',
        'created' => 'created',
        'modified' => 'modified',
        'productSymbol' => 'productSymbol'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'tenant' => 'setTenant',
        'transfer' => 'setTransfer',
        'product' => 'setProduct',
        'productType' => 'setProductType',
        'productUomId' => 'setProductUomId',
        'uomMultiplier' => 'setUomMultiplier',
        'productName' => 'setProductName',
        'productSKU' => 'setProductSKU',
        'qtySent' => 'setQtySent',
        'qtyAccepted' => 'setQtyAccepted',
        'qtyRejected' => 'setQtyRejected',
        'qtyLost' => 'setQtyLost',
        'notes' => 'setNotes',
        'created' => 'setCreated',
        'modified' => 'setModified',
        'productSymbol' => 'setProductSymbol'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'tenant' => 'getTenant',
        'transfer' => 'getTransfer',
        'product' => 'getProduct',
        'productType' => 'getProductType',
        'productUomId' => 'getProductUomId',
        'uomMultiplier' => 'getUomMultiplier',
        'productName' => 'getProductName',
        'productSKU' => 'getProductSKU',
        'qtySent' => 'getQtySent',
        'qtyAccepted' => 'getQtyAccepted',
        'qtyRejected' => 'getQtyRejected',
        'qtyLost' => 'getQtyLost',
        'notes' => 'getNotes',
        'created' => 'getCreated',
        'modified' => 'getModified',
        'productSymbol' => 'getProductSymbol'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['tenant'] = $data['tenant'] ?? null;
        $this->container['transfer'] = $data['transfer'] ?? null;
        $this->container['product'] = $data['product'] ?? null;
        $this->container['productType'] = $data['productType'] ?? null;
        $this->container['productUomId'] = $data['productUomId'] ?? null;
        $this->container['uomMultiplier'] = $data['uomMultiplier'] ?? null;
        $this->container['productName'] = $data['productName'] ?? null;
        $this->container['productSKU'] = $data['productSKU'] ?? null;
        $this->container['qtySent'] = $data['qtySent'] ?? null;
        $this->container['qtyAccepted'] = $data['qtyAccepted'] ?? null;
        $this->container['qtyRejected'] = $data['qtyRejected'] ?? null;
        $this->container['qtyLost'] = $data['qtyLost'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['created'] = $data['created'] ?? null;
        $this->container['modified'] = $data['modified'] ?? null;
        $this->container['productSymbol'] = $data['productSymbol'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id TransferItem Id
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets tenant
     *
     * @return int|null
     */
    public function getTenant()
    {
        return $this->container['tenant'];
    }

    /**
     * Sets tenant
     *
     * @param int|null $tenant Tenant Id
     *
     * @return self
     */
    public function setTenant($tenant)
    {
        $this->container['tenant'] = $tenant;

        return $this;
    }

    /**
     * Gets transfer
     *
     * @return int|null
     */
    public function getTransfer()
    {
        return $this->container['transfer'];
    }

    /**
     * Sets transfer
     *
     * @param int|null $transfer Transfer Id
     *
     * @return self
     */
    public function setTransfer($transfer)
    {
        $this->container['transfer'] = $transfer;

        return $this;
    }

    /**
     * Gets product
     *
     * @return int|null
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param int|null $product Product Id
     *
     * @return self
     */
    public function setProduct($product)
    {
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets productType
     *
     * @return string|null
     */
    public function getProductType()
    {
        return $this->container['productType'];
    }

    /**
     * Sets productType
     *
     * @param string|null $productType Product Type
     *
     * @return self
     */
    public function setProductType($productType)
    {
        $this->container['productType'] = $productType;

        return $this;
    }

    /**
     * Gets productUomId
     *
     * @return int|null
     */
    public function getProductUomId()
    {
        return $this->container['productUomId'];
    }

    /**
     * Sets productUomId
     *
     * @param int|null $productUomId Product UOM Id
     *
     * @return self
     */
    public function setProductUomId($productUomId)
    {
        $this->container['productUomId'] = $productUomId;

        return $this;
    }

    /**
     * Gets uomMultiplier
     *
     * @return double|null
     */
    public function getUomMultiplier()
    {
        return $this->container['uomMultiplier'];
    }

    /**
     * Sets uomMultiplier
     *
     * @param double|null $uomMultiplier Product Uom Multiplier
     *
     * @return self
     */
    public function setUomMultiplier($uomMultiplier)
    {
        $this->container['uomMultiplier'] = $uomMultiplier;

        return $this;
    }

    /**
     * Gets productName
     *
     * @return string|null
     */
    public function getProductName()
    {
        return $this->container['productName'];
    }

    /**
     * Sets productName
     *
     * @param string|null $productName Product Name
     *
     * @return self
     */
    public function setProductName($productName)
    {
        $this->container['productName'] = $productName;

        return $this;
    }

    /**
     * Gets productSKU
     *
     * @return string|null
     */
    public function getProductSKU()
    {
        return $this->container['productSKU'];
    }

    /**
     * Sets productSKU
     *
     * @param string|null $productSKU Product SKU
     *
     * @return self
     */
    public function setProductSKU($productSKU)
    {
        $this->container['productSKU'] = $productSKU;

        return $this;
    }

    /**
     * Gets qtySent
     *
     * @return double|null
     */
    public function getQtySent()
    {
        return $this->container['qtySent'];
    }

    /**
     * Sets qtySent
     *
     * @param double|null $qtySent Sent Quantity
     *
     * @return self
     */
    public function setQtySent($qtySent)
    {
        $this->container['qtySent'] = $qtySent;

        return $this;
    }

    /**
     * Gets qtyAccepted
     *
     * @return double|null
     */
    public function getQtyAccepted()
    {
        return $this->container['qtyAccepted'];
    }

    /**
     * Sets qtyAccepted
     *
     * @param double|null $qtyAccepted Accepted Quantity
     *
     * @return self
     */
    public function setQtyAccepted($qtyAccepted)
    {
        $this->container['qtyAccepted'] = $qtyAccepted;

        return $this;
    }

    /**
     * Gets qtyRejected
     *
     * @return double|null
     */
    public function getQtyRejected()
    {
        return $this->container['qtyRejected'];
    }

    /**
     * Sets qtyRejected
     *
     * @param double|null $qtyRejected Rejected Quantity
     *
     * @return self
     */
    public function setQtyRejected($qtyRejected)
    {
        $this->container['qtyRejected'] = $qtyRejected;

        return $this;
    }

    /**
     * Gets qtyLost
     *
     * @return double|null
     */
    public function getQtyLost()
    {
        return $this->container['qtyLost'];
    }

    /**
     * Sets qtyLost
     *
     * @param double|null $qtyLost Lost Quantity
     *
     * @return self
     */
    public function setQtyLost($qtyLost)
    {
        $this->container['qtyLost'] = $qtyLost;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets created
     *
     * @return \DateTime|null
     */
    public function getCreated()
    {
        return $this->container['created'];
    }

    /**
     * Sets created
     *
     * @param \DateTime|null $created Created Time
     *
     * @return self
     */
    public function setCreated($created)
    {
        $this->container['created'] = $created;

        return $this;
    }

    /**
     * Gets modified
     *
     * @return \DateTime|null
     */
    public function getModified()
    {
        return $this->container['modified'];
    }

    /**
     * Sets modified
     *
     * @param \DateTime|null $modified Modified Time
     *
     * @return self
     */
    public function setModified($modified)
    {
        $this->container['modified'] = $modified;

        return $this;
    }

    /**
     * Gets productSymbol
     *
     * @return string|null
     */
    public function getProductSymbol()
    {
        return $this->container['productSymbol'];
    }

    /**
     * Sets productSymbol
     *
     * @param string|null $productSymbol UOM Product Symbol
     *
     * @return self
     */
    public function setProductSymbol($productSymbol)
    {
        $this->container['productSymbol'] = $productSymbol;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


