<?php
/**
 * ProductVv
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SmartVolution
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * SV Register Web-services
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 4.15
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SmartVolution\Model;

use \ArrayAccess;
use \SmartVolution\ObjectSerializer;

/**
 * ProductVv Class Doc Comment
 *
 * @category Class
 * @package  SmartVolution
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ProductVv implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductVv';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'sku' => 'string',
        'barcode' => 'string',
        'name' => 'string',
        'description' => 'string',
        'type' => 'string',
        'size' => 'string',
        'style' => 'string',
        'colour' => 'string',
        'manufacturer' => 'string',
        'supplierId' => 'int',
        'supplierName' => 'string',
        'supplierCode' => 'string',
        'reorderLimit' => 'string',
        'buyPrice' => 'double',
        'custom1' => 'string',
        'custom2' => 'string',
        'custom3' => 'string',
        'custom4' => 'string',
        'custom5' => 'string',
        'modified' => 'int',
        'model' => 'string',
        'departments' => 'int[]',
        'printGroups' => 'int[]',
        'stocks' => '\SmartVolution\Model\ProductStock[]',
        'printOrderReceipt' => 'int',
        'commissionPercent' => 'double',
        'uomId' => 'int',
        'symbol' => 'string',
        'uomMultiplier' => 'double',
        'containerId' => 'int',
        'containerName' => 'string',
        'containerSKU' => 'string',
        'containerUomId' => 'int',
        'earnsLoyalty' => 'bool',
        'launchModifiers' => 'bool',
        'allowEbt' => 'bool',
        'priceLists' => '\SmartVolution\Model\PriceList[]',
        'modifiersForUpsell' => 'bool',
        'productModifierProduct' => '\SmartVolution\Model\ProductModifierProduct[]',
        'noImage' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int64',
        'sku' => null,
        'barcode' => null,
        'name' => null,
        'description' => null,
        'type' => null,
        'size' => null,
        'style' => null,
        'colour' => null,
        'manufacturer' => null,
        'supplierId' => 'int64',
        'supplierName' => null,
        'supplierCode' => null,
        'reorderLimit' => null,
        'buyPrice' => 'double',
        'custom1' => null,
        'custom2' => null,
        'custom3' => null,
        'custom4' => null,
        'custom5' => null,
        'modified' => 'int64',
        'model' => null,
        'departments' => 'int64',
        'printGroups' => 'int64',
        'stocks' => null,
        'printOrderReceipt' => 'int32',
        'commissionPercent' => 'double',
        'uomId' => 'int32',
        'symbol' => null,
        'uomMultiplier' => 'double',
        'containerId' => 'int64',
        'containerName' => null,
        'containerSKU' => null,
        'containerUomId' => 'int64',
        'earnsLoyalty' => null,
        'launchModifiers' => null,
        'allowEbt' => null,
        'priceLists' => null,
        'modifiersForUpsell' => null,
        'productModifierProduct' => null,
        'noImage' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'sku' => 'sku',
        'barcode' => 'barcode',
        'name' => 'name',
        'description' => 'description',
        'type' => 'type',
        'size' => 'size',
        'style' => 'style',
        'colour' => 'colour',
        'manufacturer' => 'manufacturer',
        'supplierId' => 'supplierId',
        'supplierName' => 'supplierName',
        'supplierCode' => 'supplierCode',
        'reorderLimit' => 'reorderLimit',
        'buyPrice' => 'buyPrice',
        'custom1' => 'custom1',
        'custom2' => 'custom2',
        'custom3' => 'custom3',
        'custom4' => 'custom4',
        'custom5' => 'custom5',
        'modified' => 'modified',
        'model' => 'model',
        'departments' => 'departments',
        'printGroups' => 'printGroups',
        'stocks' => 'stocks',
        'printOrderReceipt' => 'printOrderReceipt',
        'commissionPercent' => 'commissionPercent',
        'uomId' => 'uomId',
        'symbol' => 'symbol',
        'uomMultiplier' => 'uomMultiplier',
        'containerId' => 'containerId',
        'containerName' => 'containerName',
        'containerSKU' => 'containerSKU',
        'containerUomId' => 'containerUomId',
        'earnsLoyalty' => 'earnsLoyalty',
        'launchModifiers' => 'launchModifiers',
        'allowEbt' => 'allowEbt',
        'priceLists' => 'priceLists',
        'modifiersForUpsell' => 'modifiersForUpsell',
        'productModifierProduct' => 'productModifierProduct',
        'noImage' => 'noImage'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'sku' => 'setSku',
        'barcode' => 'setBarcode',
        'name' => 'setName',
        'description' => 'setDescription',
        'type' => 'setType',
        'size' => 'setSize',
        'style' => 'setStyle',
        'colour' => 'setColour',
        'manufacturer' => 'setManufacturer',
        'supplierId' => 'setSupplierId',
        'supplierName' => 'setSupplierName',
        'supplierCode' => 'setSupplierCode',
        'reorderLimit' => 'setReorderLimit',
        'buyPrice' => 'setBuyPrice',
        'custom1' => 'setCustom1',
        'custom2' => 'setCustom2',
        'custom3' => 'setCustom3',
        'custom4' => 'setCustom4',
        'custom5' => 'setCustom5',
        'modified' => 'setModified',
        'model' => 'setModel',
        'departments' => 'setDepartments',
        'printGroups' => 'setPrintGroups',
        'stocks' => 'setStocks',
        'printOrderReceipt' => 'setPrintOrderReceipt',
        'commissionPercent' => 'setCommissionPercent',
        'uomId' => 'setUomId',
        'symbol' => 'setSymbol',
        'uomMultiplier' => 'setUomMultiplier',
        'containerId' => 'setContainerId',
        'containerName' => 'setContainerName',
        'containerSKU' => 'setContainerSKU',
        'containerUomId' => 'setContainerUomId',
        'earnsLoyalty' => 'setEarnsLoyalty',
        'launchModifiers' => 'setLaunchModifiers',
        'allowEbt' => 'setAllowEbt',
        'priceLists' => 'setPriceLists',
        'modifiersForUpsell' => 'setModifiersForUpsell',
        'productModifierProduct' => 'setProductModifierProduct',
        'noImage' => 'setNoImage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'sku' => 'getSku',
        'barcode' => 'getBarcode',
        'name' => 'getName',
        'description' => 'getDescription',
        'type' => 'getType',
        'size' => 'getSize',
        'style' => 'getStyle',
        'colour' => 'getColour',
        'manufacturer' => 'getManufacturer',
        'supplierId' => 'getSupplierId',
        'supplierName' => 'getSupplierName',
        'supplierCode' => 'getSupplierCode',
        'reorderLimit' => 'getReorderLimit',
        'buyPrice' => 'getBuyPrice',
        'custom1' => 'getCustom1',
        'custom2' => 'getCustom2',
        'custom3' => 'getCustom3',
        'custom4' => 'getCustom4',
        'custom5' => 'getCustom5',
        'modified' => 'getModified',
        'model' => 'getModel',
        'departments' => 'getDepartments',
        'printGroups' => 'getPrintGroups',
        'stocks' => 'getStocks',
        'printOrderReceipt' => 'getPrintOrderReceipt',
        'commissionPercent' => 'getCommissionPercent',
        'uomId' => 'getUomId',
        'symbol' => 'getSymbol',
        'uomMultiplier' => 'getUomMultiplier',
        'containerId' => 'getContainerId',
        'containerName' => 'getContainerName',
        'containerSKU' => 'getContainerSKU',
        'containerUomId' => 'getContainerUomId',
        'earnsLoyalty' => 'getEarnsLoyalty',
        'launchModifiers' => 'getLaunchModifiers',
        'allowEbt' => 'getAllowEbt',
        'priceLists' => 'getPriceLists',
        'modifiersForUpsell' => 'getModifiersForUpsell',
        'productModifierProduct' => 'getProductModifierProduct',
        'noImage' => 'getNoImage'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['barcode'] = $data['barcode'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['size'] = $data['size'] ?? null;
        $this->container['style'] = $data['style'] ?? null;
        $this->container['colour'] = $data['colour'] ?? null;
        $this->container['manufacturer'] = $data['manufacturer'] ?? null;
        $this->container['supplierId'] = $data['supplierId'] ?? null;
        $this->container['supplierName'] = $data['supplierName'] ?? null;
        $this->container['supplierCode'] = $data['supplierCode'] ?? null;
        $this->container['reorderLimit'] = $data['reorderLimit'] ?? null;
        $this->container['buyPrice'] = $data['buyPrice'] ?? null;
        $this->container['custom1'] = $data['custom1'] ?? null;
        $this->container['custom2'] = $data['custom2'] ?? null;
        $this->container['custom3'] = $data['custom3'] ?? null;
        $this->container['custom4'] = $data['custom4'] ?? null;
        $this->container['custom5'] = $data['custom5'] ?? null;
        $this->container['modified'] = $data['modified'] ?? null;
        $this->container['model'] = $data['model'] ?? null;
        $this->container['departments'] = $data['departments'] ?? null;
        $this->container['printGroups'] = $data['printGroups'] ?? null;
        $this->container['stocks'] = $data['stocks'] ?? null;
        $this->container['printOrderReceipt'] = $data['printOrderReceipt'] ?? null;
        $this->container['commissionPercent'] = $data['commissionPercent'] ?? null;
        $this->container['uomId'] = $data['uomId'] ?? null;
        $this->container['symbol'] = $data['symbol'] ?? null;
        $this->container['uomMultiplier'] = $data['uomMultiplier'] ?? null;
        $this->container['containerId'] = $data['containerId'] ?? null;
        $this->container['containerName'] = $data['containerName'] ?? null;
        $this->container['containerSKU'] = $data['containerSKU'] ?? null;
        $this->container['containerUomId'] = $data['containerUomId'] ?? null;
        $this->container['earnsLoyalty'] = $data['earnsLoyalty'] ?? null;
        $this->container['launchModifiers'] = $data['launchModifiers'] ?? null;
        $this->container['allowEbt'] = $data['allowEbt'] ?? null;
        $this->container['priceLists'] = $data['priceLists'] ?? null;
        $this->container['modifiersForUpsell'] = $data['modifiersForUpsell'] ?? null;
        $this->container['productModifierProduct'] = $data['productModifierProduct'] ?? null;
        $this->container['noImage'] = $data['noImage'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Product unique id
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets barcode
     *
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->container['barcode'];
    }

    /**
     * Sets barcode
     *
     * @param string|null $barcode Product Barcode
     *
     * @return self
     */
    public function setBarcode($barcode)
    {
        $this->container['barcode'] = $barcode;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Product Name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Product Description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The internal type of product
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets size
     *
     * @return string|null
     */
    public function getSize()
    {
        return $this->container['size'];
    }

    /**
     * Sets size
     *
     * @param string|null $size Product Size
     *
     * @return self
     */
    public function setSize($size)
    {
        $this->container['size'] = $size;

        return $this;
    }

    /**
     * Gets style
     *
     * @return string|null
     */
    public function getStyle()
    {
        return $this->container['style'];
    }

    /**
     * Sets style
     *
     * @param string|null $style Product Style
     *
     * @return self
     */
    public function setStyle($style)
    {
        $this->container['style'] = $style;

        return $this;
    }

    /**
     * Gets colour
     *
     * @return string|null
     */
    public function getColour()
    {
        return $this->container['colour'];
    }

    /**
     * Sets colour
     *
     * @param string|null $colour Product Colour
     *
     * @return self
     */
    public function setColour($colour)
    {
        $this->container['colour'] = $colour;

        return $this;
    }

    /**
     * Gets manufacturer
     *
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->container['manufacturer'];
    }

    /**
     * Sets manufacturer
     *
     * @param string|null $manufacturer Product Manufacturer
     *
     * @return self
     */
    public function setManufacturer($manufacturer)
    {
        $this->container['manufacturer'] = $manufacturer;

        return $this;
    }

    /**
     * Gets supplierId
     *
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->container['supplierId'];
    }

    /**
     * Sets supplierId
     *
     * @param int|null $supplierId Product Supplier
     *
     * @return self
     */
    public function setSupplierId($supplierId)
    {
        $this->container['supplierId'] = $supplierId;

        return $this;
    }

    /**
     * Gets supplierName
     *
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->container['supplierName'];
    }

    /**
     * Sets supplierName
     *
     * @param string|null $supplierName Product Supplier Name
     *
     * @return self
     */
    public function setSupplierName($supplierName)
    {
        $this->container['supplierName'] = $supplierName;

        return $this;
    }

    /**
     * Gets supplierCode
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplierCode'];
    }

    /**
     * Sets supplierCode
     *
     * @param string|null $supplierCode Product Supplier Code
     *
     * @return self
     */
    public function setSupplierCode($supplierCode)
    {
        $this->container['supplierCode'] = $supplierCode;

        return $this;
    }

    /**
     * Gets reorderLimit
     *
     * @return string|null
     */
    public function getReorderLimit()
    {
        return $this->container['reorderLimit'];
    }

    /**
     * Sets reorderLimit
     *
     * @param string|null $reorderLimit reorderLimit
     *
     * @return self
     */
    public function setReorderLimit($reorderLimit)
    {
        $this->container['reorderLimit'] = $reorderLimit;

        return $this;
    }

    /**
     * Gets buyPrice
     *
     * @return double|null
     */
    public function getBuyPrice()
    {
        return $this->container['buyPrice'];
    }

    /**
     * Sets buyPrice
     *
     * @param double|null $buyPrice Product buy price
     *
     * @return self
     */
    public function setBuyPrice($buyPrice)
    {
        $this->container['buyPrice'] = $buyPrice;

        return $this;
    }

    /**
     * Gets custom1
     *
     * @return string|null
     */
    public function getCustom1()
    {
        return $this->container['custom1'];
    }

    /**
     * Sets custom1
     *
     * @param string|null $custom1 Custom product information field
     *
     * @return self
     */
    public function setCustom1($custom1)
    {
        $this->container['custom1'] = $custom1;

        return $this;
    }

    /**
     * Gets custom2
     *
     * @return string|null
     */
    public function getCustom2()
    {
        return $this->container['custom2'];
    }

    /**
     * Sets custom2
     *
     * @param string|null $custom2 Custom product information field
     *
     * @return self
     */
    public function setCustom2($custom2)
    {
        $this->container['custom2'] = $custom2;

        return $this;
    }

    /**
     * Gets custom3
     *
     * @return string|null
     */
    public function getCustom3()
    {
        return $this->container['custom3'];
    }

    /**
     * Sets custom3
     *
     * @param string|null $custom3 Custom product information field
     *
     * @return self
     */
    public function setCustom3($custom3)
    {
        $this->container['custom3'] = $custom3;

        return $this;
    }

    /**
     * Gets custom4
     *
     * @return string|null
     */
    public function getCustom4()
    {
        return $this->container['custom4'];
    }

    /**
     * Sets custom4
     *
     * @param string|null $custom4 Custom product information field
     *
     * @return self
     */
    public function setCustom4($custom4)
    {
        $this->container['custom4'] = $custom4;

        return $this;
    }

    /**
     * Gets custom5
     *
     * @return string|null
     */
    public function getCustom5()
    {
        return $this->container['custom5'];
    }

    /**
     * Sets custom5
     *
     * @param string|null $custom5 Custom product information field
     *
     * @return self
     */
    public function setCustom5($custom5)
    {
        $this->container['custom5'] = $custom5;

        return $this;
    }

    /**
     * Gets modified
     *
     * @return int|null
     */
    public function getModified()
    {
        return $this->container['modified'];
    }

    /**
     * Sets modified
     *
     * @param int|null $modified The time in seconds since midnight January 1st 1970 UTC that this Product was modified
     *
     * @return self
     */
    public function setModified($modified)
    {
        $this->container['modified'] = $modified;

        return $this;
    }

    /**
     * Gets model
     *
     * @return string|null
     */
    public function getModel()
    {
        return $this->container['model'];
    }

    /**
     * Sets model
     *
     * @param string|null $model Product Model
     *
     * @return self
     */
    public function setModel($model)
    {
        $this->container['model'] = $model;

        return $this;
    }

    /**
     * Gets departments
     *
     * @return int[]|null
     */
    public function getDepartments()
    {
        return $this->container['departments'];
    }

    /**
     * Sets departments
     *
     * @param int[]|null $departments List of department Ids to assign to product
     *
     * @return self
     */
    public function setDepartments($departments)
    {
        $this->container['departments'] = $departments;

        return $this;
    }

    /**
     * Gets printGroups
     *
     * @return int[]|null
     */
    public function getPrintGroups()
    {
        return $this->container['printGroups'];
    }

    /**
     * Sets printGroups
     *
     * @param int[]|null $printGroups List of print group Ids to assign to product
     *
     * @return self
     */
    public function setPrintGroups($printGroups)
    {
        $this->container['printGroups'] = $printGroups;

        return $this;
    }

    /**
     * Gets stocks
     *
     * @return \SmartVolution\Model\ProductStock[]|null
     */
    public function getStocks()
    {
        return $this->container['stocks'];
    }

    /**
     * Sets stocks
     *
     * @param \SmartVolution\Model\ProductStock[]|null $stocks Stocks
     *
     * @return self
     */
    public function setStocks($stocks)
    {
        $this->container['stocks'] = $stocks;

        return $this;
    }

    /**
     * Gets printOrderReceipt
     *
     * @return int|null
     */
    public function getPrintOrderReceipt()
    {
        return $this->container['printOrderReceipt'];
    }

    /**
     * Sets printOrderReceipt
     *
     * @param int|null $printOrderReceipt The product need to be printed on secondary printer or not
     *
     * @return self
     */
    public function setPrintOrderReceipt($printOrderReceipt)
    {
        $this->container['printOrderReceipt'] = $printOrderReceipt;

        return $this;
    }

    /**
     * Gets commissionPercent
     *
     * @return double|null
     */
    public function getCommissionPercent()
    {
        return $this->container['commissionPercent'];
    }

    /**
     * Sets commissionPercent
     *
     * @param double|null $commissionPercent Product Commission Percent
     *
     * @return self
     */
    public function setCommissionPercent($commissionPercent)
    {
        $this->container['commissionPercent'] = $commissionPercent;

        return $this;
    }

    /**
     * Gets uomId
     *
     * @return int|null
     */
    public function getUomId()
    {
        return $this->container['uomId'];
    }

    /**
     * Sets uomId
     *
     * @param int|null $uomId UOM Id
     *
     * @return self
     */
    public function setUomId($uomId)
    {
        $this->container['uomId'] = $uomId;

        return $this;
    }

    /**
     * Gets symbol
     *
     * @return string|null
     */
    public function getSymbol()
    {
        return $this->container['symbol'];
    }

    /**
     * Sets symbol
     *
     * @param string|null $symbol UOM Symbol
     *
     * @return self
     */
    public function setSymbol($symbol)
    {
        $this->container['symbol'] = $symbol;

        return $this;
    }

    /**
     * Gets uomMultiplier
     *
     * @return double|null
     */
    public function getUomMultiplier()
    {
        return $this->container['uomMultiplier'];
    }

    /**
     * Sets uomMultiplier
     *
     * @param double|null $uomMultiplier UOM Multiplier
     *
     * @return self
     */
    public function setUomMultiplier($uomMultiplier)
    {
        $this->container['uomMultiplier'] = $uomMultiplier;

        return $this;
    }

    /**
     * Gets containerId
     *
     * @return int|null
     */
    public function getContainerId()
    {
        return $this->container['containerId'];
    }

    /**
     * Sets containerId
     *
     * @param int|null $containerId Container Id
     *
     * @return self
     */
    public function setContainerId($containerId)
    {
        $this->container['containerId'] = $containerId;

        return $this;
    }

    /**
     * Gets containerName
     *
     * @return string|null
     */
    public function getContainerName()
    {
        return $this->container['containerName'];
    }

    /**
     * Sets containerName
     *
     * @param string|null $containerName Container Name
     *
     * @return self
     */
    public function setContainerName($containerName)
    {
        $this->container['containerName'] = $containerName;

        return $this;
    }

    /**
     * Gets containerSKU
     *
     * @return string|null
     */
    public function getContainerSKU()
    {
        return $this->container['containerSKU'];
    }

    /**
     * Sets containerSKU
     *
     * @param string|null $containerSKU Container SKU
     *
     * @return self
     */
    public function setContainerSKU($containerSKU)
    {
        $this->container['containerSKU'] = $containerSKU;

        return $this;
    }

    /**
     * Gets containerUomId
     *
     * @return int|null
     */
    public function getContainerUomId()
    {
        return $this->container['containerUomId'];
    }

    /**
     * Sets containerUomId
     *
     * @param int|null $containerUomId Container Uom Id
     *
     * @return self
     */
    public function setContainerUomId($containerUomId)
    {
        $this->container['containerUomId'] = $containerUomId;

        return $this;
    }

    /**
     * Gets earnsLoyalty
     *
     * @return bool|null
     */
    public function getEarnsLoyalty()
    {
        return $this->container['earnsLoyalty'];
    }

    /**
     * Sets earnsLoyalty
     *
     * @param bool|null $earnsLoyalty Earns Loyalty
     *
     * @return self
     */
    public function setEarnsLoyalty($earnsLoyalty)
    {
        $this->container['earnsLoyalty'] = $earnsLoyalty;

        return $this;
    }

    /**
     * Gets launchModifiers
     *
     * @return bool|null
     */
    public function getLaunchModifiers()
    {
        return $this->container['launchModifiers'];
    }

    /**
     * Sets launchModifiers
     *
     * @param bool|null $launchModifiers Launch Modifiers
     *
     * @return self
     */
    public function setLaunchModifiers($launchModifiers)
    {
        $this->container['launchModifiers'] = $launchModifiers;

        return $this;
    }

    /**
     * Gets allowEbt
     *
     * @return bool|null
     */
    public function getAllowEbt()
    {
        return $this->container['allowEbt'];
    }

    /**
     * Sets allowEbt
     *
     * @param bool|null $allowEbt Allow EBT
     *
     * @return self
     */
    public function setAllowEbt($allowEbt)
    {
        $this->container['allowEbt'] = $allowEbt;

        return $this;
    }

    /**
     * Gets priceLists
     *
     * @return \SmartVolution\Model\PriceList[]|null
     */
    public function getPriceLists()
    {
        return $this->container['priceLists'];
    }

    /**
     * Sets priceLists
     *
     * @param \SmartVolution\Model\PriceList[]|null $priceLists Product price list
     *
     * @return self
     */
    public function setPriceLists($priceLists)
    {
        $this->container['priceLists'] = $priceLists;

        return $this;
    }

    /**
     * Gets modifiersForUpsell
     *
     * @return bool|null
     */
    public function getModifiersForUpsell()
    {
        return $this->container['modifiersForUpsell'];
    }

    /**
     * Sets modifiersForUpsell
     *
     * @param bool|null $modifiersForUpsell ModifiersForUpsell
     *
     * @return self
     */
    public function setModifiersForUpsell($modifiersForUpsell)
    {
        $this->container['modifiersForUpsell'] = $modifiersForUpsell;

        return $this;
    }

    /**
     * Gets productModifierProduct
     *
     * @return \SmartVolution\Model\ProductModifierProduct[]|null
     */
    public function getProductModifierProduct()
    {
        return $this->container['productModifierProduct'];
    }

    /**
     * Sets productModifierProduct
     *
     * @param \SmartVolution\Model\ProductModifierProduct[]|null $productModifierProduct ProductModifierProduct
     *
     * @return self
     */
    public function setProductModifierProduct($productModifierProduct)
    {
        $this->container['productModifierProduct'] = $productModifierProduct;

        return $this;
    }

    /**
     * Gets noImage
     *
     * @return bool|null
     */
    public function getNoImage()
    {
        return $this->container['noImage'];
    }

    /**
     * Sets noImage
     *
     * @param bool|null $noImage Represent this product has no image
     *
     * @return self
     */
    public function setNoImage($noImage)
    {
        $this->container['noImage'] = $noImage;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


