<?php
/**
 * ProductInOverViv
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SmartVolution
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * SV Register Web-services
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 4.15
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SmartVolution\Model;

use \ArrayAccess;
use \SmartVolution\ObjectSerializer;

/**
 * ProductInOverViv Class Doc Comment
 *
 * @category Class
 * @package  SmartVolution
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ProductInOverViv implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductInOverViv';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tenant' => 'int',
        'sku' => 'string',
        'barcode' => 'string',
        'name' => 'string',
        'description' => 'string',
        'prodType' => 'string',
        'image' => 'string',
        'printOrderReceipt' => 'int',
        'extra' => '\SmartVolution\Model\ProductExtraDetailsVii',
        'custom' => '\SmartVolution\Model\ProductCustomDetails',
        'modifiers' => 'int[]',
        'departments' => 'int[]',
        'productGroups' => 'int[]',
        'printGroups' => 'int[]',
        'deleted' => 'bool',
        'locked' => 'bool',
        'commissionPercent' => 'double',
        'uomId' => 'int',
        'symbol' => 'string',
        'uomMultiplier' => 'double',
        'containerSKU' => 'string',
        'earnsLoyalty' => 'string',
        'launchModifiers' => 'string',
        'allowEbt' => 'bool',
        'priceLists' => '\SmartVolution\Model\PriceListIn',
        'modifiersForUpsell' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tenant' => 'int64',
        'sku' => null,
        'barcode' => null,
        'name' => null,
        'description' => null,
        'prodType' => null,
        'image' => null,
        'printOrderReceipt' => 'int32',
        'extra' => null,
        'custom' => null,
        'modifiers' => 'int64',
        'departments' => 'int64',
        'productGroups' => 'int64',
        'printGroups' => 'int64',
        'deleted' => null,
        'locked' => null,
        'commissionPercent' => 'double',
        'uomId' => 'int32',
        'symbol' => null,
        'uomMultiplier' => 'double',
        'containerSKU' => null,
        'earnsLoyalty' => null,
        'launchModifiers' => null,
        'allowEbt' => null,
        'priceLists' => null,
        'modifiersForUpsell' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tenant' => 'tenant',
        'sku' => 'sku',
        'barcode' => 'barcode',
        'name' => 'name',
        'description' => 'description',
        'prodType' => 'prodType',
        'image' => 'image',
        'printOrderReceipt' => 'printOrderReceipt',
        'extra' => 'extra',
        'custom' => 'custom',
        'modifiers' => 'modifiers',
        'departments' => 'departments',
        'productGroups' => 'productGroups',
        'printGroups' => 'printGroups',
        'deleted' => 'deleted',
        'locked' => 'locked',
        'commissionPercent' => 'commissionPercent',
        'uomId' => 'uomId',
        'symbol' => 'symbol',
        'uomMultiplier' => 'uomMultiplier',
        'containerSKU' => 'containerSKU',
        'earnsLoyalty' => 'earnsLoyalty',
        'launchModifiers' => 'launchModifiers',
        'allowEbt' => 'allowEbt',
        'priceLists' => 'priceLists',
        'modifiersForUpsell' => 'modifiersForUpsell'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tenant' => 'setTenant',
        'sku' => 'setSku',
        'barcode' => 'setBarcode',
        'name' => 'setName',
        'description' => 'setDescription',
        'prodType' => 'setProdType',
        'image' => 'setImage',
        'printOrderReceipt' => 'setPrintOrderReceipt',
        'extra' => 'setExtra',
        'custom' => 'setCustom',
        'modifiers' => 'setModifiers',
        'departments' => 'setDepartments',
        'productGroups' => 'setProductGroups',
        'printGroups' => 'setPrintGroups',
        'deleted' => 'setDeleted',
        'locked' => 'setLocked',
        'commissionPercent' => 'setCommissionPercent',
        'uomId' => 'setUomId',
        'symbol' => 'setSymbol',
        'uomMultiplier' => 'setUomMultiplier',
        'containerSKU' => 'setContainerSKU',
        'earnsLoyalty' => 'setEarnsLoyalty',
        'launchModifiers' => 'setLaunchModifiers',
        'allowEbt' => 'setAllowEbt',
        'priceLists' => 'setPriceLists',
        'modifiersForUpsell' => 'setModifiersForUpsell'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tenant' => 'getTenant',
        'sku' => 'getSku',
        'barcode' => 'getBarcode',
        'name' => 'getName',
        'description' => 'getDescription',
        'prodType' => 'getProdType',
        'image' => 'getImage',
        'printOrderReceipt' => 'getPrintOrderReceipt',
        'extra' => 'getExtra',
        'custom' => 'getCustom',
        'modifiers' => 'getModifiers',
        'departments' => 'getDepartments',
        'productGroups' => 'getProductGroups',
        'printGroups' => 'getPrintGroups',
        'deleted' => 'getDeleted',
        'locked' => 'getLocked',
        'commissionPercent' => 'getCommissionPercent',
        'uomId' => 'getUomId',
        'symbol' => 'getSymbol',
        'uomMultiplier' => 'getUomMultiplier',
        'containerSKU' => 'getContainerSKU',
        'earnsLoyalty' => 'getEarnsLoyalty',
        'launchModifiers' => 'getLaunchModifiers',
        'allowEbt' => 'getAllowEbt',
        'priceLists' => 'getPriceLists',
        'modifiersForUpsell' => 'getModifiersForUpsell'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tenant'] = $data['tenant'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['barcode'] = $data['barcode'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['prodType'] = $data['prodType'] ?? null;
        $this->container['image'] = $data['image'] ?? null;
        $this->container['printOrderReceipt'] = $data['printOrderReceipt'] ?? null;
        $this->container['extra'] = $data['extra'] ?? null;
        $this->container['custom'] = $data['custom'] ?? null;
        $this->container['modifiers'] = $data['modifiers'] ?? null;
        $this->container['departments'] = $data['departments'] ?? null;
        $this->container['productGroups'] = $data['productGroups'] ?? null;
        $this->container['printGroups'] = $data['printGroups'] ?? null;
        $this->container['deleted'] = $data['deleted'] ?? null;
        $this->container['locked'] = $data['locked'] ?? null;
        $this->container['commissionPercent'] = $data['commissionPercent'] ?? null;
        $this->container['uomId'] = $data['uomId'] ?? null;
        $this->container['symbol'] = $data['symbol'] ?? null;
        $this->container['uomMultiplier'] = $data['uomMultiplier'] ?? null;
        $this->container['containerSKU'] = $data['containerSKU'] ?? null;
        $this->container['earnsLoyalty'] = $data['earnsLoyalty'] ?? null;
        $this->container['launchModifiers'] = $data['launchModifiers'] ?? null;
        $this->container['allowEbt'] = $data['allowEbt'] ?? null;
        $this->container['priceLists'] = $data['priceLists'] ?? null;
        $this->container['modifiersForUpsell'] = $data['modifiersForUpsell'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tenant
     *
     * @return int|null
     */
    public function getTenant()
    {
        return $this->container['tenant'];
    }

    /**
     * Sets tenant
     *
     * @param int|null $tenant Tenant id
     *
     * @return self
     */
    public function setTenant($tenant)
    {
        $this->container['tenant'] = $tenant;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets barcode
     *
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->container['barcode'];
    }

    /**
     * Sets barcode
     *
     * @param string|null $barcode Product Barcode
     *
     * @return self
     */
    public function setBarcode($barcode)
    {
        $this->container['barcode'] = $barcode;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Product Name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Product Description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets prodType
     *
     * @return string|null
     */
    public function getProdType()
    {
        return $this->container['prodType'];
    }

    /**
     * Sets prodType
     *
     * @param string|null $prodType The internal type of product
     *
     * @return self
     */
    public function setProdType($prodType)
    {
        $this->container['prodType'] = $prodType;

        return $this;
    }

    /**
     * Gets image
     *
     * @return string|null
     */
    public function getImage()
    {
        return $this->container['image'];
    }

    /**
     * Sets image
     *
     * @param string|null $image Product Image
     *
     * @return self
     */
    public function setImage($image)
    {
        $this->container['image'] = $image;

        return $this;
    }

    /**
     * Gets printOrderReceipt
     *
     * @return int|null
     */
    public function getPrintOrderReceipt()
    {
        return $this->container['printOrderReceipt'];
    }

    /**
     * Sets printOrderReceipt
     *
     * @param int|null $printOrderReceipt The product need to be printed on secondary printer or not
     *
     * @return self
     */
    public function setPrintOrderReceipt($printOrderReceipt)
    {
        $this->container['printOrderReceipt'] = $printOrderReceipt;

        return $this;
    }

    /**
     * Gets extra
     *
     * @return \SmartVolution\Model\ProductExtraDetailsVii|null
     */
    public function getExtra()
    {
        return $this->container['extra'];
    }

    /**
     * Sets extra
     *
     * @param \SmartVolution\Model\ProductExtraDetailsVii|null $extra extra
     *
     * @return self
     */
    public function setExtra($extra)
    {
        $this->container['extra'] = $extra;

        return $this;
    }

    /**
     * Gets custom
     *
     * @return \SmartVolution\Model\ProductCustomDetails|null
     */
    public function getCustom()
    {
        return $this->container['custom'];
    }

    /**
     * Sets custom
     *
     * @param \SmartVolution\Model\ProductCustomDetails|null $custom custom
     *
     * @return self
     */
    public function setCustom($custom)
    {
        $this->container['custom'] = $custom;

        return $this;
    }

    /**
     * Gets modifiers
     *
     * @return int[]|null
     */
    public function getModifiers()
    {
        return $this->container['modifiers'];
    }

    /**
     * Sets modifiers
     *
     * @param int[]|null $modifiers List of usage Ids to assign to product
     *
     * @return self
     */
    public function setModifiers($modifiers)
    {
        $this->container['modifiers'] = $modifiers;

        return $this;
    }

    /**
     * Gets departments
     *
     * @return int[]|null
     */
    public function getDepartments()
    {
        return $this->container['departments'];
    }

    /**
     * Sets departments
     *
     * @param int[]|null $departments List of department Ids to assign to product
     *
     * @return self
     */
    public function setDepartments($departments)
    {
        $this->container['departments'] = $departments;

        return $this;
    }

    /**
     * Gets productGroups
     *
     * @return int[]|null
     */
    public function getProductGroups()
    {
        return $this->container['productGroups'];
    }

    /**
     * Sets productGroups
     *
     * @param int[]|null $productGroups List of product group Ids to assign to product
     *
     * @return self
     */
    public function setProductGroups($productGroups)
    {
        $this->container['productGroups'] = $productGroups;

        return $this;
    }

    /**
     * Gets printGroups
     *
     * @return int[]|null
     */
    public function getPrintGroups()
    {
        return $this->container['printGroups'];
    }

    /**
     * Sets printGroups
     *
     * @param int[]|null $printGroups List of print group Ids to assign to product
     *
     * @return self
     */
    public function setPrintGroups($printGroups)
    {
        $this->container['printGroups'] = $printGroups;

        return $this;
    }

    /**
     * Gets deleted
     *
     * @return bool|null
     */
    public function getDeleted()
    {
        return $this->container['deleted'];
    }

    /**
     * Sets deleted
     *
     * @param bool|null $deleted Boolean for whether the product is deleted
     *
     * @return self
     */
    public function setDeleted($deleted)
    {
        $this->container['deleted'] = $deleted;

        return $this;
    }

    /**
     * Gets locked
     *
     * @return bool|null
     */
    public function getLocked()
    {
        return $this->container['locked'];
    }

    /**
     * Sets locked
     *
     * @param bool|null $locked Boolean for whether the product is locked
     *
     * @return self
     */
    public function setLocked($locked)
    {
        $this->container['locked'] = $locked;

        return $this;
    }

    /**
     * Gets commissionPercent
     *
     * @return double|null
     */
    public function getCommissionPercent()
    {
        return $this->container['commissionPercent'];
    }

    /**
     * Sets commissionPercent
     *
     * @param double|null $commissionPercent Product Commission Percent
     *
     * @return self
     */
    public function setCommissionPercent($commissionPercent)
    {
        $this->container['commissionPercent'] = $commissionPercent;

        return $this;
    }

    /**
     * Gets uomId
     *
     * @return int|null
     */
    public function getUomId()
    {
        return $this->container['uomId'];
    }

    /**
     * Sets uomId
     *
     * @param int|null $uomId UOM Id
     *
     * @return self
     */
    public function setUomId($uomId)
    {
        $this->container['uomId'] = $uomId;

        return $this;
    }

    /**
     * Gets symbol
     *
     * @return string|null
     */
    public function getSymbol()
    {
        return $this->container['symbol'];
    }

    /**
     * Sets symbol
     *
     * @param string|null $symbol UOM Symbol
     *
     * @return self
     */
    public function setSymbol($symbol)
    {
        $this->container['symbol'] = $symbol;

        return $this;
    }

    /**
     * Gets uomMultiplier
     *
     * @return double|null
     */
    public function getUomMultiplier()
    {
        return $this->container['uomMultiplier'];
    }

    /**
     * Sets uomMultiplier
     *
     * @param double|null $uomMultiplier UOM Multiplier
     *
     * @return self
     */
    public function setUomMultiplier($uomMultiplier)
    {
        $this->container['uomMultiplier'] = $uomMultiplier;

        return $this;
    }

    /**
     * Gets containerSKU
     *
     * @return string|null
     */
    public function getContainerSKU()
    {
        return $this->container['containerSKU'];
    }

    /**
     * Sets containerSKU
     *
     * @param string|null $containerSKU Container SKU
     *
     * @return self
     */
    public function setContainerSKU($containerSKU)
    {
        $this->container['containerSKU'] = $containerSKU;

        return $this;
    }

    /**
     * Gets earnsLoyalty
     *
     * @return string|null
     */
    public function getEarnsLoyalty()
    {
        return $this->container['earnsLoyalty'];
    }

    /**
     * Sets earnsLoyalty
     *
     * @param string|null $earnsLoyalty Earns Loyalty
     *
     * @return self
     */
    public function setEarnsLoyalty($earnsLoyalty)
    {
        $this->container['earnsLoyalty'] = $earnsLoyalty;

        return $this;
    }

    /**
     * Gets launchModifiers
     *
     * @return string|null
     */
    public function getLaunchModifiers()
    {
        return $this->container['launchModifiers'];
    }

    /**
     * Sets launchModifiers
     *
     * @param string|null $launchModifiers Launch Modifiers
     *
     * @return self
     */
    public function setLaunchModifiers($launchModifiers)
    {
        $this->container['launchModifiers'] = $launchModifiers;

        return $this;
    }

    /**
     * Gets allowEbt
     *
     * @return bool|null
     */
    public function getAllowEbt()
    {
        return $this->container['allowEbt'];
    }

    /**
     * Sets allowEbt
     *
     * @param bool|null $allowEbt Allow EBT
     *
     * @return self
     */
    public function setAllowEbt($allowEbt)
    {
        $this->container['allowEbt'] = $allowEbt;

        return $this;
    }

    /**
     * Gets priceLists
     *
     * @return \SmartVolution\Model\PriceListIn|null
     */
    public function getPriceLists()
    {
        return $this->container['priceLists'];
    }

    /**
     * Sets priceLists
     *
     * @param \SmartVolution\Model\PriceListIn|null $priceLists priceLists
     *
     * @return self
     */
    public function setPriceLists($priceLists)
    {
        $this->container['priceLists'] = $priceLists;

        return $this;
    }

    /**
     * Gets modifiersForUpsell
     *
     * @return bool|null
     */
    public function getModifiersForUpsell()
    {
        return $this->container['modifiersForUpsell'];
    }

    /**
     * Sets modifiersForUpsell
     *
     * @param bool|null $modifiersForUpsell ModifiersForUpsell
     *
     * @return self
     */
    public function setModifiersForUpsell($modifiersForUpsell)
    {
        $this->container['modifiersForUpsell'] = $modifiersForUpsell;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


