<?php
/**
 * ConfigForWeb
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SmartVolution
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * SV Register Web-services
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 4.15
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SmartVolution\Model;

use \ArrayAccess;
use \SmartVolution\ObjectSerializer;

/**
 * ConfigForWeb Class Doc Comment
 *
 * @category Class
 * @description 
 * @package  SmartVolution
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ConfigForWeb implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ConfigForWeb';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'configKeyId' => 'int',
        'category' => 'string',
        'name' => 'string',
        'description' => 'string',
        'configType' => 'string',
        'defaultValue' => 'string',
        'setValue' => 'string',
        'readOnly' => 'bool',
        'listOptions' => 'string[]',
        'configImageByte' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'configKeyId' => 'int64',
        'category' => null,
        'name' => null,
        'description' => null,
        'configType' => null,
        'defaultValue' => null,
        'setValue' => null,
        'readOnly' => null,
        'listOptions' => null,
        'configImageByte' => 'byte'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'configKeyId' => 'configKeyId',
        'category' => 'category',
        'name' => 'name',
        'description' => 'description',
        'configType' => 'configType',
        'defaultValue' => 'defaultValue',
        'setValue' => 'setValue',
        'readOnly' => 'readOnly',
        'listOptions' => 'listOptions',
        'configImageByte' => 'configImageByte'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'configKeyId' => 'setConfigKeyId',
        'category' => 'setCategory',
        'name' => 'setName',
        'description' => 'setDescription',
        'configType' => 'setConfigType',
        'defaultValue' => 'setDefaultValue',
        'setValue' => 'setSetValue',
        'readOnly' => 'setReadOnly',
        'listOptions' => 'setListOptions',
        'configImageByte' => 'setConfigImageByte'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'configKeyId' => 'getConfigKeyId',
        'category' => 'getCategory',
        'name' => 'getName',
        'description' => 'getDescription',
        'configType' => 'getConfigType',
        'defaultValue' => 'getDefaultValue',
        'setValue' => 'getSetValue',
        'readOnly' => 'getReadOnly',
        'listOptions' => 'getListOptions',
        'configImageByte' => 'getConfigImageByte'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['configKeyId'] = $data['configKeyId'] ?? null;
        $this->container['category'] = $data['category'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['configType'] = $data['configType'] ?? null;
        $this->container['defaultValue'] = $data['defaultValue'] ?? null;
        $this->container['setValue'] = $data['setValue'] ?? null;
        $this->container['readOnly'] = $data['readOnly'] ?? null;
        $this->container['listOptions'] = $data['listOptions'] ?? null;
        $this->container['configImageByte'] = $data['configImageByte'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets configKeyId
     *
     * @return int|null
     */
    public function getConfigKeyId()
    {
        return $this->container['configKeyId'];
    }

    /**
     * Sets configKeyId
     *
     * @param int|null $configKeyId The Config key id
     *
     * @return self
     */
    public function setConfigKeyId($configKeyId)
    {
        $this->container['configKeyId'] = $configKeyId;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string|null $category The Configuration category
     *
     * @return self
     */
    public function setCategory($category)
    {
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The Configuration name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The Configuration description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets configType
     *
     * @return string|null
     */
    public function getConfigType()
    {
        return $this->container['configType'];
    }

    /**
     * Sets configType
     *
     * @param string|null $configType The Configuration type
     *
     * @return self
     */
    public function setConfigType($configType)
    {
        $this->container['configType'] = $configType;

        return $this;
    }

    /**
     * Gets defaultValue
     *
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->container['defaultValue'];
    }

    /**
     * Sets defaultValue
     *
     * @param string|null $defaultValue The Configuration default value
     *
     * @return self
     */
    public function setDefaultValue($defaultValue)
    {
        $this->container['defaultValue'] = $defaultValue;

        return $this;
    }

    /**
     * Gets setValue
     *
     * @return string|null
     */
    public function getSetValue()
    {
        return $this->container['setValue'];
    }

    /**
     * Sets setValue
     *
     * @param string|null $setValue The Configuration value
     *
     * @return self
     */
    public function setSetValue($setValue)
    {
        $this->container['setValue'] = $setValue;

        return $this;
    }

    /**
     * Gets readOnly
     *
     * @return bool|null
     */
    public function getReadOnly()
    {
        return $this->container['readOnly'];
    }

    /**
     * Sets readOnly
     *
     * @param bool|null $readOnly flag if config is read only
     *
     * @return self
     */
    public function setReadOnly($readOnly)
    {
        $this->container['readOnly'] = $readOnly;

        return $this;
    }

    /**
     * Gets listOptions
     *
     * @return string[]|null
     */
    public function getListOptions()
    {
        return $this->container['listOptions'];
    }

    /**
     * Sets listOptions
     *
     * @param string[]|null $listOptions if the type is list, this contains options
     *
     * @return self
     */
    public function setListOptions($listOptions)
    {
        $this->container['listOptions'] = $listOptions;

        return $this;
    }

    /**
     * Gets configImageByte
     *
     * @return string[]|null
     */
    public function getConfigImageByte()
    {
        return $this->container['configImageByte'];
    }

    /**
     * Sets configImageByte
     *
     * @param string[]|null $configImageByte The configuration image bytes
     *
     * @return self
     */
    public function setConfigImageByte($configImageByte)
    {
        $this->container['configImageByte'] = $configImageByte;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


