# SmartVolution\V2reportsApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAgressoReport()**](V2reportsApi.md#getAgressoReport) | **GET** /v2/reports/custom/{id} | Calculates a report between two datetimes
[**getAllReportsForTenantV2()**](V2reportsApi.md#getAllReportsForTenantV2) | **GET** /v2/reports | Gets all the products that should be displayed in the browser for a device
[**getReportByIdV2()**](V2reportsApi.md#getReportByIdV2) | **GET** /v2/reports/{id} | Calculates a report between two datetimes
[**getReportByIdV3()**](V2reportsApi.md#getReportByIdV3) | **GET** /v3/reports/{id} | Calculates a report between two datetimes
[**getReportGroupsV2()**](V2reportsApi.md#getReportGroupsV2) | **GET** /v2/reportGroups | Gets data of report groups for a tenant


## `getAgressoReport()`

```php
getAgressoReport($id, $start, $end, $tenant, $timeZone): string[]
```

Calculates a report between two datetimes

Authenticated Devices do not have access to this call

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V2reportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of report to query
$start = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | start datetime eg 2015-07-07T14:43:00+01:00
$end = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | end datetime eg 2015-07-07T14:43:00+01:00
$tenant = 56; // int | tenant data to query
$timeZone = 'timeZone_example'; // string | eg +01:00

try {
    $result = $apiInstance->getAgressoReport($id, $start, $end, $tenant, $timeZone);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V2reportsApi->getAgressoReport: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of report to query |
 **start** | **\DateTime**| start datetime eg 2015-07-07T14:43:00+01:00 |
 **end** | **\DateTime**| end datetime eg 2015-07-07T14:43:00+01:00 |
 **tenant** | **int**| tenant data to query | [optional]
 **timeZone** | **string**| eg +01:00 | [optional]

### Return type

**string[]**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllReportsForTenantV2()`

```php
getAllReportsForTenantV2($groupId, $tenant): \SmartVolution\Model\ProductBrowserMapping[]
```

Gets all the products that should be displayed in the browser for a device

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V2reportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$groupId = 56; // int | report group id
$tenant = 56; // int | tenant id

try {
    $result = $apiInstance->getAllReportsForTenantV2($groupId, $tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V2reportsApi->getAllReportsForTenantV2: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **int**| report group id |
 **tenant** | **int**| tenant id | [optional]

### Return type

[**\SmartVolution\Model\ProductBrowserMapping[]**](../Model/ProductBrowserMapping.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReportByIdV2()`

```php
getReportByIdV2($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier): \SmartVolution\Model\Report[]
```

Calculates a report between two datetimes

Authenticated Devices do not have access to this call

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V2reportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of report to query
$start = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | start datetime eg 2015-07-07T14:43:00+01:00
$end = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | end datetime eg 2015-07-07T14:43:00+01:00
$tenant = 56; // int | tenant data to query
$timeZone = 'timeZone_example'; // string | eg +01:00
$device = 56; // int | device id as a filter
$store = array(56); // int[] | store id as a filter
$dept = array(56); // int[] | dept id as a filter
$supplier = array(56); // int[] | supplier id as a filter

try {
    $result = $apiInstance->getReportByIdV2($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V2reportsApi->getReportByIdV2: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of report to query |
 **start** | **\DateTime**| start datetime eg 2015-07-07T14:43:00+01:00 |
 **end** | **\DateTime**| end datetime eg 2015-07-07T14:43:00+01:00 |
 **tenant** | **int**| tenant data to query | [optional]
 **timeZone** | **string**| eg +01:00 | [optional]
 **device** | **int**| device id as a filter | [optional]
 **store** | [**int[]**](../Model/int.md)| store id as a filter | [optional]
 **dept** | [**int[]**](../Model/int.md)| dept id as a filter | [optional]
 **supplier** | [**int[]**](../Model/int.md)| supplier id as a filter | [optional]

### Return type

[**\SmartVolution\Model\Report[]**](../Model/Report.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReportByIdV3()`

```php
getReportByIdV3($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier): \SmartVolution\Model\Report[]
```

Calculates a report between two datetimes

Authenticated Devices do not have access to this call

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V2reportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of report to query
$start = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | start datetime eg 2015-07-07T14:43:00+01:00
$end = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | end datetime eg 2015-07-07T14:43:00+01:00
$tenant = 56; // int | tenant data to query
$timeZone = 'timeZone_example'; // string | eg +01:00
$device = 56; // int | device id as a filter
$store = array(56); // int[] | store id as a filter
$dept = array(56); // int[] | dept id as a filter
$supplier = array(56); // int[] | supplier id as a filter

try {
    $result = $apiInstance->getReportByIdV3($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V2reportsApi->getReportByIdV3: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of report to query |
 **start** | **\DateTime**| start datetime eg 2015-07-07T14:43:00+01:00 |
 **end** | **\DateTime**| end datetime eg 2015-07-07T14:43:00+01:00 |
 **tenant** | **int**| tenant data to query | [optional]
 **timeZone** | **string**| eg +01:00 | [optional]
 **device** | **int**| device id as a filter | [optional]
 **store** | [**int[]**](../Model/int.md)| store id as a filter | [optional]
 **dept** | [**int[]**](../Model/int.md)| dept id as a filter | [optional]
 **supplier** | [**int[]**](../Model/int.md)| supplier id as a filter | [optional]

### Return type

[**\SmartVolution\Model\Report[]**](../Model/Report.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReportGroupsV2()`

```php
getReportGroupsV2(): \SmartVolution\Model\ReportGroup[]
```

Gets data of report groups for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V2reportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getReportGroupsV2();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V2reportsApi->getReportGroupsV2: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\ReportGroup[]**](../Model/ReportGroup.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
