# SmartVolution\V1transfersApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createTransfer()**](V1transfersApi.md#createTransfer) | **POST** /v1/transfers | Create a new transfer in the system
[**getAllTransfers()**](V1transfersApi.md#getAllTransfers) | **GET** /v1/transfers | Gets a list of all the transfers for a tenant
[**getTransferById()**](V1transfersApi.md#getTransferById) | **GET** /v1/transfers/{id} | Gets a list of all the transfers for a tenant
[**getTransferIdentifier()**](V1transfersApi.md#getTransferIdentifier) | **GET** /v1/transfer/identifier/{tenantId} | Gets the last Transfer Identifier
[**updateTransfer()**](V1transfersApi.md#updateTransfer) | **PATCH** /v1/transfers | Update a new transfer in the system


## `createTransfer()`

```php
createTransfer($transfer): int
```

Create a new transfer in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1transfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transfer = new \SmartVolution\Model\TransferIn(); // \SmartVolution\Model\TransferIn | Transaction object that need to be created

try {
    $result = $apiInstance->createTransfer($transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transfersApi->createTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transfer** | [**\SmartVolution\Model\TransferIn**](../Model/TransferIn.md)| Transaction object that need to be created |

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllTransfers()`

```php
getAllTransfers($tenant, $from, $to, $status, $fromStore, $toStore): \SmartVolution\Model\Product[]
```

Gets a list of all the transfers for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1transfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$from = 56; // int | Create time range, a time in seconds since midnight January 1st 1970 UTC
$to = 56; // int | Create time range, a time in seconds since midnight January 1st 1970 UTC
$status = array('status_example'); // string[] | Transfer Status
$fromStore = array(56); // int[] | Transfer from store
$toStore = array(56); // int[] | Transfer to store

try {
    $result = $apiInstance->getAllTransfers($tenant, $from, $to, $status, $fromStore, $toStore);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transfersApi->getAllTransfers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **from** | **int**| Create time range, a time in seconds since midnight January 1st 1970 UTC | [optional]
 **to** | **int**| Create time range, a time in seconds since midnight January 1st 1970 UTC | [optional]
 **status** | [**string[]**](../Model/string.md)| Transfer Status | [optional]
 **fromStore** | [**int[]**](../Model/int.md)| Transfer from store | [optional]
 **toStore** | [**int[]**](../Model/int.md)| Transfer to store | [optional]

### Return type

[**\SmartVolution\Model\Product[]**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTransferById()`

```php
getTransferById($id): \SmartVolution\Model\Product[]
```

Gets a list of all the transfers for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1transfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of transfer

try {
    $result = $apiInstance->getTransferById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transfersApi->getTransferById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of transfer |

### Return type

[**\SmartVolution\Model\Product[]**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTransferIdentifier()`

```php
getTransferIdentifier($tenantId): string[]
```

Gets the last Transfer Identifier

Gets the last Transfer Identifier

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1transfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenantId = 56; // int | Tenant Id

try {
    $result = $apiInstance->getTransferIdentifier($tenantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transfersApi->getTransferIdentifier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenantId** | **int**| Tenant Id |

### Return type

**string[]**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateTransfer()`

```php
updateTransfer($transfer)
```

Update a new transfer in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1transfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transfer = new \SmartVolution\Model\TransferInEdit(); // \SmartVolution\Model\TransferInEdit | Transaction object that need to be created

try {
    $apiInstance->updateTransfer($transfer);
} catch (Exception $e) {
    echo 'Exception when calling V1transfersApi->updateTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transfer** | [**\SmartVolution\Model\TransferInEdit**](../Model/TransferInEdit.md)| Transaction object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
