# SmartVolution\V1stockApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getStockForListOfProducts()**](V1stockApi.md#getStockForListOfProducts) | **GET** /v1/stock/ | gets the current stock count for a list of product
[**getStockForProduct()**](V1stockApi.md#getStockForProduct) | **GET** /v1/stock/{id} | gets the current stock count for a product
[**updateStock()**](V1stockApi.md#updateStock) | **PATCH** /v1/stock | increment or decrement the existing stored value by the quantity
[**updateStockViaReplace()**](V1stockApi.md#updateStockViaReplace) | **PUT** /v1/stock | use the value in the stock to update the record


## `getStockForListOfProducts()`

```php
getStockForListOfProducts($id, $since): \SmartVolution\Model\Stock[]
```

gets the current stock count for a list of product

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1stockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = array(56); // int[]
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC

try {
    $result = $apiInstance->getStockForListOfProducts($id, $since);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1stockApi->getStockForListOfProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [**int[]**](../Model/int.md)|  | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]

### Return type

[**\SmartVolution\Model\Stock[]**](../Model/Stock.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockForProduct()`

```php
getStockForProduct($id, $stores, $accrossStore): \SmartVolution\Model\Stock
```

gets the current stock count for a product

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1stockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of product to query
$stores = array(56); // int[] | Id list of store to query, only for user
$accrossStore = True; // bool | Used for device, the result is accords store or not

try {
    $result = $apiInstance->getStockForProduct($id, $stores, $accrossStore);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1stockApi->getStockForProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of product to query |
 **stores** | [**int[]**](../Model/int.md)| Id list of store to query, only for user | [optional]
 **accrossStore** | **bool**| Used for device, the result is accords store or not | [optional]

### Return type

[**\SmartVolution\Model\Stock**](../Model/Stock.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateStock()`

```php
updateStock($stock): \SmartVolution\Model\StockUpdateResponse[]
```

increment or decrement the existing stored value by the quantity

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1stockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$stock = new \SmartVolution\Model\StockUpdateInList(); // \SmartVolution\Model\StockUpdateInList | Stock object that need to be update

try {
    $result = $apiInstance->updateStock($stock);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1stockApi->updateStock: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock** | [**\SmartVolution\Model\StockUpdateInList**](../Model/StockUpdateInList.md)| Stock object that need to be update |

### Return type

[**\SmartVolution\Model\StockUpdateResponse[]**](../Model/StockUpdateResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateStockViaReplace()`

```php
updateStockViaReplace($stockUpdateInList): \SmartVolution\Model\Stock[]
```

use the value in the stock to update the record

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1stockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$stockUpdateInList = new \SmartVolution\Model\StockUpdateInList(); // \SmartVolution\Model\StockUpdateInList

try {
    $result = $apiInstance->updateStockViaReplace($stockUpdateInList);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1stockApi->updateStockViaReplace: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stockUpdateInList** | [**\SmartVolution\Model\StockUpdateInList**](../Model/StockUpdateInList.md)|  |

### Return type

[**\SmartVolution\Model\Stock[]**](../Model/Stock.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
