# SmartVolution\V1reportsApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAllReportsForTenant()**](V1reportsApi.md#getAllReportsForTenant) | **GET** /v1/reports | Gets all the products that should be displayed in the browser for a device
[**getReportById()**](V1reportsApi.md#getReportById) | **GET** /v1/reports/{id} | Calculates a report between two datetimes
[**getReportGroups()**](V1reportsApi.md#getReportGroups) | **GET** /v1/reportGroups | Gets data of report groups for a tenant


## `getAllReportsForTenant()`

```php
getAllReportsForTenant($groupId, $tenant): \SmartVolution\Model\ProductBrowserMapping[]
```

Gets all the products that should be displayed in the browser for a device

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1reportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$groupId = 56; // int | report group id
$tenant = 56; // int | tenant id

try {
    $result = $apiInstance->getAllReportsForTenant($groupId, $tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1reportsApi->getAllReportsForTenant: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **int**| report group id |
 **tenant** | **int**| tenant id | [optional]

### Return type

[**\SmartVolution\Model\ProductBrowserMapping[]**](../Model/ProductBrowserMapping.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReportById()`

```php
getReportById($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier): \SmartVolution\Model\Report[]
```

Calculates a report between two datetimes

Authenticated Devices do not have access to this call

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1reportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of report to query
$start = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | start datetime eg 2015-07-07T14:43:00+01:00
$end = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | end datetime eg 2015-07-07T14:43:00+00:01
$tenant = 56; // int | tenant data to query
$timeZone = 'timeZone_example'; // string | eg +01:00
$device = 56; // int | device id as a filter
$store = array(56); // int[] | store id as a filter
$dept = array(56); // int[] | dept id as a filter
$supplier = array(56); // int[] | supplier id as a filter

try {
    $result = $apiInstance->getReportById($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1reportsApi->getReportById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of report to query |
 **start** | **\DateTime**| start datetime eg 2015-07-07T14:43:00+01:00 |
 **end** | **\DateTime**| end datetime eg 2015-07-07T14:43:00+00:01 |
 **tenant** | **int**| tenant data to query | [optional]
 **timeZone** | **string**| eg +01:00 | [optional]
 **device** | **int**| device id as a filter | [optional]
 **store** | [**int[]**](../Model/int.md)| store id as a filter | [optional]
 **dept** | [**int[]**](../Model/int.md)| dept id as a filter | [optional]
 **supplier** | [**int[]**](../Model/int.md)| supplier id as a filter | [optional]

### Return type

[**\SmartVolution\Model\Report[]**](../Model/Report.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReportGroups()`

```php
getReportGroups(): \SmartVolution\Model\ReportGroup[]
```

Gets data of report groups for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1reportsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getReportGroups();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1reportsApi->getReportGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\ReportGroup[]**](../Model/ReportGroup.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
