# SmartVolution\V1productstaxesApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAllProductTaxes()**](V1productstaxesApi.md#getAllProductTaxes) | **GET** /v1/products/taxes | Gets a list of all the taxes assigned to products for a tenant
[**getAllProductTaxesV2()**](V1productstaxesApi.md#getAllProductTaxesV2) | **GET** /v2/products/taxes | Gets a list of all the taxes assigned to products for a tenant
[**getAllProductTaxesV3()**](V1productstaxesApi.md#getAllProductTaxesV3) | **GET** /v3/products/taxes | Gets a list of all the taxes assigned to products for a tenant


## `getAllProductTaxes()`

```php
getAllProductTaxes($tenant, $since, $deleted): \SmartVolution\Model\ProductTax[]
```

Gets a list of all the taxes assigned to products for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productstaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllProductTaxes($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productstaxesApi->getAllProductTaxes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\ProductTax[]**](../Model/ProductTax.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllProductTaxesV2()`

```php
getAllProductTaxesV2($tenant, $since, $deleted): \SmartVolution\Model\ProductTax[]
```

Gets a list of all the taxes assigned to products for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productstaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllProductTaxesV2($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productstaxesApi->getAllProductTaxesV2: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\ProductTax[]**](../Model/ProductTax.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllProductTaxesV3()`

```php
getAllProductTaxesV3($tenant, $since, $deleted): \SmartVolution\Model\ProductTaxViii[]
```

Gets a list of all the taxes assigned to products for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productstaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllProductTaxesV3($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productstaxesApi->getAllProductTaxesV3: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\ProductTaxViii[]**](../Model/ProductTaxViii.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
