# SmartVolution\V1productsbrowserApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**addProductToLayout()**](V1productsbrowserApi.md#addProductToLayout) | **POST** /v1/products/browser/layouts | add a product to a layout
[**createLayout()**](V1productsbrowserApi.md#createLayout) | **POST** /v1/products/browser | Create a new layout in the system
[**deleteLayout()**](V1productsbrowserApi.md#deleteLayout) | **DELETE** /v1/products/browser/{id} | remove a layout
[**deleteProductFromLayout()**](V1productsbrowserApi.md#deleteProductFromLayout) | **DELETE** /v1/products/browser/layouts/{id} | remove a product from a layout
[**editProductInLayout()**](V1productsbrowserApi.md#editProductInLayout) | **PATCH** /v1/products/browser/layouts | edit a product to a layout
[**getAllProductBrowserMappingsForDevice()**](V1productsbrowserApi.md#getAllProductBrowserMappingsForDevice) | **GET** /v1/products/browser/layouts | Gets all the products that should be displayed in the browser for a device
[**getProductBrowserById()**](V1productsbrowserApi.md#getProductBrowserById) | **GET** /v1/products/browser/{id} | Gets product browser for a specific id
[**getProductBrowserLayouts()**](V1productsbrowserApi.md#getProductBrowserLayouts) | **GET** /v1/products/browser | Gets a list of all the product browser layouts for a tenant
[**getProductBrowserMappingsForLayout()**](V1productsbrowserApi.md#getProductBrowserMappingsForLayout) | **GET** /v1/products/browser/layouts/{id} | Gets all the products for a specific layout
[**replaceBrowserLayouts()**](V1productsbrowserApi.md#replaceBrowserLayouts) | **PUT** /v1/products/browser | replace the entire contents of a browser
[**updateLayout()**](V1productsbrowserApi.md#updateLayout) | **PATCH** /v1/products/browser | edit an existing layout in the system


## `addProductToLayout()`

```php
addProductToLayout($productBrowserMapping)
```

add a product to a layout

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$productBrowserMapping = new \SmartVolution\Model\ProductBrowserMappingIn(); // \SmartVolution\Model\ProductBrowserMappingIn | Layout object that need to be created

try {
    $apiInstance->addProductToLayout($productBrowserMapping);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->addProductToLayout: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productBrowserMapping** | [**\SmartVolution\Model\ProductBrowserMappingIn**](../Model/ProductBrowserMappingIn.md)| Layout object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createLayout()`

```php
createLayout($productBrowserLayout)
```

Create a new layout in the system

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$productBrowserLayout = new \SmartVolution\Model\ProductBrowserLayoutIn(); // \SmartVolution\Model\ProductBrowserLayoutIn | Layout object that need to be created

try {
    $apiInstance->createLayout($productBrowserLayout);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->createLayout: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productBrowserLayout** | [**\SmartVolution\Model\ProductBrowserLayoutIn**](../Model/ProductBrowserLayoutIn.md)| Layout object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteLayout()`

```php
deleteLayout($id)
```

remove a layout

Not currently implemented

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | browser id to be removed

try {
    $apiInstance->deleteLayout($id);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->deleteLayout: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| browser id to be removed |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductFromLayout()`

```php
deleteProductFromLayout($id, $value)
```

remove a product from a layout

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | id
$value = 56; // int | position

try {
    $apiInstance->deleteProductFromLayout($id, $value);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->deleteProductFromLayout: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| id |
 **value** | **int**| position |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `editProductInLayout()`

```php
editProductInLayout($productBrowserLayout)
```

edit a product to a layout

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$productBrowserLayout = new \SmartVolution\Model\ProductBrowserMappingIn(); // \SmartVolution\Model\ProductBrowserMappingIn | Layout object that need to be created

try {
    $apiInstance->editProductInLayout($productBrowserLayout);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->editProductInLayout: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productBrowserLayout** | [**\SmartVolution\Model\ProductBrowserMappingIn**](../Model/ProductBrowserMappingIn.md)| Layout object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllProductBrowserMappingsForDevice()`

```php
getAllProductBrowserMappingsForDevice($since, $deleted): \SmartVolution\Model\ProductBrowserMapping[]
```

Gets all the products that should be displayed in the browser for a device

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllProductBrowserMappingsForDevice($since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->getAllProductBrowserMappingsForDevice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\ProductBrowserMapping[]**](../Model/ProductBrowserMapping.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductBrowserById()`

```php
getProductBrowserById($id): \SmartVolution\Model\ProductBrowserLayoutInEdit[]
```

Gets product browser for a specific id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | id of the browser

try {
    $result = $apiInstance->getProductBrowserById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->getProductBrowserById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| id of the browser |

### Return type

[**\SmartVolution\Model\ProductBrowserLayoutInEdit[]**](../Model/ProductBrowserLayoutInEdit.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductBrowserLayouts()`

```php
getProductBrowserLayouts($tenant): \SmartVolution\Model\ProductBrowserLayout[]
```

Gets a list of all the product browser layouts for a tenant

if no tenant id is passed then will default to the user tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query

try {
    $result = $apiInstance->getProductBrowserLayouts($tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->getProductBrowserLayouts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]

### Return type

[**\SmartVolution\Model\ProductBrowserLayout[]**](../Model/ProductBrowserLayout.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductBrowserMappingsForLayout()`

```php
getProductBrowserMappingsForLayout($id): \SmartVolution\Model\ProductBrowserMapping[]
```

Gets all the products for a specific layout

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | id of the layout

try {
    $result = $apiInstance->getProductBrowserMappingsForLayout($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->getProductBrowserMappingsForLayout: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| id of the layout |

### Return type

[**\SmartVolution\Model\ProductBrowserMapping[]**](../Model/ProductBrowserMapping.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `replaceBrowserLayouts()`

```php
replaceBrowserLayouts($productBrowserMapping)
```

replace the entire contents of a browser

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$productBrowserMapping = new \SmartVolution\Model\ProductBrowserMappingInReplaceList(); // \SmartVolution\Model\ProductBrowserMappingInReplaceList | browser object containing new layouts

try {
    $apiInstance->replaceBrowserLayouts($productBrowserMapping);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->replaceBrowserLayouts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productBrowserMapping** | [**\SmartVolution\Model\ProductBrowserMappingInReplaceList**](../Model/ProductBrowserMappingInReplaceList.md)| browser object containing new layouts |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateLayout()`

```php
updateLayout($productBrowserLayout)
```

edit an existing layout in the system

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1productsbrowserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$productBrowserLayout = new \SmartVolution\Model\ProductBrowserLayoutInEdit(); // \SmartVolution\Model\ProductBrowserLayoutInEdit | User object containing edited fields

try {
    $apiInstance->updateLayout($productBrowserLayout);
} catch (Exception $e) {
    echo 'Exception when calling V1productsbrowserApi->updateLayout: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productBrowserLayout** | [**\SmartVolution\Model\ProductBrowserLayoutInEdit**](../Model/ProductBrowserLayoutInEdit.md)| User object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
