# SmartVolution\V1messagesApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createMessage()**](V1messagesApi.md#createMessage) | **POST** /v1/messages | Create a message in the system
[**deleteMessageById()**](V1messagesApi.md#deleteMessageById) | **DELETE** /v1/messages | Deletes a message by their id
[**getMessageBundleTypes()**](V1messagesApi.md#getMessageBundleTypes) | **GET** /v1/messageBundleTypes | Gets data of message bundle types for a tenant
[**getMessageBundles()**](V1messagesApi.md#getMessageBundles) | **GET** /v1/messageBundles | Gets data of message bundles for a tenant
[**getMessagePeriods()**](V1messagesApi.md#getMessagePeriods) | **GET** /v1/messagePeriods | Gets data of message periods for a tenant
[**getMessageSettingsByTenantId()**](V1messagesApi.md#getMessageSettingsByTenantId) | **GET** /v1/messageSettings | Gets data of message settings for a tenant
[**getMessageSettingsReorderAlert()**](V1messagesApi.md#getMessageSettingsReorderAlert) | **GET** /v1/messageSettingsReorderAlert | Gets data of message settings reorder alert for a tenant
[**getMessageTextsSent()**](V1messagesApi.md#getMessageTextsSent) | **GET** /v1/messageTextsSent | Gets data of message texts sent for a tenant
[**getMessagesAlert()**](V1messagesApi.md#getMessagesAlert) | **GET** /v1/messagesAlert | Check if the texts message alert dialog should be show
[**getMessagesQueued()**](V1messagesApi.md#getMessagesQueued) | **GET** /v1/messagesQueued | Gets data of message queued for a tenant
[**updateMessageSetting()**](V1messagesApi.md#updateMessageSetting) | **PATCH** /v1/messageSettings | Edit an existing message setting in the system


## `createMessage()`

```php
createMessage($message)
```

Create a message in the system

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$message = new \SmartVolution\Model\MessageIn(); // \SmartVolution\Model\MessageIn | Message object that need to be created

try {
    $apiInstance->createMessage($message);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->createMessage: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **message** | [**\SmartVolution\Model\MessageIn**](../Model/MessageIn.md)| Message object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteMessageById()`

```php
deleteMessageById($tenant, $customer, $appointment, $messageType)
```

Deletes a message by their id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of tenant of the messages to delete
$customer = 56; // int | Id of customer of the messages to delete
$appointment = 56; // int | Id of customer of the messages to delete
$messageType = 'messageType_example'; // string | Type of the messages to delete

try {
    $apiInstance->deleteMessageById($tenant, $customer, $appointment, $messageType);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->deleteMessageById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of tenant of the messages to delete | [optional]
 **customer** | **int**| Id of customer of the messages to delete | [optional]
 **appointment** | **int**| Id of customer of the messages to delete | [optional]
 **messageType** | **string**| Type of the messages to delete | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMessageBundleTypes()`

```php
getMessageBundleTypes(): \SmartVolution\Model\MessageBundleType[]
```

Gets data of message bundle types for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getMessageBundleTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->getMessageBundleTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\MessageBundleType[]**](../Model/MessageBundleType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMessageBundles()`

```php
getMessageBundles($messageBundleTypeId): \SmartVolution\Model\MessageBundle[]
```

Gets data of message bundles for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$messageBundleTypeId = 56; // int | Id of message bundle type

try {
    $result = $apiInstance->getMessageBundles($messageBundleTypeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->getMessageBundles: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageBundleTypeId** | **int**| Id of message bundle type | [optional]

### Return type

[**\SmartVolution\Model\MessageBundle[]**](../Model/MessageBundle.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMessagePeriods()`

```php
getMessagePeriods(): \SmartVolution\Model\MessagePeriod[]
```

Gets data of message periods for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getMessagePeriods();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->getMessagePeriods: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\MessagePeriod[]**](../Model/MessagePeriod.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMessageSettingsByTenantId()`

```php
getMessageSettingsByTenantId($tenant): \SmartVolution\Model\MessageSetting
```

Gets data of message settings for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query

try {
    $result = $apiInstance->getMessageSettingsByTenantId($tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->getMessageSettingsByTenantId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query |

### Return type

[**\SmartVolution\Model\MessageSetting**](../Model/MessageSetting.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMessageSettingsReorderAlert()`

```php
getMessageSettingsReorderAlert(): \SmartVolution\Model\MessageSettingsReorderAlert[]
```

Gets data of message settings reorder alert for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getMessageSettingsReorderAlert();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->getMessageSettingsReorderAlert: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\MessageSettingsReorderAlert[]**](../Model/MessageSettingsReorderAlert.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMessageTextsSent()`

```php
getMessageTextsSent($startDate, $endDate, $tenant): \SmartVolution\Model\TextsSent
```

Gets data of message texts sent for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$startDate = 56; // int
$endDate = 56; // int
$tenant = 56; // int | Id of Tenant to query

try {
    $result = $apiInstance->getMessageTextsSent($startDate, $endDate, $tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->getMessageTextsSent: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **startDate** | **int**|  |
 **endDate** | **int**|  |
 **tenant** | **int**| Id of Tenant to query | [optional]

### Return type

[**\SmartVolution\Model\TextsSent**](../Model/TextsSent.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMessagesAlert()`

```php
getMessagesAlert($tenant): bool
```

Check if the texts message alert dialog should be show

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query

try {
    $result = $apiInstance->getMessagesAlert($tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->getMessagesAlert: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMessagesQueued()`

```php
getMessagesQueued($tenant): \SmartVolution\Model\MessagesQueued
```

Gets data of message queued for a tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query

try {
    $result = $apiInstance->getMessagesQueued($tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->getMessagesQueued: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]

### Return type

[**\SmartVolution\Model\MessagesQueued**](../Model/MessagesQueued.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateMessageSetting()`

```php
updateMessageSetting($messageSettings)
```

Edit an existing message setting in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1messagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$messageSettings = new \SmartVolution\Model\MessageSettingInEdit(); // \SmartVolution\Model\MessageSettingInEdit | Message setting object containing edited fields

try {
    $apiInstance->updateMessageSetting($messageSettings);
} catch (Exception $e) {
    echo 'Exception when calling V1messagesApi->updateMessageSetting: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageSettings** | [**\SmartVolution\Model\MessageSettingInEdit**](../Model/MessageSettingInEdit.md)| Message setting object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
