# SmartVolution\V1enrollApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createDevice()**](V1enrollApi.md#createDevice) | **POST** /v1/device | Create a user account in the system
[**deleteDeviceById()**](V1enrollApi.md#deleteDeviceById) | **DELETE** /v1/device/{id} | Deletes a user by their id
[**enroll()**](V1enrollApi.md#enroll) | **GET** /v1/enroll/{provisionCode} | Enrolls a TCR device with the system
[**findDeviceById()**](V1enrollApi.md#findDeviceById) | **GET** /v1/device/{id} | Gets device details by their id
[**getAllDevices()**](V1enrollApi.md#getAllDevices) | **GET** /v1/device | Gets a list of all the devices for a tenant
[**unenroll()**](V1enrollApi.md#unenroll) | **GET** /v1/unenroll/{id} | unenrolls a TCR device with the system
[**updateDevice()**](V1enrollApi.md#updateDevice) | **PATCH** /v1/device | edit an existing device in the system
[**updateLastSyncForDevice()**](V1enrollApi.md#updateLastSyncForDevice) | **GET** /v1/device/checkin/{id} | edit the the lastSync of an existing device in the system


## `createDevice()`

```php
createDevice($device)
```

Create a user account in the system

This is not finalised as there is no authentication

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1enrollApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$device = new \SmartVolution\Model\DeviceIn(); // \SmartVolution\Model\DeviceIn | Device object that need to be created

try {
    $apiInstance->createDevice($device);
} catch (Exception $e) {
    echo 'Exception when calling V1enrollApi->createDevice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device** | [**\SmartVolution\Model\DeviceIn**](../Model/DeviceIn.md)| Device object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteDeviceById()`

```php
deleteDeviceById($id)
```

Deletes a user by their id

Non-Destructive in the database (Users are flagged as deleted)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1enrollApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of user to delete

try {
    $apiInstance->deleteDeviceById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1enrollApi->deleteDeviceById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of user to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `enroll()`

```php
enroll($provisionCode): \SmartVolution\Model\EnrolledDevice
```

Enrolls a TCR device with the system

The authentication token returned from this call should be used as a session cookie X-AUTH-TOKEN=<value> which will allow you to access the other services

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1enrollApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$provisionCode = 'provisionCode_example'; // string | The provision code provided for the device

try {
    $result = $apiInstance->enroll($provisionCode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1enrollApi->enroll: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **provisionCode** | **string**| The provision code provided for the device |

### Return type

[**\SmartVolution\Model\EnrolledDevice**](../Model/EnrolledDevice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `findDeviceById()`

```php
findDeviceById($id): \SmartVolution\Model\DeviceForWeb
```

Gets device details by their id

Authenticated Devices do not have access to this call

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1enrollApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of user to query

try {
    $result = $apiInstance->findDeviceById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1enrollApi->findDeviceById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of user to query |

### Return type

[**\SmartVolution\Model\DeviceForWeb**](../Model/DeviceForWeb.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllDevices()`

```php
getAllDevices($tenant, $storeId): \SmartVolution\Model\DeviceForWebListContainPrinter[]
```

Gets a list of all the devices for a tenant

if no tenant id is passed then will default to the user tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1enrollApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$storeId = 56; // int | Id of StoreId to query for device. The parameter only active for device

try {
    $result = $apiInstance->getAllDevices($tenant, $storeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1enrollApi->getAllDevices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **storeId** | **int**| Id of StoreId to query for device. The parameter only active for device | [optional]

### Return type

[**\SmartVolution\Model\DeviceForWebListContainPrinter[]**](../Model/DeviceForWebListContainPrinter.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `unenroll()`

```php
unenroll($id)
```

unenrolls a TCR device with the system

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1enrollApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The id for the device

try {
    $apiInstance->unenroll($id);
} catch (Exception $e) {
    echo 'Exception when calling V1enrollApi->unenroll: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The id for the device |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateDevice()`

```php
updateDevice($deviceInEdit)
```

edit an existing device in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1enrollApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$deviceInEdit = new \SmartVolution\Model\DeviceInEdit(); // \SmartVolution\Model\DeviceInEdit | device object containing edited fields

try {
    $apiInstance->updateDevice($deviceInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1enrollApi->updateDevice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **deviceInEdit** | [**\SmartVolution\Model\DeviceInEdit**](../Model/DeviceInEdit.md)| device object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateLastSyncForDevice()`

```php
updateLastSyncForDevice($id)
```

edit the the lastSync of an existing device in the system

set the Devices.lastSync column to the current date/time value for the specified device

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1enrollApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of device to update

try {
    $apiInstance->updateLastSyncForDevice($id);
} catch (Exception $e) {
    echo 'Exception when calling V1enrollApi->updateLastSyncForDevice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of device to update |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
