# SmartVolution\V1discountsApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createDiscount()**](V1discountsApi.md#createDiscount) | **POST** /v1/discounts | Create a discount in the system
[**deleteDiscountById()**](V1discountsApi.md#deleteDiscountById) | **DELETE** /v1/discounts/{id} | Deletes a discount by their id
[**findDiscountById()**](V1discountsApi.md#findDiscountById) | **GET** /v1/discounts/{id} | Gets discount details by their id
[**getAllDiscountTypes()**](V1discountsApi.md#getAllDiscountTypes) | **GET** /v1/discountTypes | Gets a list of all the discountTypes
[**getAllDiscounts()**](V1discountsApi.md#getAllDiscounts) | **GET** /v1/discounts | Gets a list of all the discounts for a tenant
[**updateDiscount()**](V1discountsApi.md#updateDiscount) | **PATCH** /v1/discounts | edit an existing discount in the system


## `createDiscount()`

```php
createDiscount($discount)
```

Create a discount in the system

This is not finalised as there is no authentication

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1discountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$discount = new \SmartVolution\Model\DiscountIn(); // \SmartVolution\Model\DiscountIn | Discount object that need to be created

try {
    $apiInstance->createDiscount($discount);
} catch (Exception $e) {
    echo 'Exception when calling V1discountsApi->createDiscount: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **discount** | [**\SmartVolution\Model\DiscountIn**](../Model/DiscountIn.md)| Discount object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteDiscountById()`

```php
deleteDiscountById($id)
```

Deletes a discount by their id

Non-Destructive in the database (Discount are flagged as deleted)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1discountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of user to delete

try {
    $apiInstance->deleteDiscountById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1discountsApi->deleteDiscountById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of user to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `findDiscountById()`

```php
findDiscountById($id): \SmartVolution\Model\Discount
```

Gets discount details by their id

Authenticated Devices do not have access to this call

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1discountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of discount to query

try {
    $result = $apiInstance->findDiscountById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1discountsApi->findDiscountById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of discount to query |

### Return type

[**\SmartVolution\Model\Discount**](../Model/Discount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllDiscountTypes()`

```php
getAllDiscountTypes(): \SmartVolution\Model\DiscountType[]
```

Gets a list of all the discountTypes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1discountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getAllDiscountTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1discountsApi->getAllDiscountTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\DiscountType[]**](../Model/DiscountType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllDiscounts()`

```php
getAllDiscounts($tenant, $since, $deleted, $protect): \SmartVolution\Model\Discount[]
```

Gets a list of all the discounts for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1discountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted
$protect = True; // bool | Shows only records that is notprotected

try {
    $result = $apiInstance->getAllDiscounts($tenant, $since, $deleted, $protect);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1discountsApi->getAllDiscounts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **protect** | **bool**| Shows only records that is notprotected | [optional]

### Return type

[**\SmartVolution\Model\Discount[]**](../Model/Discount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateDiscount()`

```php
updateDiscount($discount)
```

edit an existing discount in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1discountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$discount = new \SmartVolution\Model\DiscountInEdit(); // \SmartVolution\Model\DiscountInEdit | User object containing edited fields

try {
    $apiInstance->updateDiscount($discount);
} catch (Exception $e) {
    echo 'Exception when calling V1discountsApi->updateDiscount: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **discount** | [**\SmartVolution\Model\DiscountInEdit**](../Model/DiscountInEdit.md)| User object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
