# SmartVolution\V1deviceconfigcategoryApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createConfigCategory()**](V1deviceconfigcategoryApi.md#createConfigCategory) | **POST** /v1/device/config/category | Create a Config Category in the system
[**deleteConfigCategoryById()**](V1deviceconfigcategoryApi.md#deleteConfigCategoryById) | **DELETE** /v1/device/config/category/{id} | Deletes a config category by their id
[**getAllConfigCategories()**](V1deviceconfigcategoryApi.md#getAllConfigCategories) | **GET** /v1/device/config/category | Gets a list of all the ConfigCategories
[**updateConfigCategory()**](V1deviceconfigcategoryApi.md#updateConfigCategory) | **PATCH** /v1/device/config/category | edit an existing config category in the system


## `createConfigCategory()`

```php
createConfigCategory($configCategory)
```

Create a Config Category in the system

This is not finalised as there is no authentication

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1deviceconfigcategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$configCategory = new \SmartVolution\Model\ConfigCategoryIn(); // \SmartVolution\Model\ConfigCategoryIn | Config Category object that need to be created

try {
    $apiInstance->createConfigCategory($configCategory);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigcategoryApi->createConfigCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configCategory** | [**\SmartVolution\Model\ConfigCategoryIn**](../Model/ConfigCategoryIn.md)| Config Category object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteConfigCategoryById()`

```php
deleteConfigCategoryById($id)
```

Deletes a config category by their id

Destructive in the database

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1deviceconfigcategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of category to delete

try {
    $apiInstance->deleteConfigCategoryById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigcategoryApi->deleteConfigCategoryById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of category to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllConfigCategories()`

```php
getAllConfigCategories(): \SmartVolution\Model\ConfigCategory[]
```

Gets a list of all the ConfigCategories

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1deviceconfigcategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getAllConfigCategories();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigcategoryApi->getAllConfigCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\ConfigCategory[]**](../Model/ConfigCategory.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateConfigCategory()`

```php
updateConfigCategory($configCategory)
```

edit an existing config category in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1deviceconfigcategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$configCategory = new \SmartVolution\Model\ConfigCategoryInEdit(); // \SmartVolution\Model\ConfigCategoryInEdit | Config Category object containing edited fields

try {
    $apiInstance->updateConfigCategory($configCategory);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigcategoryApi->updateConfigCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configCategory** | [**\SmartVolution\Model\ConfigCategoryInEdit**](../Model/ConfigCategoryInEdit.md)| Config Category object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
