# SmartVolution\V1customerFieldsApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createCustomerField()**](V1customerFieldsApi.md#createCustomerField) | **POST** /v1/customerFields | Create a customer field in the system
[**deleteCustomerFieldById()**](V1customerFieldsApi.md#deleteCustomerFieldById) | **DELETE** /v1/customerFields/{id} | Deletes a customer field by their id
[**findCustomerFieldById()**](V1customerFieldsApi.md#findCustomerFieldById) | **GET** /v1/customerFields/{id} | Gets CustomerField details by their id
[**findCustomerFieldByType()**](V1customerFieldsApi.md#findCustomerFieldByType) | **GET** /v1/customerFieldsByType/{fieldType} | Gets CustomerField details by their id
[**getAllCustomerFields()**](V1customerFieldsApi.md#getAllCustomerFields) | **GET** /v1/customerFields | Gets a list of all the CustomerField for a tenant
[**updateCustomerField()**](V1customerFieldsApi.md#updateCustomerField) | **PATCH** /v1/customerFields | Edit an existing customer field in the system


## `createCustomerField()`

```php
createCustomerField($customerField)
```

Create a customer field in the system

This is not finalised as there is no authentication

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1customerFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customerField = new \SmartVolution\Model\CustomerFieldIn(); // \SmartVolution\Model\CustomerFieldIn | Customer Field object that need to be created

try {
    $apiInstance->createCustomerField($customerField);
} catch (Exception $e) {
    echo 'Exception when calling V1customerFieldsApi->createCustomerField: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerField** | [**\SmartVolution\Model\CustomerFieldIn**](../Model/CustomerFieldIn.md)| Customer Field object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCustomerFieldById()`

```php
deleteCustomerFieldById($id)
```

Deletes a customer field by their id

Non-Destructive in the database (Customer field are flagged as deleted)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1customerFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of Customer Field to delete

try {
    $apiInstance->deleteCustomerFieldById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1customerFieldsApi->deleteCustomerFieldById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Customer Field to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `findCustomerFieldById()`

```php
findCustomerFieldById($id): \SmartVolution\Model\CustomerField
```

Gets CustomerField details by their id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1customerFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of Customer Field to query

try {
    $result = $apiInstance->findCustomerFieldById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1customerFieldsApi->findCustomerFieldById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Customer Field to query |

### Return type

[**\SmartVolution\Model\CustomerField**](../Model/CustomerField.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `findCustomerFieldByType()`

```php
findCustomerFieldByType($fieldType): \SmartVolution\Model\CustomerField
```

Gets CustomerField details by their id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1customerFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$fieldType = 'fieldType_example'; // string | namt of customerFild

try {
    $result = $apiInstance->findCustomerFieldByType($fieldType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1customerFieldsApi->findCustomerFieldByType: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **fieldType** | **string**| namt of customerFild |

### Return type

[**\SmartVolution\Model\CustomerField**](../Model/CustomerField.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllCustomerFields()`

```php
getAllCustomerFields($tenant, $since, $deleted, $locked): \SmartVolution\Model\CustomerField[]
```

Gets a list of all the CustomerField for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1customerFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted
$locked = True; // bool | Whether it is locked

try {
    $result = $apiInstance->getAllCustomerFields($tenant, $since, $deleted, $locked);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1customerFieldsApi->getAllCustomerFields: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **locked** | **bool**| Whether it is locked | [optional]

### Return type

[**\SmartVolution\Model\CustomerField[]**](../Model/CustomerField.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCustomerField()`

```php
updateCustomerField($customerFieldInEdit)
```

Edit an existing customer field in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1customerFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customerFieldInEdit = new \SmartVolution\Model\CustomerFieldInEdit(); // \SmartVolution\Model\CustomerFieldInEdit | Customer field object containing edited fields

try {
    $apiInstance->updateCustomerField($customerFieldInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1customerFieldsApi->updateCustomerField: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerFieldInEdit** | [**\SmartVolution\Model\CustomerFieldInEdit**](../Model/CustomerFieldInEdit.md)| Customer field object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
