# SmartVolution\V1clerksApi

All URIs are relative to http://dev.smartvolution.com:9003.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createClerk()**](V1clerksApi.md#createClerk) | **POST** /v1/clerks | Create a new clerk in the system
[**deleteClerkById()**](V1clerksApi.md#deleteClerkById) | **DELETE** /v1/clerks/{id} | Deletes a clerk by their id
[**findClerkById()**](V1clerksApi.md#findClerkById) | **GET** /v1/clerks/{id} | Gets clerk details by their id
[**getAllClerks()**](V1clerksApi.md#getAllClerks) | **GET** /v1/clerks | Gets a list of all the clerks for a tenant
[**getAllClerksV2()**](V1clerksApi.md#getAllClerksV2) | **GET** /v2/clerks | Gets a list of all the clerks for a tenant
[**getAllClerksV3()**](V1clerksApi.md#getAllClerksV3) | **GET** /v3/clerks | Gets a list of all the clerks for a tenant
[**updateClerk()**](V1clerksApi.md#updateClerk) | **PATCH** /v1/clerks | edit an existing clerk in the system


## `createClerk()`

```php
createClerk($clerk)
```

Create a new clerk in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1clerksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$clerk = new \SmartVolution\Model\ClerkWithStores(); // \SmartVolution\Model\ClerkWithStores | Clerk object that need to be created

try {
    $apiInstance->createClerk($clerk);
} catch (Exception $e) {
    echo 'Exception when calling V1clerksApi->createClerk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clerk** | [**\SmartVolution\Model\ClerkWithStores**](../Model/ClerkWithStores.md)| Clerk object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteClerkById()`

```php
deleteClerkById($id)
```

Deletes a clerk by their id

Non-Destructive in the database (Clerks are flagged as deleted)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1clerksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of clerk to delete

try {
    $apiInstance->deleteClerkById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1clerksApi->deleteClerkById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of clerk to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `findClerkById()`

```php
findClerkById($id): \SmartVolution\Model\ClerkWithStores
```

Gets clerk details by their id

Authenticated Devices do not have access to this call

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1clerksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Id of clerk to query

try {
    $result = $apiInstance->findClerkById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1clerksApi->findClerkById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of clerk to query |

### Return type

[**\SmartVolution\Model\ClerkWithStores**](../Model/ClerkWithStores.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllClerks()`

```php
getAllClerks($tenant, $since, $deleted, $store): \SmartVolution\Model\Clerk[]
```

Gets a list of all the clerks for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1clerksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted
$store = 56; // int | Shows only clerks that belong to the stores

try {
    $result = $apiInstance->getAllClerks($tenant, $since, $deleted, $store);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1clerksApi->getAllClerks: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **store** | **int**| Shows only clerks that belong to the stores | [optional]

### Return type

[**\SmartVolution\Model\Clerk[]**](../Model/Clerk.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllClerksV2()`

```php
getAllClerksV2($tenant, $since, $deleted, $store, $allowAppointments, $userTimeClerkIncluded): \SmartVolution\Model\Clerk[]
```

Gets a list of all the clerks for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1clerksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted
$store = 56; // int | Shows only clerks that belong to the stores
$allowAppointments = True; // bool | Shows only records that allow appointments
$userTimeClerkIncluded = True; // bool | Show records that include USER_TIME clerks

try {
    $result = $apiInstance->getAllClerksV2($tenant, $since, $deleted, $store, $allowAppointments, $userTimeClerkIncluded);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1clerksApi->getAllClerksV2: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **store** | **int**| Shows only clerks that belong to the stores | [optional]
 **allowAppointments** | **bool**| Shows only records that allow appointments | [optional]
 **userTimeClerkIncluded** | **bool**| Show records that include USER_TIME clerks | [optional]

### Return type

[**\SmartVolution\Model\Clerk[]**](../Model/Clerk.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllClerksV3()`

```php
getAllClerksV3($tenant, $since, $deleted, $store, $allowAppointments, $userTimeClerkIncluded): \SmartVolution\Model\Clerk[]
```

Gets a list of all the clerks for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1clerksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 56; // int | Id of Tenant to query
$since = 56; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = True; // bool | Shows only records that have been deleted
$store = 56; // int | Shows only clerks that belong to the stores
$allowAppointments = True; // bool | Shows only records that allow appointments
$userTimeClerkIncluded = True; // bool | Show records that include USER_TIME clerks

try {
    $result = $apiInstance->getAllClerksV3($tenant, $since, $deleted, $store, $allowAppointments, $userTimeClerkIncluded);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1clerksApi->getAllClerksV3: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **store** | **int**| Shows only clerks that belong to the stores | [optional]
 **allowAppointments** | **bool**| Shows only records that allow appointments | [optional]
 **userTimeClerkIncluded** | **bool**| Show records that include USER_TIME clerks | [optional]

### Return type

[**\SmartVolution\Model\Clerk[]**](../Model/Clerk.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateClerk()`

```php
updateClerk($clerkInEdit)
```

edit an existing clerk in the system

This is not finalised as there is no security

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SmartVolution\Api\V1clerksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$clerkInEdit = new \SmartVolution\Model\ClerkInEdit(); // \SmartVolution\Model\ClerkInEdit | Clerk object containing edited fields

try {
    $apiInstance->updateClerk($clerkInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1clerksApi->updateClerk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clerkInEdit** | [**\SmartVolution\Model\ClerkInEdit**](../Model/ClerkInEdit.md)| Clerk object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
