# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/Talisman/SmartVolution.git"
    }
  ],
  "require": {
    "Talisman/SmartVolution": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new SmartVolution\Api\V1appointmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$appointmentIn = new \SmartVolution\Model\AppointmentIn(); // \SmartVolution\Model\AppointmentIn | Appointment object that need to be created

try {
    $apiInstance->createAppointment($appointmentIn);
} catch (Exception $e) {
    echo 'Exception when calling V1appointmentsApi->createAppointment: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *http://dev.smartvolution.com:9003*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*V1appointmentsApi* | [**createAppointment**](docs/Api/V1appointmentsApi.md#createappointment) | **POST** /v1/appointments | Create a appointment in the system
*V1appointmentsApi* | [**deleteAppointmentById**](docs/Api/V1appointmentsApi.md#deleteappointmentbyid) | **DELETE** /v1/appointments/{id} | Deletes a appointment by their id
*V1appointmentsApi* | [**findAppointmentById**](docs/Api/V1appointmentsApi.md#findappointmentbyid) | **GET** /v1/appointments/{id} | Gets appointment details by their id
*V1appointmentsApi* | [**getAllAppointments**](docs/Api/V1appointmentsApi.md#getallappointments) | **GET** /v1/appointments | Gets a list of all the Appointment for a tenant
*V1appointmentsApi* | [**getAllAppointmentsV2**](docs/Api/V1appointmentsApi.md#getallappointmentsv2) | **GET** /v2/appointments | Gets a list of all the Appointment for a tenant
*V1appointmentsApi* | [**updateAppointment**](docs/Api/V1appointmentsApi.md#updateappointment) | **PATCH** /v1/appointments | Edit an existing appointment in the system
*V1authApi* | [**authenticate**](docs/Api/V1authApi.md#authenticate) | **POST** /v1/auth | 
*V1cashDenominationsApi* | [**createCD**](docs/Api/V1cashDenominationsApi.md#createcd) | **POST** /v1/cashDenominations | Create a cash denomination in the system
*V1cashDenominationsApi* | [**deleteCDById**](docs/Api/V1cashDenominationsApi.md#deletecdbyid) | **DELETE** /v1/cashDenominations/{id} | Deletes a cash denomination by their id
*V1cashDenominationsApi* | [**findCDById**](docs/Api/V1cashDenominationsApi.md#findcdbyid) | **GET** /v1/cashDenominations/{id} | Gets cash denomination details by id
*V1cashDenominationsApi* | [**getAllCashDenominations**](docs/Api/V1cashDenominationsApi.md#getallcashdenominations) | **GET** /v1/cashDenominations | Gets a list of all the cash denominations for a tenant
*V1cashDenominationsApi* | [**updateCD**](docs/Api/V1cashDenominationsApi.md#updatecd) | **PATCH** /v1/cashDenominations | edit an existing Cash Denomination in the system
*V1clerkStoresApi* | [**getAllClerkStores**](docs/Api/V1clerkStoresApi.md#getallclerkstores) | **GET** /v1/clerkStores | Gets a list of all the clerks for a tenant
*V1clerksApi* | [**createClerk**](docs/Api/V1clerksApi.md#createclerk) | **POST** /v1/clerks | Create a new clerk in the system
*V1clerksApi* | [**deleteClerkById**](docs/Api/V1clerksApi.md#deleteclerkbyid) | **DELETE** /v1/clerks/{id} | Deletes a clerk by their id
*V1clerksApi* | [**findClerkById**](docs/Api/V1clerksApi.md#findclerkbyid) | **GET** /v1/clerks/{id} | Gets clerk details by their id
*V1clerksApi* | [**getAllClerks**](docs/Api/V1clerksApi.md#getallclerks) | **GET** /v1/clerks | Gets a list of all the clerks for a tenant
*V1clerksApi* | [**getAllClerksV2**](docs/Api/V1clerksApi.md#getallclerksv2) | **GET** /v2/clerks | Gets a list of all the clerks for a tenant
*V1clerksApi* | [**getAllClerksV3**](docs/Api/V1clerksApi.md#getallclerksv3) | **GET** /v3/clerks | Gets a list of all the clerks for a tenant
*V1clerksApi* | [**updateClerk**](docs/Api/V1clerksApi.md#updateclerk) | **PATCH** /v1/clerks | edit an existing clerk in the system
*V1configKeysPrimaryApi* | [**getConfigKeysPrimary**](docs/Api/V1configKeysPrimaryApi.md#getconfigkeysprimary) | **GET** /v1/configKeysPrimary | retrieves the Config Key Primary
*V1customerFieldsApi* | [**createCustomerField**](docs/Api/V1customerFieldsApi.md#createcustomerfield) | **POST** /v1/customerFields | Create a customer field in the system
*V1customerFieldsApi* | [**deleteCustomerFieldById**](docs/Api/V1customerFieldsApi.md#deletecustomerfieldbyid) | **DELETE** /v1/customerFields/{id} | Deletes a customer field by their id
*V1customerFieldsApi* | [**findCustomerFieldById**](docs/Api/V1customerFieldsApi.md#findcustomerfieldbyid) | **GET** /v1/customerFields/{id} | Gets CustomerField details by their id
*V1customerFieldsApi* | [**findCustomerFieldByType**](docs/Api/V1customerFieldsApi.md#findcustomerfieldbytype) | **GET** /v1/customerFieldsByType/{fieldType} | Gets CustomerField details by their id
*V1customerFieldsApi* | [**getAllCustomerFields**](docs/Api/V1customerFieldsApi.md#getallcustomerfields) | **GET** /v1/customerFields | Gets a list of all the CustomerField for a tenant
*V1customerFieldsApi* | [**updateCustomerField**](docs/Api/V1customerFieldsApi.md#updatecustomerfield) | **PATCH** /v1/customerFields | Edit an existing customer field in the system
*V1customerProductsApi* | [**createCustomerProduct**](docs/Api/V1customerProductsApi.md#createcustomerproduct) | **POST** /v1/customerProducts | Create a customer product in the system
*V1customerProductsApi* | [**deleteCustomerProductById**](docs/Api/V1customerProductsApi.md#deletecustomerproductbyid) | **DELETE** /V1/customerProducts/{id} | Deletes a customer product by their id
*V1customerProductsApi* | [**getAllCustomerProducts**](docs/Api/V1customerProductsApi.md#getallcustomerproducts) | **GET** /v1/customerProducts | Gets a list of all the Customer Product for a tenant
*V1customerProductsApi* | [**updateCustomerProduct**](docs/Api/V1customerProductsApi.md#updatecustomerproduct) | **PATCH** /v1/customerProducts | Edit an existing customer product in the system
*V1customersApi* | [**createCustomer**](docs/Api/V1customersApi.md#createcustomer) | **POST** /v1/customers | Create a customer in the system
*V1customersApi* | [**deleteCustomerById**](docs/Api/V1customersApi.md#deletecustomerbyid) | **DELETE** /v1/customers/{id} | Deletes a customer by their id
*V1customersApi* | [**findCustomerById**](docs/Api/V1customersApi.md#findcustomerbyid) | **GET** /v1/customers/{id} | Gets Customer details by their id
*V1customersApi* | [**getAllCustomers**](docs/Api/V1customersApi.md#getallcustomers) | **GET** /v1/customers | Gets a list of all the Customer for a tenant
*V1customersApi* | [**putCustomer**](docs/Api/V1customersApi.md#putcustomer) | **PUT** /v1/customers | Performs an &#39;update or insert&#39; of a customer based on its code
*V1customersApi* | [**updateCustomer**](docs/Api/V1customersApi.md#updatecustomer) | **PATCH** /v1/customers | Edit an existing customer in the system
*V1departmentsApi* | [**checkDepartment**](docs/Api/V1departmentsApi.md#checkdepartment) | **GET** /v1/departments/check/{id} | Check a product group can be deleted
*V1departmentsApi* | [**createDepartment**](docs/Api/V1departmentsApi.md#createdepartment) | **POST** /v1/departments | Create a new department in the system
*V1departmentsApi* | [**deleteDepartmentById**](docs/Api/V1departmentsApi.md#deletedepartmentbyid) | **DELETE** /v1/departments/{id} | Deletes a department by its id
*V1departmentsApi* | [**getAllDepartments**](docs/Api/V1departmentsApi.md#getalldepartments) | **GET** /v1/departments | Gets a list of all the departments for a tenant
*V1departmentsApi* | [**getAllDepartmentsV2**](docs/Api/V1departmentsApi.md#getalldepartmentsv2) | **GET** /v2/departments | Gets a list of all the departments for a tenant
*V1departmentsApi* | [**getDepartmentById**](docs/Api/V1departmentsApi.md#getdepartmentbyid) | **GET** /v1/departments/{id} | Gets department details by id
*V1departmentsApi* | [**getDepartmentsWithSearch**](docs/Api/V1departmentsApi.md#getdepartmentswithsearch) | **GET** /v1/departments/search | Gets a list of all the departments for a tenant searching on name and description
*V1departmentsApi* | [**getImageForDepartment**](docs/Api/V1departmentsApi.md#getimagefordepartment) | **GET** /v1/departments/image | Gets the image for a department
*V1departmentsApi* | [**putDepartment**](docs/Api/V1departmentsApi.md#putdepartment) | **PUT** /v1/departments | performs an &#39;update or insert&#39; of a Department based on its Department Code
*V1departmentsApi* | [**updateDepartment**](docs/Api/V1departmentsApi.md#updatedepartment) | **PATCH** /v1/departments | edit an existing department in the system
*V1departmentsproductsApi* | [**createDepartmentProducts**](docs/Api/V1departmentsproductsApi.md#createdepartmentproducts) | **POST** /v1/departments/products | Add a product to the Product Group
*V1departmentsproductsApi* | [**deleteDepartmentProducts**](docs/Api/V1departmentsproductsApi.md#deletedepartmentproducts) | **DELETE** /v1/departments/products/{departmentId}/{productId} | Delete a product department associations
*V1departmentsproductsApi* | [**getAllDepartmentProducts**](docs/Api/V1departmentsproductsApi.md#getalldepartmentproducts) | **GET** /v1/departments/products | Gets a list of all the product department associations
*V1departmentsproductsApi* | [**getAllDepartmentProductsV2**](docs/Api/V1departmentsproductsApi.md#getalldepartmentproductsv2) | **GET** /v2/departments/products | Gets a list of all the product department associations
*V1departmentsproductsApi* | [**getDepartmentProducts**](docs/Api/V1departmentsproductsApi.md#getdepartmentproducts) | **GET** /v1/departments/products/{departmentId}/{productId} | Gets a product department associations
*V1departmentsproductsApi* | [**putDepartmentProducts**](docs/Api/V1departmentsproductsApi.md#putdepartmentproducts) | **PUT** /v1/departments/products | Add a product to the Product Group
*V1deviceconfigApi* | [**createConfig**](docs/Api/V1deviceconfigApi.md#createconfig) | **POST** /v1/device/config | Create a config in the system
*V1deviceconfigApi* | [**deleteConfigById**](docs/Api/V1deviceconfigApi.md#deleteconfigbyid) | **DELETE** /v1/device/config/{id} | Deletes a cash denomination by their id
*V1deviceconfigApi* | [**getAllConfigKeyValuesForDevice**](docs/Api/V1deviceconfigApi.md#getallconfigkeyvaluesfordevice) | **GET** /v1/device/config/layouts | retrieves the configuration key value pairs for a device
*V1deviceconfigApi* | [**getAllConfigurationForWeb**](docs/Api/V1deviceconfigApi.md#getallconfigurationforweb) | **GET** /v1/device/config/{id} | retrieves the configuration key value pairs for a configuration id
*V1deviceconfigApi* | [**getAllConfigurationForWebV2**](docs/Api/V1deviceconfigApi.md#getallconfigurationforwebv2) | **GET** /v2/device/config/{id} | retrieves the configuration key value pairs for a configuration id
*V1deviceconfigApi* | [**getConfigs**](docs/Api/V1deviceconfigApi.md#getconfigs) | **GET** /v1/device/config | Gets a list of all the configurations for a tenant
*V1deviceconfigApi* | [**updateConfigMapping**](docs/Api/V1deviceconfigApi.md#updateconfigmapping) | **PATCH** /v1/device/config | edit an existing config mapping in the system
*V1deviceconfigcategoryApi* | [**createConfigCategory**](docs/Api/V1deviceconfigcategoryApi.md#createconfigcategory) | **POST** /v1/device/config/category | Create a Config Category in the system
*V1deviceconfigcategoryApi* | [**deleteConfigCategoryById**](docs/Api/V1deviceconfigcategoryApi.md#deleteconfigcategorybyid) | **DELETE** /v1/device/config/category/{id} | Deletes a config category by their id
*V1deviceconfigcategoryApi* | [**getAllConfigCategories**](docs/Api/V1deviceconfigcategoryApi.md#getallconfigcategories) | **GET** /v1/device/config/category | Gets a list of all the ConfigCategories
*V1deviceconfigcategoryApi* | [**updateConfigCategory**](docs/Api/V1deviceconfigcategoryApi.md#updateconfigcategory) | **PATCH** /v1/device/config/category | edit an existing config category in the system
*V1deviceconfiggroupApi* | [**createConfigGroup**](docs/Api/V1deviceconfiggroupApi.md#createconfiggroup) | **POST** /v1/device/config/group | Create a Config Group in the system
*V1deviceconfiggroupApi* | [**deleteConfigGroupById**](docs/Api/V1deviceconfiggroupApi.md#deleteconfiggroupbyid) | **DELETE** /v1/device/config/group/{id} | Deletes a config group by their id
*V1deviceconfiggroupApi* | [**getAllConfigGroups**](docs/Api/V1deviceconfiggroupApi.md#getallconfiggroups) | **GET** /v1/device/config/group | Gets a list of all the ConfigGroups
*V1deviceconfiggroupApi* | [**updateConfigGroup**](docs/Api/V1deviceconfiggroupApi.md#updateconfiggroup) | **PATCH** /v1/device/config/group | edit an existing config group in the system
*V1discountsApi* | [**createDiscount**](docs/Api/V1discountsApi.md#creatediscount) | **POST** /v1/discounts | Create a discount in the system
*V1discountsApi* | [**deleteDiscountById**](docs/Api/V1discountsApi.md#deletediscountbyid) | **DELETE** /v1/discounts/{id} | Deletes a discount by their id
*V1discountsApi* | [**findDiscountById**](docs/Api/V1discountsApi.md#finddiscountbyid) | **GET** /v1/discounts/{id} | Gets discount details by their id
*V1discountsApi* | [**getAllDiscountTypes**](docs/Api/V1discountsApi.md#getalldiscounttypes) | **GET** /v1/discountTypes | Gets a list of all the discountTypes
*V1discountsApi* | [**getAllDiscounts**](docs/Api/V1discountsApi.md#getalldiscounts) | **GET** /v1/discounts | Gets a list of all the discounts for a tenant
*V1discountsApi* | [**updateDiscount**](docs/Api/V1discountsApi.md#updatediscount) | **PATCH** /v1/discounts | edit an existing discount in the system
*V1enrollApi* | [**createDevice**](docs/Api/V1enrollApi.md#createdevice) | **POST** /v1/device | Create a user account in the system
*V1enrollApi* | [**deleteDeviceById**](docs/Api/V1enrollApi.md#deletedevicebyid) | **DELETE** /v1/device/{id} | Deletes a user by their id
*V1enrollApi* | [**enroll**](docs/Api/V1enrollApi.md#enroll) | **GET** /v1/enroll/{provisionCode} | Enrolls a TCR device with the system
*V1enrollApi* | [**findDeviceById**](docs/Api/V1enrollApi.md#finddevicebyid) | **GET** /v1/device/{id} | Gets device details by their id
*V1enrollApi* | [**getAllDevices**](docs/Api/V1enrollApi.md#getalldevices) | **GET** /v1/device | Gets a list of all the devices for a tenant
*V1enrollApi* | [**unenroll**](docs/Api/V1enrollApi.md#unenroll) | **GET** /v1/unenroll/{id} | unenrolls a TCR device with the system
*V1enrollApi* | [**updateDevice**](docs/Api/V1enrollApi.md#updatedevice) | **PATCH** /v1/device | edit an existing device in the system
*V1enrollApi* | [**updateLastSyncForDevice**](docs/Api/V1enrollApi.md#updatelastsyncfordevice) | **GET** /v1/device/checkin/{id} | edit the the lastSync of an existing device in the system
*V1internationalisationsApi* | [**getAllInternationalisation**](docs/Api/V1internationalisationsApi.md#getallinternationalisation) | **GET** /v1/internationalisations | retrieves the Internationalisation
*V1internationalisationsApi* | [**getInternationalisationbyId**](docs/Api/V1internationalisationsApi.md#getinternationalisationbyid) | **GET** /v1/internationalisations/{id} | Getsn Internationalisation by their id
*V1licenseTypesApi* | [**getAllLicenseTypes**](docs/Api/V1licenseTypesApi.md#getalllicensetypes) | **GET** /v1/licenseTypes | Gets data of license type
*V1messagesApi* | [**createMessage**](docs/Api/V1messagesApi.md#createmessage) | **POST** /v1/messages | Create a message in the system
*V1messagesApi* | [**deleteMessageById**](docs/Api/V1messagesApi.md#deletemessagebyid) | **DELETE** /v1/messages | Deletes a message by their id
*V1messagesApi* | [**getMessageBundleTypes**](docs/Api/V1messagesApi.md#getmessagebundletypes) | **GET** /v1/messageBundleTypes | Gets data of message bundle types for a tenant
*V1messagesApi* | [**getMessageBundles**](docs/Api/V1messagesApi.md#getmessagebundles) | **GET** /v1/messageBundles | Gets data of message bundles for a tenant
*V1messagesApi* | [**getMessagePeriods**](docs/Api/V1messagesApi.md#getmessageperiods) | **GET** /v1/messagePeriods | Gets data of message periods for a tenant
*V1messagesApi* | [**getMessageSettingsByTenantId**](docs/Api/V1messagesApi.md#getmessagesettingsbytenantid) | **GET** /v1/messageSettings | Gets data of message settings for a tenant
*V1messagesApi* | [**getMessageSettingsReorderAlert**](docs/Api/V1messagesApi.md#getmessagesettingsreorderalert) | **GET** /v1/messageSettingsReorderAlert | Gets data of message settings reorder alert for a tenant
*V1messagesApi* | [**getMessageTextsSent**](docs/Api/V1messagesApi.md#getmessagetextssent) | **GET** /v1/messageTextsSent | Gets data of message texts sent for a tenant
*V1messagesApi* | [**getMessagesAlert**](docs/Api/V1messagesApi.md#getmessagesalert) | **GET** /v1/messagesAlert | Check if the texts message alert dialog should be show
*V1messagesApi* | [**getMessagesQueued**](docs/Api/V1messagesApi.md#getmessagesqueued) | **GET** /v1/messagesQueued | Gets data of message queued for a tenant
*V1messagesApi* | [**updateMessageSetting**](docs/Api/V1messagesApi.md#updatemessagesetting) | **PATCH** /v1/messageSettings | Edit an existing message setting in the system
*V1printersApi* | [**createDevicePrinter**](docs/Api/V1printersApi.md#createdeviceprinter) | **POST** /v1/devices/printers | create device printer
*V1printersApi* | [**createTenantPrinter**](docs/Api/V1printersApi.md#createtenantprinter) | **POST** /v1/printers | create tenant printer
*V1printersApi* | [**deleteDevicePrinterById**](docs/Api/V1printersApi.md#deletedeviceprinterbyid) | **DELETE** /v1/devices/printers/{id} | Deletes a DevicePrinter by id
*V1printersApi* | [**deleteTenantPrinterById**](docs/Api/V1printersApi.md#deletetenantprinterbyid) | **DELETE** /v1/printers/{id} | Deletes a TenantPrinter by id
*V1printersApi* | [**getAllDevicePrinters**](docs/Api/V1printersApi.md#getalldeviceprinters) | **GET** /v1/devices/printers | Get a list of all the device printers
*V1printersApi* | [**getAllPrinterTypes**](docs/Api/V1printersApi.md#getallprintertypes) | **GET** /v1/printerTypes | Get a list of all the printers
*V1printersApi* | [**getAllTenantPrinters**](docs/Api/V1printersApi.md#getalltenantprinters) | **GET** /v1/printers | Get a list of all the tenant printers
*V1printersApi* | [**getDevicePrinterById**](docs/Api/V1printersApi.md#getdeviceprinterbyid) | **GET** /v1/devices/printers/{id} | get a DevicePrinter by id
*V1printersApi* | [**getPrinterTypeById**](docs/Api/V1printersApi.md#getprintertypebyid) | **GET** /v1/printerTypes/{id} | Get a printers by id
*V1printersApi* | [**getTenantPrinterById**](docs/Api/V1printersApi.md#gettenantprinterbyid) | **GET** /v1/printers/{id} | Get a tenant printer by id
*V1printersApi* | [**updateDevicePrinter**](docs/Api/V1printersApi.md#updatedeviceprinter) | **PATCH** /v1/devices/printers | update device printer
*V1printersApi* | [**updateTenantPrinter**](docs/Api/V1printersApi.md#updatetenantprinter) | **PATCH** /v1/printers | update tenant printer
*V1productsApi* | [**createProduct**](docs/Api/V1productsApi.md#createproduct) | **POST** /v1/products | Create a new product in the system
*V1productsApi* | [**createProductV2**](docs/Api/V1productsApi.md#createproductv2) | **POST** /v2/products | Create a new product in the system
*V1productsApi* | [**createProductV3**](docs/Api/V1productsApi.md#createproductv3) | **POST** /v3/products | Create a new product in the system
*V1productsApi* | [**createProductV4**](docs/Api/V1productsApi.md#createproductv4) | **POST** /v4/products | Create a new product in the system
*V1productsApi* | [**deleteProductById**](docs/Api/V1productsApi.md#deleteproductbyid) | **DELETE** /v1/products/{id} | Deletes a product by their id
*V1productsApi* | [**findProductModifierProductById**](docs/Api/V1productsApi.md#findproductmodifierproductbyid) | **GET** /v1/products/productModifierProducts/{id} | Gets ProductModifierProduct details by their id
*V1productsApi* | [**getAllProductModifierProduct**](docs/Api/V1productsApi.md#getallproductmodifierproduct) | **GET** /v1/products/productModifierProducts | Gets a list of all the clerks for a tenant
*V1productsApi* | [**getAllProductPriceLists**](docs/Api/V1productsApi.md#getallproductpricelists) | **GET** /v1/products/priceList | Gets a list of all the price lists for a tenant
*V1productsApi* | [**getAllProducts**](docs/Api/V1productsApi.md#getallproducts) | **GET** /v1/products | Gets a list of all the products for a tenant
*V1productsApi* | [**getAllProductsV2**](docs/Api/V1productsApi.md#getallproductsv2) | **GET** /v2/products | Gets a list of all the products for a tenant
*V1productsApi* | [**getAllProductsV3**](docs/Api/V1productsApi.md#getallproductsv3) | **GET** /v3/products | Gets a list of all the products for a tenant
*V1productsApi* | [**getAllProductsV4**](docs/Api/V1productsApi.md#getallproductsv4) | **GET** /v4/products | Gets a list of all the products for a tenant
*V1productsApi* | [**getAllProductsV5**](docs/Api/V1productsApi.md#getallproductsv5) | **GET** /v5/products | Gets a list of all the products for a tenant
*V1productsApi* | [**getImageForProduct**](docs/Api/V1productsApi.md#getimageforproduct) | **GET** /v1/products/image | Gets the image for a product
*V1productsApi* | [**getProductTypes**](docs/Api/V1productsApi.md#getproducttypes) | **GET** /v1/products/types | Lists the available options for setting product type
*V1productsApi* | [**getProductbyId**](docs/Api/V1productsApi.md#getproductbyid) | **GET** /v1/products/{id} | Gets product details by their id
*V1productsApi* | [**getProductbyIdV2**](docs/Api/V1productsApi.md#getproductbyidv2) | **GET** /v2/products/{id} | Gets product details by their id
*V1productsApi* | [**getProductbyIdV3**](docs/Api/V1productsApi.md#getproductbyidv3) | **GET** /v3/products/{id} | Gets product details by their id
*V1productsApi* | [**getProductbyIdV4**](docs/Api/V1productsApi.md#getproductbyidv4) | **GET** /v4/products/{id} | Gets product details by their id
*V1productsApi* | [**getProductsWithSearch**](docs/Api/V1productsApi.md#getproductswithsearch) | **GET** /v1/products/search | Gets a list of all the products for a tenant searching on name and description
*V1productsApi* | [**putProduct**](docs/Api/V1productsApi.md#putproduct) | **PUT** /v1/products | performs an &#39;update or insert&#39; of a product based on its SKU
*V1productsApi* | [**putProductV2**](docs/Api/V1productsApi.md#putproductv2) | **PUT** /v2/products | performs an &#39;update or insert&#39; of a product based on its SKU
*V1productsApi* | [**putProductV3**](docs/Api/V1productsApi.md#putproductv3) | **PUT** /v3/products | performs an &#39;update or insert&#39; of a product based on its SKU
*V1productsApi* | [**putProductV4**](docs/Api/V1productsApi.md#putproductv4) | **PUT** /v4/products | performs an &#39;update or insert&#39; of a product based on its SKU
*V1productsApi* | [**setImageforProduct**](docs/Api/V1productsApi.md#setimageforproduct) | **POST** /v1/products/image | Set the image for a product
*V1productsApi* | [**updateProduct**](docs/Api/V1productsApi.md#updateproduct) | **PATCH** /v1/products | edit an existing product in the system
*V1productsApi* | [**updateProductV2**](docs/Api/V1productsApi.md#updateproductv2) | **PATCH** /v2/products | edit an existing product in the system
*V1productsApi* | [**updateProductV3**](docs/Api/V1productsApi.md#updateproductv3) | **PATCH** /v3/products | edit an existing product in the system
*V1productsApi* | [**updateProductV4**](docs/Api/V1productsApi.md#updateproductv4) | **PATCH** /v4/products | edit an existing product in the system
*V1productsbrowserApi* | [**addProductToLayout**](docs/Api/V1productsbrowserApi.md#addproducttolayout) | **POST** /v1/products/browser/layouts | add a product to a layout
*V1productsbrowserApi* | [**createLayout**](docs/Api/V1productsbrowserApi.md#createlayout) | **POST** /v1/products/browser | Create a new layout in the system
*V1productsbrowserApi* | [**deleteLayout**](docs/Api/V1productsbrowserApi.md#deletelayout) | **DELETE** /v1/products/browser/{id} | remove a layout
*V1productsbrowserApi* | [**deleteProductFromLayout**](docs/Api/V1productsbrowserApi.md#deleteproductfromlayout) | **DELETE** /v1/products/browser/layouts/{id} | remove a product from a layout
*V1productsbrowserApi* | [**editProductInLayout**](docs/Api/V1productsbrowserApi.md#editproductinlayout) | **PATCH** /v1/products/browser/layouts | edit a product to a layout
*V1productsbrowserApi* | [**getAllProductBrowserMappingsForDevice**](docs/Api/V1productsbrowserApi.md#getallproductbrowsermappingsfordevice) | **GET** /v1/products/browser/layouts | Gets all the products that should be displayed in the browser for a device
*V1productsbrowserApi* | [**getProductBrowserById**](docs/Api/V1productsbrowserApi.md#getproductbrowserbyid) | **GET** /v1/products/browser/{id} | Gets product browser for a specific id
*V1productsbrowserApi* | [**getProductBrowserLayouts**](docs/Api/V1productsbrowserApi.md#getproductbrowserlayouts) | **GET** /v1/products/browser | Gets a list of all the product browser layouts for a tenant
*V1productsbrowserApi* | [**getProductBrowserMappingsForLayout**](docs/Api/V1productsbrowserApi.md#getproductbrowsermappingsforlayout) | **GET** /v1/products/browser/layouts/{id} | Gets all the products for a specific layout
*V1productsbrowserApi* | [**replaceBrowserLayouts**](docs/Api/V1productsbrowserApi.md#replacebrowserlayouts) | **PUT** /v1/products/browser | replace the entire contents of a browser
*V1productsbrowserApi* | [**updateLayout**](docs/Api/V1productsbrowserApi.md#updatelayout) | **PATCH** /v1/products/browser | edit an existing layout in the system
*V1productsmodifiersApi* | [**getAllProductsModifiers**](docs/Api/V1productsmodifiersApi.md#getallproductsmodifiers) | **GET** /v1/products/modifiers | Gets a list of all the clerks for a tenant
*V1productstaxesApi* | [**getAllProductTaxes**](docs/Api/V1productstaxesApi.md#getallproducttaxes) | **GET** /v1/products/taxes | Gets a list of all the taxes assigned to products for a tenant
*V1productstaxesApi* | [**getAllProductTaxesV2**](docs/Api/V1productstaxesApi.md#getallproducttaxesv2) | **GET** /v2/products/taxes | Gets a list of all the taxes assigned to products for a tenant
*V1productstaxesApi* | [**getAllProductTaxesV3**](docs/Api/V1productstaxesApi.md#getallproducttaxesv3) | **GET** /v3/products/taxes | Gets a list of all the taxes assigned to products for a tenant
*V1reasonsApi* | [**createReason**](docs/Api/V1reasonsApi.md#createreason) | **POST** /v1/reasons | Create a reason in the Reasons
*V1reasonsApi* | [**createReasonUsage**](docs/Api/V1reasonsApi.md#createreasonusage) | **POST** /v1/reasons/usages | Create a new Reason Usage
*V1reasonsApi* | [**deleteReasonById**](docs/Api/V1reasonsApi.md#deletereasonbyid) | **DELETE** /v1/reasons/{id} | Deletes a reason by their id
*V1reasonsApi* | [**deleteReasonUsage**](docs/Api/V1reasonsApi.md#deletereasonusage) | **DELETE** /v1/reasons/usages/{usage} | Deletes a reason usage by their tenant id and usage id
*V1reasonsApi* | [**findReasonById**](docs/Api/V1reasonsApi.md#findreasonbyid) | **GET** /v1/reasons/{id} | Gets reasons by id
*V1reasonsApi* | [**getAllReasons**](docs/Api/V1reasonsApi.md#getallreasons) | **GET** /v1/reasons | Gets a list of all the reasons for a tenant
*V1reasonsApi* | [**getReasonTypes**](docs/Api/V1reasonsApi.md#getreasontypes) | **GET** /v1/reasons/usages | Gets usage values for reasons
*V1reasonsApi* | [**getReasonUsage**](docs/Api/V1reasonsApi.md#getreasonusage) | **GET** /v1/reasons/usages/{usage} | Gets usage by tenant id and usage id
*V1reasonsApi* | [**updateReason**](docs/Api/V1reasonsApi.md#updatereason) | **PATCH** /v1/reasons | Edit an existing reason in the Reasons
*V1reasonsApi* | [**updateReasonUsage**](docs/Api/V1reasonsApi.md#updatereasonusage) | **PATCH** /v1/reasons/usages | Update a Reason Usage
*V1reportsApi* | [**getAllReportsForTenant**](docs/Api/V1reportsApi.md#getallreportsfortenant) | **GET** /v1/reports | Gets all the products that should be displayed in the browser for a device
*V1reportsApi* | [**getReportById**](docs/Api/V1reportsApi.md#getreportbyid) | **GET** /v1/reports/{id} | Calculates a report between two datetimes
*V1reportsApi* | [**getReportGroups**](docs/Api/V1reportsApi.md#getreportgroups) | **GET** /v1/reportGroups | Gets data of report groups for a tenant
*V1stockApi* | [**getStockForListOfProducts**](docs/Api/V1stockApi.md#getstockforlistofproducts) | **GET** /v1/stock/ | gets the current stock count for a list of product
*V1stockApi* | [**getStockForProduct**](docs/Api/V1stockApi.md#getstockforproduct) | **GET** /v1/stock/{id} | gets the current stock count for a product
*V1stockApi* | [**updateStock**](docs/Api/V1stockApi.md#updatestock) | **PATCH** /v1/stock | increment or decrement the existing stored value by the quantity
*V1stockApi* | [**updateStockViaReplace**](docs/Api/V1stockApi.md#updatestockviareplace) | **PUT** /v1/stock | use the value in the stock to update the record
*V1storesApi* | [**createStore**](docs/Api/V1storesApi.md#createstore) | **POST** /v1/stores | Create a new store in the system
*V1storesApi* | [**createStoreV2**](docs/Api/V1storesApi.md#createstorev2) | **POST** /v2/stores | Create a new store in the system
*V1storesApi* | [**deleteStoreById**](docs/Api/V1storesApi.md#deletestorebyid) | **DELETE** /v1/stores/{id} | Deletes a store by their id
*V1storesApi* | [**getAllStorePriceLists**](docs/Api/V1storesApi.md#getallstorepricelists) | **GET** /V1/stores/priceLists | Gets a list of all the price lists for a tenant
*V1storesApi* | [**getAllStorePriceListsV2**](docs/Api/V1storesApi.md#getallstorepricelistsv2) | **GET** /V2/stores/priceLists | Gets a list of all the price lists for a tenant
*V1storesApi* | [**getAllStores**](docs/Api/V1storesApi.md#getallstores) | **GET** /v1/stores | Gets a list of all the stores for a tenant
*V1storesApi* | [**getStoreByIdV2**](docs/Api/V1storesApi.md#getstorebyidv2) | **GET** /v2/stores/{id} | Gets store details by their id
*V1storesApi* | [**getStorebyId**](docs/Api/V1storesApi.md#getstorebyid) | **GET** /v1/stores/{id} | Gets store details by their id
*V1storesApi* | [**getStoresWithSearch**](docs/Api/V1storesApi.md#getstoreswithsearch) | **GET** /v1/stores/search | Gets a list of all the stores for a tenant searching on name and description
*V1storesApi* | [**updateStore**](docs/Api/V1storesApi.md#updatestore) | **PATCH** /v1/stores | edit an existing store in the system
*V1storesApi* | [**updateStoreV2**](docs/Api/V1storesApi.md#updatestorev2) | **PATCH** /v2/stores | edit an existing store in the system
*V1supplierApi* | [**createSupplier**](docs/Api/V1supplierApi.md#createsupplier) | **POST** /v1/suppliers | Create a supplier in the system
*V1supplierApi* | [**deleteSupplierById**](docs/Api/V1supplierApi.md#deletesupplierbyid) | **DELETE** /v1/suppliers/{id} | Deletes a supplier by their id
*V1supplierApi* | [**findSupplierById**](docs/Api/V1supplierApi.md#findsupplierbyid) | **GET** /v1/suppliers/{id} | Gets supplier details by their id
*V1supplierApi* | [**getAllSuppliers**](docs/Api/V1supplierApi.md#getallsuppliers) | **GET** /v1/suppliers | Gets a list of all the supplier for a tenant
*V1supplierApi* | [**putSuppliers**](docs/Api/V1supplierApi.md#putsuppliers) | **PUT** /v1/suppliers | performs an &#39;update or insert&#39; of a supplier
*V1supplierApi* | [**updateSuppliers**](docs/Api/V1supplierApi.md#updatesuppliers) | **PATCH** /v1/suppliers | Edit an existing supplier in the system
*V1taxesApi* | [**createTax**](docs/Api/V1taxesApi.md#createtax) | **POST** /v1/taxes | Create a tax in the system
*V1taxesApi* | [**deleteTaxById**](docs/Api/V1taxesApi.md#deletetaxbyid) | **DELETE** /v1/taxes/{id} | Deletes a tax by their id
*V1taxesApi* | [**findTaxById**](docs/Api/V1taxesApi.md#findtaxbyid) | **GET** /v1/taxes/{id} | Gets tax details by their id
*V1taxesApi* | [**getAllTaxes**](docs/Api/V1taxesApi.md#getalltaxes) | **GET** /v1/taxes | Gets a list of all the taxes for a tenant
*V1taxesApi* | [**updateTax**](docs/Api/V1taxesApi.md#updatetax) | **PATCH** /v1/taxes | edit an existing tax in the system
*V1tenantsApi* | [**createTenant**](docs/Api/V1tenantsApi.md#createtenant) | **POST** /v1/tenants | Create a new clerk in the system
*V1tenantsApi* | [**deleteTenantById**](docs/Api/V1tenantsApi.md#deletetenantbyid) | **DELETE** /v1/tenants/{id} | Deletes a tenant by their id
*V1tenantsApi* | [**getAllTenantsForTenant**](docs/Api/V1tenantsApi.md#getalltenantsfortenant) | **GET** /v1/tenants | Gets a list of all the accessible for a tenant
*V1tenantsApi* | [**getBillingTypes**](docs/Api/V1tenantsApi.md#getbillingtypes) | **GET** /v1/billingTypes | Get options of BillingTypes
*V1tenantsApi* | [**getTenantById**](docs/Api/V1tenantsApi.md#gettenantbyid) | **GET** /v1/tenants/{id} | Gets all details for a tenant
*V1tenantsApi* | [**updateTenant**](docs/Api/V1tenantsApi.md#updatetenant) | **PATCH** /v1/tenants | edit an existing clerk in the system
*V1tenderTypesApi* | [**createTenderType**](docs/Api/V1tenderTypesApi.md#createtendertype) | **POST** /v1/tenderTypes | Create a tender type in the system
*V1tenderTypesApi* | [**deleteTenderTypeById**](docs/Api/V1tenderTypesApi.md#deletetendertypebyid) | **DELETE** /v1/tenderTypes/{id} | Deletes a tender type by their id
*V1tenderTypesApi* | [**findTenderTypeById**](docs/Api/V1tenderTypesApi.md#findtendertypebyid) | **GET** /v1/tenderTypes/{id} | Gets TenderType details by their id
*V1tenderTypesApi* | [**getAllTenderTypes**](docs/Api/V1tenderTypesApi.md#getalltendertypes) | **GET** /v1/tenderTypes | Gets a list of all the TenderType for a tenant
*V1tenderTypesApi* | [**updateTenderType**](docs/Api/V1tenderTypesApi.md#updatetendertype) | **PATCH** /v1/tenderTypes | Edit an existing tender type in the system
*V1timezoneApi* | [**getAllTimeZones**](docs/Api/V1timezoneApi.md#getalltimezones) | **GET** /v1/timezone | retrieves the TimeZones
*V1timezoneApi* | [**getTimeZonebyId**](docs/Api/V1timezoneApi.md#gettimezonebyid) | **GET** /v1/timezone/{id} | Gets TimeZone by their id
*V1transactionsApi* | [**batchLockSuspendedTransaction**](docs/Api/V1transactionsApi.md#batchlocksuspendedtransaction) | **GET** /v1/batchLockSuspendedTransaction | Batch Lock Suspended Transactions
*V1transactionsApi* | [**batchLockSuspendedTransactionV2**](docs/Api/V1transactionsApi.md#batchlocksuspendedtransactionv2) | **GET** /v2/batchLockSuspendedTransaction | Batch Lock Suspended Transactions
*V1transactionsApi* | [**createTransaction**](docs/Api/V1transactionsApi.md#createtransaction) | **POST** /v1/transactions | Create a new transaction in the system
*V1transactionsApi* | [**findPreAuthTransactionItems**](docs/Api/V1transactionsApi.md#findpreauthtransactionitems) | **GET** /v1/suspend/findPreAuthTransactionItems | Check if exists Pre Auth Suspended Items
*V1transactionsApi* | [**findSuspendedTransactionById**](docs/Api/V1transactionsApi.md#findsuspendedtransactionbyid) | **GET** /v1/suspended/{id} | Gets suspended transaction details by their id
*V1transactionsApi* | [**findSuspendedTransactionByIdV2**](docs/Api/V1transactionsApi.md#findsuspendedtransactionbyidv2) | **GET** /v2/suspended/{id} | Gets suspended transaction details by their id
*V1transactionsApi* | [**findSuspendedTransactionByIdV3**](docs/Api/V1transactionsApi.md#findsuspendedtransactionbyidv3) | **GET** /v3/suspended/{id} | Gets suspended transaction details by their id
*V1transactionsApi* | [**findSuspendedTransactionByReference**](docs/Api/V1transactionsApi.md#findsuspendedtransactionbyreference) | **GET** /v1/suspend/findSuspendedTransactionByReference | Gets a list of used reference that contains suspended transactions
*V1transactionsApi* | [**findSuspendedTransactionByReferenceV2**](docs/Api/V1transactionsApi.md#findsuspendedtransactionbyreferencev2) | **GET** /v2/suspend/findSuspendedTransactionByReference | Gets a list of used reference that contains suspended transactions
*V1transactionsApi* | [**findSuspendedTransactionByTillNumber**](docs/Api/V1transactionsApi.md#findsuspendedtransactionbytillnumber) | **GET** /v1/suspendedReferences | Gets a list of SuspendedTransactions&#39; references by storeId and till number
*V1transactionsApi* | [**findTransactionById**](docs/Api/V1transactionsApi.md#findtransactionbyid) | **GET** /v1/transactions/{id} | Gets transaction details by their id
*V1transactionsApi* | [**findTransactionByIdV2**](docs/Api/V1transactionsApi.md#findtransactionbyidv2) | **GET** /v2/transactions/{id} | Gets transaction details by their id
*V1transactionsApi* | [**getAllSuspendedTransactions**](docs/Api/V1transactionsApi.md#getallsuspendedtransactions) | **GET** /v1/suspended | Gets a list of all the suspended transactions for a tenant
*V1transactionsApi* | [**getAllSuspendedTransactionsV2**](docs/Api/V1transactionsApi.md#getallsuspendedtransactionsv2) | **GET** /v2/suspended | Gets a list of all the suspended transactions for a tenant
*V1transactionsApi* | [**getAllSuspendedTransactionsV3**](docs/Api/V1transactionsApi.md#getallsuspendedtransactionsv3) | **GET** /v3/suspended | Gets a list of all the suspended transactions for a tenant
*V1transactionsApi* | [**getAllTransactions**](docs/Api/V1transactionsApi.md#getalltransactions) | **GET** /v1/transactions | Gets a list of all the transactions for a tenant
*V1transactionsApi* | [**getAllTransactionsV2**](docs/Api/V1transactionsApi.md#getalltransactionsv2) | **GET** /v2/transactions | Gets a list of all the transactions for a tenant
*V1transactionsApi* | [**getSuspendedClerks**](docs/Api/V1transactionsApi.md#getsuspendedclerks) | **GET** /v1/suspendedClerks | Gets a list of clerks that contains suspended transactions
*V1transactionsApi* | [**getSuspendedReasons**](docs/Api/V1transactionsApi.md#getsuspendedreasons) | **GET** /v1/suspendedReasons | Gets a list of used reasons that contains suspended transactions
*V1transactionsApi* | [**getTextsRemainingNotification**](docs/Api/V1transactionsApi.md#gettextsremainingnotification) | **GET** /v1/textsRemainingNotification | Gets texts remaining notification when the texts remaining lower than text re-order limit
*V1transactionsApi* | [**putSuspendedTransaction**](docs/Api/V1transactionsApi.md#putsuspendedtransaction) | **PUT** /v1/suspended | Put a suspended transaction in the system
*V1transactionsApi* | [**updateTransaction**](docs/Api/V1transactionsApi.md#updatetransaction) | **PATCH** /v1/transactions | Edit an existing transaction in the system
*V1transferItemsApi* | [**createTransferItem**](docs/Api/V1transferItemsApi.md#createtransferitem) | **POST** /v1/transferItems | Create a new transferItem in the system
*V1transferItemsApi* | [**deleteTransferItemById**](docs/Api/V1transferItemsApi.md#deletetransferitembyid) | **GET** /v1/transferItems/delete/{transferItemId} | Deletes a transferItem by their id
*V1transferItemsApi* | [**getAllTransferItems**](docs/Api/V1transferItemsApi.md#getalltransferitems) | **GET** /v1/transferItems | Gets a list of all the transfers items for a transfer
*V1transferItemsApi* | [**getTransferItemsById**](docs/Api/V1transferItemsApi.md#gettransferitemsbyid) | **GET** /v1/transferItems/{id} | Gets a transfers Item for a tenant
*V1transferItemsApi* | [**updateTransferItem**](docs/Api/V1transferItemsApi.md#updatetransferitem) | **PATCH** /v1/transferItems | Update a new transferItem in the system
*V1transfersApi* | [**createTransfer**](docs/Api/V1transfersApi.md#createtransfer) | **POST** /v1/transfers | Create a new transfer in the system
*V1transfersApi* | [**getAllTransfers**](docs/Api/V1transfersApi.md#getalltransfers) | **GET** /v1/transfers | Gets a list of all the transfers for a tenant
*V1transfersApi* | [**getTransferById**](docs/Api/V1transfersApi.md#gettransferbyid) | **GET** /v1/transfers/{id} | Gets a list of all the transfers for a tenant
*V1transfersApi* | [**getTransferIdentifier**](docs/Api/V1transfersApi.md#gettransferidentifier) | **GET** /v1/transfer/identifier/{tenantId} | Gets the last Transfer Identifier
*V1transfersApi* | [**updateTransfer**](docs/Api/V1transfersApi.md#updatetransfer) | **PATCH** /v1/transfers | Update a new transfer in the system
*V1uomApi* | [**getAllConversions**](docs/Api/V1uomApi.md#getallconversions) | **GET** /v1/conversions | retrieves the conversions
*V1uomApi* | [**getAllUoms**](docs/Api/V1uomApi.md#getalluoms) | **GET** /v1/uom | retrieves the Uom
*V1usersApi* | [**createUser**](docs/Api/V1usersApi.md#createuser) | **POST** /v1/users | Create a user account in the system
*V1usersApi* | [**deleteUserById**](docs/Api/V1usersApi.md#deleteuserbyid) | **DELETE** /v1/users/{id} | Deletes a user by their id
*V1usersApi* | [**findUserById**](docs/Api/V1usersApi.md#finduserbyid) | **GET** /v1/users/{id} | Gets user details by their id
*V1usersApi* | [**getAllUsers**](docs/Api/V1usersApi.md#getallusers) | **GET** /v1/users | Gets a list of all the users for a tenant
*V1usersApi* | [**updateUser**](docs/Api/V1usersApi.md#updateuser) | **PATCH** /v1/users | edit an existing user in the system
*V2reportsApi* | [**getAgressoReport**](docs/Api/V2reportsApi.md#getagressoreport) | **GET** /v2/reports/custom/{id} | Calculates a report between two datetimes
*V2reportsApi* | [**getAllReportsForTenantV2**](docs/Api/V2reportsApi.md#getallreportsfortenantv2) | **GET** /v2/reports | Gets all the products that should be displayed in the browser for a device
*V2reportsApi* | [**getReportByIdV2**](docs/Api/V2reportsApi.md#getreportbyidv2) | **GET** /v2/reports/{id} | Calculates a report between two datetimes
*V2reportsApi* | [**getReportByIdV3**](docs/Api/V2reportsApi.md#getreportbyidv3) | **GET** /v3/reports/{id} | Calculates a report between two datetimes
*V2reportsApi* | [**getReportGroupsV2**](docs/Api/V2reportsApi.md#getreportgroupsv2) | **GET** /v2/reportGroups | Gets data of report groups for a tenant

## Models

- [AllFieldCustomer](docs/Model/AllFieldCustomer.md)
- [Appointment](docs/Model/Appointment.md)
- [AppointmentIn](docs/Model/AppointmentIn.md)
- [AppointmentInEdit](docs/Model/AppointmentInEdit.md)
- [AppointmentVii](docs/Model/AppointmentVii.md)
- [Auth](docs/Model/Auth.md)
- [CashDenominations](docs/Model/CashDenominations.md)
- [CashDenominationsIn](docs/Model/CashDenominationsIn.md)
- [CashDenominationsInEdit](docs/Model/CashDenominationsInEdit.md)
- [Clerk](docs/Model/Clerk.md)
- [ClerkInEdit](docs/Model/ClerkInEdit.md)
- [ClerkStores](docs/Model/ClerkStores.md)
- [ClerkWithStores](docs/Model/ClerkWithStores.md)
- [ClientNotification](docs/Model/ClientNotification.md)
- [Config](docs/Model/Config.md)
- [ConfigCategory](docs/Model/ConfigCategory.md)
- [ConfigCategoryIn](docs/Model/ConfigCategoryIn.md)
- [ConfigCategoryInEdit](docs/Model/ConfigCategoryInEdit.md)
- [ConfigForWeb](docs/Model/ConfigForWeb.md)
- [ConfigForWebVii](docs/Model/ConfigForWebVii.md)
- [ConfigGroup](docs/Model/ConfigGroup.md)
- [ConfigGroupIn](docs/Model/ConfigGroupIn.md)
- [ConfigGroupInEdit](docs/Model/ConfigGroupInEdit.md)
- [ConfigKey](docs/Model/ConfigKey.md)
- [ConfigKeysPrimary](docs/Model/ConfigKeysPrimary.md)
- [ConfigList](docs/Model/ConfigList.md)
- [ConfigMappingIn](docs/Model/ConfigMappingIn.md)
- [ConfigMappingInList](docs/Model/ConfigMappingInList.md)
- [Configuration](docs/Model/Configuration.md)
- [ConfigurationIn](docs/Model/ConfigurationIn.md)
- [Conversion](docs/Model/Conversion.md)
- [CustomerDetails](docs/Model/CustomerDetails.md)
- [CustomerField](docs/Model/CustomerField.md)
- [CustomerFieldIn](docs/Model/CustomerFieldIn.md)
- [CustomerFieldInEdit](docs/Model/CustomerFieldInEdit.md)
- [CustomerFieldValue](docs/Model/CustomerFieldValue.md)
- [CustomerIn](docs/Model/CustomerIn.md)
- [CustomerInEdit](docs/Model/CustomerInEdit.md)
- [CustomerInOver](docs/Model/CustomerInOver.md)
- [CustomerProduct](docs/Model/CustomerProduct.md)
- [CustomerProductIn](docs/Model/CustomerProductIn.md)
- [CustomerProductInEdit](docs/Model/CustomerProductInEdit.md)
- [Department](docs/Model/Department.md)
- [DepartmentIn](docs/Model/DepartmentIn.md)
- [DepartmentInEdit](docs/Model/DepartmentInEdit.md)
- [DepartmentProducts](docs/Model/DepartmentProducts.md)
- [DepartmentProductsIn](docs/Model/DepartmentProductsIn.md)
- [DepartmentProductsPut](docs/Model/DepartmentProductsPut.md)
- [DepartmentPut](docs/Model/DepartmentPut.md)
- [DeviceForWeb](docs/Model/DeviceForWeb.md)
- [DeviceForWebListContainPrinter](docs/Model/DeviceForWebListContainPrinter.md)
- [DeviceIn](docs/Model/DeviceIn.md)
- [DeviceInEdit](docs/Model/DeviceInEdit.md)
- [DevicePrinter](docs/Model/DevicePrinter.md)
- [DevicePrinterIn](docs/Model/DevicePrinterIn.md)
- [DevicePrinterInEdit](docs/Model/DevicePrinterInEdit.md)
- [DevicePrinterInForDeviceInAndEdit](docs/Model/DevicePrinterInForDeviceInAndEdit.md)
- [Discount](docs/Model/Discount.md)
- [DiscountIn](docs/Model/DiscountIn.md)
- [DiscountInEdit](docs/Model/DiscountInEdit.md)
- [DiscountType](docs/Model/DiscountType.md)
- [EnrolledDevice](docs/Model/EnrolledDevice.md)
- [Internationalisation](docs/Model/Internationalisation.md)
- [LicenseType](docs/Model/LicenseType.md)
- [MessageBundle](docs/Model/MessageBundle.md)
- [MessageBundleType](docs/Model/MessageBundleType.md)
- [MessageIn](docs/Model/MessageIn.md)
- [MessagePeriod](docs/Model/MessagePeriod.md)
- [MessageSetting](docs/Model/MessageSetting.md)
- [MessageSettingInEdit](docs/Model/MessageSettingInEdit.md)
- [MessageSettingsReorderAlert](docs/Model/MessageSettingsReorderAlert.md)
- [MessagesQueued](docs/Model/MessagesQueued.md)
- [PriceList](docs/Model/PriceList.md)
- [PriceListIn](docs/Model/PriceListIn.md)
- [PriceListTimeSlotsIn](docs/Model/PriceListTimeSlotsIn.md)
- [PriceListTimeSlotsOut](docs/Model/PriceListTimeSlotsOut.md)
- [Printer](docs/Model/Printer.md)
- [Product](docs/Model/Product.md)
- [ProductBrowserLayout](docs/Model/ProductBrowserLayout.md)
- [ProductBrowserLayoutIn](docs/Model/ProductBrowserLayoutIn.md)
- [ProductBrowserLayoutInEdit](docs/Model/ProductBrowserLayoutInEdit.md)
- [ProductBrowserMapping](docs/Model/ProductBrowserMapping.md)
- [ProductBrowserMappingIn](docs/Model/ProductBrowserMappingIn.md)
- [ProductBrowserMappingInReplace](docs/Model/ProductBrowserMappingInReplace.md)
- [ProductBrowserMappingInReplaceList](docs/Model/ProductBrowserMappingInReplaceList.md)
- [ProductCustomDetails](docs/Model/ProductCustomDetails.md)
- [ProductExtraDetails](docs/Model/ProductExtraDetails.md)
- [ProductExtraDetailsVii](docs/Model/ProductExtraDetailsVii.md)
- [ProductForBrowser](docs/Model/ProductForBrowser.md)
- [ProductIn](docs/Model/ProductIn.md)
- [ProductInEdit](docs/Model/ProductInEdit.md)
- [ProductInEditVii](docs/Model/ProductInEditVii.md)
- [ProductInEditViii](docs/Model/ProductInEditViii.md)
- [ProductInEditViv](docs/Model/ProductInEditViv.md)
- [ProductInOver](docs/Model/ProductInOver.md)
- [ProductInOverVii](docs/Model/ProductInOverVii.md)
- [ProductInOverViii](docs/Model/ProductInOverViii.md)
- [ProductInOverViv](docs/Model/ProductInOverViv.md)
- [ProductInVii](docs/Model/ProductInVii.md)
- [ProductInViii](docs/Model/ProductInViii.md)
- [ProductInViv](docs/Model/ProductInViv.md)
- [ProductModifierProduct](docs/Model/ProductModifierProduct.md)
- [ProductModifierProductIn](docs/Model/ProductModifierProductIn.md)
- [ProductModifiers](docs/Model/ProductModifiers.md)
- [ProductPriceList](docs/Model/ProductPriceList.md)
- [ProductStock](docs/Model/ProductStock.md)
- [ProductTax](docs/Model/ProductTax.md)
- [ProductTaxViii](docs/Model/ProductTaxViii.md)
- [ProductViii](docs/Model/ProductViii.md)
- [ProductVv](docs/Model/ProductVv.md)
- [ProductWithImage](docs/Model/ProductWithImage.md)
- [ProductWithImageOut](docs/Model/ProductWithImageOut.md)
- [ProductWithTaxDeptVii](docs/Model/ProductWithTaxDeptVii.md)
- [ReasonUsage](docs/Model/ReasonUsage.md)
- [ReasonUsageIn](docs/Model/ReasonUsageIn.md)
- [ReasonUsageInEdit](docs/Model/ReasonUsageInEdit.md)
- [Reasons](docs/Model/Reasons.md)
- [ReasonsIn](docs/Model/ReasonsIn.md)
- [ReasonsInEdit](docs/Model/ReasonsInEdit.md)
- [Report](docs/Model/Report.md)
- [ReportColumn](docs/Model/ReportColumn.md)
- [ReportGroup](docs/Model/ReportGroup.md)
- [ReportRow](docs/Model/ReportRow.md)
- [Stock](docs/Model/Stock.md)
- [StockUpdateIn](docs/Model/StockUpdateIn.md)
- [StockUpdateInList](docs/Model/StockUpdateInList.md)
- [StockUpdateResponse](docs/Model/StockUpdateResponse.md)
- [Store](docs/Model/Store.md)
- [StoreIn](docs/Model/StoreIn.md)
- [StoreInEdit](docs/Model/StoreInEdit.md)
- [StorePriceListIn](docs/Model/StorePriceListIn.md)
- [StorePriceListOut](docs/Model/StorePriceListOut.md)
- [StorePriceLists](docs/Model/StorePriceLists.md)
- [StorePriceListsVii](docs/Model/StorePriceListsVii.md)
- [StoreViiIn](docs/Model/StoreViiIn.md)
- [StoreViiInEdit](docs/Model/StoreViiInEdit.md)
- [StoreWithPriceListsVii](docs/Model/StoreWithPriceListsVii.md)
- [Supplier](docs/Model/Supplier.md)
- [SupplierIn](docs/Model/SupplierIn.md)
- [SupplierInEdit](docs/Model/SupplierInEdit.md)
- [SupplierInOver](docs/Model/SupplierInOver.md)
- [SuspendedTransaction](docs/Model/SuspendedTransaction.md)
- [SuspendedTransactionInPut](docs/Model/SuspendedTransactionInPut.md)
- [SuspendedTransactionItemInPut](docs/Model/SuspendedTransactionItemInPut.md)
- [SuspendedTransactionItemModifierInPut](docs/Model/SuspendedTransactionItemModifierInPut.md)
- [SuspendedTransactionItemModifierOut](docs/Model/SuspendedTransactionItemModifierOut.md)
- [SuspendedTransactionItemOut](docs/Model/SuspendedTransactionItemOut.md)
- [SuspendedTransactionOut](docs/Model/SuspendedTransactionOut.md)
- [Tax](docs/Model/Tax.md)
- [TaxIn](docs/Model/TaxIn.md)
- [TaxInEdit](docs/Model/TaxInEdit.md)
- [Tenant](docs/Model/Tenant.md)
- [TenantIn](docs/Model/TenantIn.md)
- [TenantInEdit](docs/Model/TenantInEdit.md)
- [TenantPrinter](docs/Model/TenantPrinter.md)
- [TenantPrinterIn](docs/Model/TenantPrinterIn.md)
- [TenantPrinterInEdit](docs/Model/TenantPrinterInEdit.md)
- [TenderType](docs/Model/TenderType.md)
- [TenderTypeIn](docs/Model/TenderTypeIn.md)
- [TenderTypeInEdit](docs/Model/TenderTypeInEdit.md)
- [TextsSent](docs/Model/TextsSent.md)
- [TimeZone](docs/Model/TimeZone.md)
- [Transaction](docs/Model/Transaction.md)
- [TransactionInEdit](docs/Model/TransactionInEdit.md)
- [TransactionItem](docs/Model/TransactionItem.md)
- [TransactionItemModifier](docs/Model/TransactionItemModifier.md)
- [TransactionItemModifierOut](docs/Model/TransactionItemModifierOut.md)
- [TransactionItemOut](docs/Model/TransactionItemOut.md)
- [TransactionOut](docs/Model/TransactionOut.md)
- [TransactionResponse](docs/Model/TransactionResponse.md)
- [TransferIn](docs/Model/TransferIn.md)
- [TransferInEdit](docs/Model/TransferInEdit.md)
- [TransferItem](docs/Model/TransferItem.md)
- [TransferItemEdit](docs/Model/TransferItemEdit.md)
- [TransferItemIn](docs/Model/TransferItemIn.md)
- [Uom](docs/Model/Uom.md)
- [User](docs/Model/User.md)
- [UserIn](docs/Model/UserIn.md)
- [UserInEdit](docs/Model/UserInEdit.md)

## Authorization
All endpoints do not require authorization.
## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `4.15`
    - Package version: `1.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
