<?php
/**
 * V1transfersApi
 * PHP version 5
 *
 * @category Class
 * @package  SmartVolution
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * SV Register Web-services
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 4.15
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SmartVolution\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SmartVolution\ApiException;
use SmartVolution\Configuration;
use SmartVolution\HeaderSelector;
use SmartVolution\ObjectSerializer;

/**
 * V1transfersApi Class Doc Comment
 *
 * @category Class
 * @package  SmartVolution
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class V1transfersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createTransfer
     *
     * Create a new transfer in the system
     *
     * @param  \SmartVolution\Model\TransferIn $transfer Transaction object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int
     */
    public function createTransfer($transfer)
    {
        list($response) = $this->createTransferWithHttpInfo($transfer);
        return $response;
    }

    /**
     * Operation createTransferWithHttpInfo
     *
     * Create a new transfer in the system
     *
     * @param  \SmartVolution\Model\TransferIn $transfer Transaction object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTransferWithHttpInfo($transfer)
    {
        $returnType = 'int';
        $request = $this->createTransferRequest($transfer);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTransferAsync
     *
     * Create a new transfer in the system
     *
     * @param  \SmartVolution\Model\TransferIn $transfer Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTransferAsync($transfer)
    {
        return $this->createTransferAsyncWithHttpInfo($transfer)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTransferAsyncWithHttpInfo
     *
     * Create a new transfer in the system
     *
     * @param  \SmartVolution\Model\TransferIn $transfer Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTransferAsyncWithHttpInfo($transfer)
    {
        $returnType = 'int';
        $request = $this->createTransferRequest($transfer);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTransfer'
     *
     * @param  \SmartVolution\Model\TransferIn $transfer Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createTransferRequest($transfer)
    {
        // verify the required parameter 'transfer' is set
        if ($transfer === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transfer when calling createTransfer'
            );
        }

        $resourcePath = '/v1/transfers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($transfer)) {
            $_tempBody = $transfer;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllTransfers
     *
     * Gets a list of all the transfers for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int $from Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  int $to Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  string[] $status Transfer Status (optional)
     * @param  int[] $fromStore Transfer from store (optional)
     * @param  int[] $toStore Transfer to store (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\Product[]
     */
    public function getAllTransfers($tenant = null, $from = null, $to = null, $status = null, $fromStore = null, $toStore = null)
    {
        list($response) = $this->getAllTransfersWithHttpInfo($tenant, $from, $to, $status, $fromStore, $toStore);
        return $response;
    }

    /**
     * Operation getAllTransfersWithHttpInfo
     *
     * Gets a list of all the transfers for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int $from Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  int $to Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  string[] $status Transfer Status (optional)
     * @param  int[] $fromStore Transfer from store (optional)
     * @param  int[] $toStore Transfer to store (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\Product[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllTransfersWithHttpInfo($tenant = null, $from = null, $to = null, $status = null, $fromStore = null, $toStore = null)
    {
        $returnType = '\SmartVolution\Model\Product[]';
        $request = $this->getAllTransfersRequest($tenant, $from, $to, $status, $fromStore, $toStore);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\Product[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllTransfersAsync
     *
     * Gets a list of all the transfers for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int $from Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  int $to Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  string[] $status Transfer Status (optional)
     * @param  int[] $fromStore Transfer from store (optional)
     * @param  int[] $toStore Transfer to store (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllTransfersAsync($tenant = null, $from = null, $to = null, $status = null, $fromStore = null, $toStore = null)
    {
        return $this->getAllTransfersAsyncWithHttpInfo($tenant, $from, $to, $status, $fromStore, $toStore)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllTransfersAsyncWithHttpInfo
     *
     * Gets a list of all the transfers for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int $from Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  int $to Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  string[] $status Transfer Status (optional)
     * @param  int[] $fromStore Transfer from store (optional)
     * @param  int[] $toStore Transfer to store (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllTransfersAsyncWithHttpInfo($tenant = null, $from = null, $to = null, $status = null, $fromStore = null, $toStore = null)
    {
        $returnType = '\SmartVolution\Model\Product[]';
        $request = $this->getAllTransfersRequest($tenant, $from, $to, $status, $fromStore, $toStore);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllTransfers'
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int $from Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  int $to Create time range, a time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  string[] $status Transfer Status (optional)
     * @param  int[] $fromStore Transfer from store (optional)
     * @param  int[] $toStore Transfer to store (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllTransfersRequest($tenant = null, $from = null, $to = null, $status = null, $fromStore = null, $toStore = null)
    {

        $resourcePath = '/v1/transfers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($tenant !== null) {
            $queryParams['tenant'] = ObjectSerializer::toQueryValue($tenant);
        }
        // query params
        if ($from !== null) {
            $queryParams['from'] = ObjectSerializer::toQueryValue($from);
        }
        // query params
        if ($to !== null) {
            $queryParams['to'] = ObjectSerializer::toQueryValue($to);
        }
        // query params
        if (is_array($status)) {
            $status = ObjectSerializer::serializeCollection($status, 'csv', true);
        }
        if ($status !== null) {
            $queryParams['status'] = ObjectSerializer::toQueryValue($status);
        }
        // query params
        if (is_array($fromStore)) {
            $fromStore = ObjectSerializer::serializeCollection($fromStore, 'csv', true);
        }
        if ($fromStore !== null) {
            $queryParams['fromStore'] = ObjectSerializer::toQueryValue($fromStore);
        }
        // query params
        if (is_array($toStore)) {
            $toStore = ObjectSerializer::serializeCollection($toStore, 'csv', true);
        }
        if ($toStore !== null) {
            $queryParams['toStore'] = ObjectSerializer::toQueryValue($toStore);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTransferById
     *
     * Gets a list of all the transfers for a tenant
     *
     * @param  int $id Id of transfer (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\Product[]
     */
    public function getTransferById($id)
    {
        list($response) = $this->getTransferByIdWithHttpInfo($id);
        return $response;
    }

    /**
     * Operation getTransferByIdWithHttpInfo
     *
     * Gets a list of all the transfers for a tenant
     *
     * @param  int $id Id of transfer (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\Product[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getTransferByIdWithHttpInfo($id)
    {
        $returnType = '\SmartVolution\Model\Product[]';
        $request = $this->getTransferByIdRequest($id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\Product[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTransferByIdAsync
     *
     * Gets a list of all the transfers for a tenant
     *
     * @param  int $id Id of transfer (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransferByIdAsync($id)
    {
        return $this->getTransferByIdAsyncWithHttpInfo($id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTransferByIdAsyncWithHttpInfo
     *
     * Gets a list of all the transfers for a tenant
     *
     * @param  int $id Id of transfer (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransferByIdAsyncWithHttpInfo($id)
    {
        $returnType = '\SmartVolution\Model\Product[]';
        $request = $this->getTransferByIdRequest($id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTransferById'
     *
     * @param  int $id Id of transfer (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getTransferByIdRequest($id)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getTransferById'
            );
        }

        $resourcePath = '/v1/transfers/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTransferIdentifier
     *
     * Gets the last Transfer Identifier
     *
     * @param  int $tenantId Tenant Id (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getTransferIdentifier($tenantId)
    {
        list($response) = $this->getTransferIdentifierWithHttpInfo($tenantId);
        return $response;
    }

    /**
     * Operation getTransferIdentifierWithHttpInfo
     *
     * Gets the last Transfer Identifier
     *
     * @param  int $tenantId Tenant Id (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getTransferIdentifierWithHttpInfo($tenantId)
    {
        $returnType = 'string[]';
        $request = $this->getTransferIdentifierRequest($tenantId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTransferIdentifierAsync
     *
     * Gets the last Transfer Identifier
     *
     * @param  int $tenantId Tenant Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransferIdentifierAsync($tenantId)
    {
        return $this->getTransferIdentifierAsyncWithHttpInfo($tenantId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTransferIdentifierAsyncWithHttpInfo
     *
     * Gets the last Transfer Identifier
     *
     * @param  int $tenantId Tenant Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransferIdentifierAsyncWithHttpInfo($tenantId)
    {
        $returnType = 'string[]';
        $request = $this->getTransferIdentifierRequest($tenantId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTransferIdentifier'
     *
     * @param  int $tenantId Tenant Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getTransferIdentifierRequest($tenantId)
    {
        // verify the required parameter 'tenantId' is set
        if ($tenantId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tenantId when calling getTransferIdentifier'
            );
        }

        $resourcePath = '/v1/transfer/identifier/{tenantId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($tenantId !== null) {
            $resourcePath = str_replace(
                '{' . 'tenantId' . '}',
                ObjectSerializer::toPathValue($tenantId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateTransfer
     *
     * Update a new transfer in the system
     *
     * @param  \SmartVolution\Model\TransferInEdit $transfer Transaction object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateTransfer($transfer)
    {
        $this->updateTransferWithHttpInfo($transfer);
    }

    /**
     * Operation updateTransferWithHttpInfo
     *
     * Update a new transfer in the system
     *
     * @param  \SmartVolution\Model\TransferInEdit $transfer Transaction object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTransferWithHttpInfo($transfer)
    {
        $returnType = '';
        $request = $this->updateTransferRequest($transfer);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateTransferAsync
     *
     * Update a new transfer in the system
     *
     * @param  \SmartVolution\Model\TransferInEdit $transfer Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTransferAsync($transfer)
    {
        return $this->updateTransferAsyncWithHttpInfo($transfer)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateTransferAsyncWithHttpInfo
     *
     * Update a new transfer in the system
     *
     * @param  \SmartVolution\Model\TransferInEdit $transfer Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTransferAsyncWithHttpInfo($transfer)
    {
        $returnType = '';
        $request = $this->updateTransferRequest($transfer);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateTransfer'
     *
     * @param  \SmartVolution\Model\TransferInEdit $transfer Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateTransferRequest($transfer)
    {
        // verify the required parameter 'transfer' is set
        if ($transfer === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transfer when calling updateTransfer'
            );
        }

        $resourcePath = '/v1/transfers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($transfer)) {
            $_tempBody = $transfer;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
