# SmartVolution\V1usersApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createUser**](V1usersApi.md#createUser) | **POST** /v1/users | Create a user account in the system
[**deleteUserById**](V1usersApi.md#deleteUserById) | **DELETE** /v1/users/{id} | Deletes a user by their id
[**findUserById**](V1usersApi.md#findUserById) | **GET** /v1/users/{id} | Gets user details by their id
[**getAllUsers**](V1usersApi.md#getAllUsers) | **GET** /v1/users | Gets a list of all the users for a tenant
[**updateUser**](V1usersApi.md#updateUser) | **PATCH** /v1/users | edit an existing user in the system


# **createUser**
> createUser($user)

Create a user account in the system

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1usersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user = new \SmartVolution\Model\UserIn(); // \SmartVolution\Model\UserIn | User object that need to be created

try {
    $apiInstance->createUser($user);
} catch (Exception $e) {
    echo 'Exception when calling V1usersApi->createUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user** | [**\SmartVolution\Model\UserIn**](../Model/UserIn.md)| User object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUserById**
> deleteUserById($id)

Deletes a user by their id

Non-Destructive in the database (Users are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1usersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of user to delete

try {
    $apiInstance->deleteUserById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1usersApi->deleteUserById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of user to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findUserById**
> \SmartVolution\Model\User findUserById($id)

Gets user details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1usersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of user to query

try {
    $result = $apiInstance->findUserById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1usersApi->findUserById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of user to query |

### Return type

[**\SmartVolution\Model\User**](../Model/User.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllUsers**
> \SmartVolution\Model\User[] getAllUsers($tenant)

Gets a list of all the users for a tenant

if no tenant id is passed then will default to the user tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1usersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query

try {
    $result = $apiInstance->getAllUsers($tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1usersApi->getAllUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]

### Return type

[**\SmartVolution\Model\User[]**](../Model/User.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateUser**
> updateUser($user)

edit an existing user in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1usersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user = new \SmartVolution\Model\UserInEdit(); // \SmartVolution\Model\UserInEdit | User object containing edited fields

try {
    $apiInstance->updateUser($user);
} catch (Exception $e) {
    echo 'Exception when calling V1usersApi->updateUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user** | [**\SmartVolution\Model\UserInEdit**](../Model/UserInEdit.md)| User object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

