# SmartVolution\V1deviceconfigApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createConfig**](V1deviceconfigApi.md#createConfig) | **POST** /v1/device/config | Create a config in the system
[**deleteConfigById**](V1deviceconfigApi.md#deleteConfigById) | **DELETE** /v1/device/config/{id} | Deletes a cash denomination by their id
[**getAllConfigKeyValuesForDevice**](V1deviceconfigApi.md#getAllConfigKeyValuesForDevice) | **GET** /v1/device/config/layouts | retrieves the configuration key value pairs for a device
[**getAllConfigurationForWeb**](V1deviceconfigApi.md#getAllConfigurationForWeb) | **GET** /v1/device/config/{id} | retrieves the configuration key value pairs for a configuration id
[**getAllConfigurationForWebV2**](V1deviceconfigApi.md#getAllConfigurationForWebV2) | **GET** /v2/device/config/{id} | retrieves the configuration key value pairs for a configuration id
[**getConfigs**](V1deviceconfigApi.md#getConfigs) | **GET** /v1/device/config | Gets a list of all the configurations for a tenant
[**updateConfigMapping**](V1deviceconfigApi.md#updateConfigMapping) | **PATCH** /v1/device/config | edit an existing config mapping in the system


# **createConfig**
> createConfig($config)

Create a config in the system

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$config = new \SmartVolution\Model\ConfigurationIn(); // \SmartVolution\Model\ConfigurationIn | User object that need to be created

try {
    $apiInstance->createConfig($config);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigApi->createConfig: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **config** | [**\SmartVolution\Model\ConfigurationIn**](../Model/ConfigurationIn.md)| User object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteConfigById**
> deleteConfigById($id)

Deletes a cash denomination by their id

Non-Destructive in the database (Tax are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of user to delete

try {
    $apiInstance->deleteConfigById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigApi->deleteConfigById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of user to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllConfigKeyValuesForDevice**
> \SmartVolution\Model\Config[] getAllConfigKeyValuesForDevice()

retrieves the configuration key value pairs for a device



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getAllConfigKeyValuesForDevice();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigApi->getAllConfigKeyValuesForDevice: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\Config[]**](../Model/Config.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllConfigurationForWeb**
> \SmartVolution\Model\ConfigForWeb[] getAllConfigurationForWeb($id)

retrieves the configuration key value pairs for a configuration id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of config to query

try {
    $result = $apiInstance->getAllConfigurationForWeb($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigApi->getAllConfigurationForWeb: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of config to query |

### Return type

[**\SmartVolution\Model\ConfigForWeb[]**](../Model/ConfigForWeb.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllConfigurationForWebV2**
> \SmartVolution\Model\ConfigForWebVii getAllConfigurationForWebV2($id)

retrieves the configuration key value pairs for a configuration id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of config to query

try {
    $result = $apiInstance->getAllConfigurationForWebV2($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigApi->getAllConfigurationForWebV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of config to query |

### Return type

[**\SmartVolution\Model\ConfigForWebVii**](../Model/ConfigForWebVii.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConfigs**
> \SmartVolution\Model\Configuration[] getConfigs($tenant, $template)

Gets a list of all the configurations for a tenant

if no tenant id is passed then will default to the user tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$template = true; // bool | template of config to query

try {
    $result = $apiInstance->getConfigs($tenant, $template);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigApi->getConfigs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **template** | **bool**| template of config to query | [optional]

### Return type

[**\SmartVolution\Model\Configuration[]**](../Model/Configuration.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateConfigMapping**
> updateConfigMapping($configMappingInEdit)

edit an existing config mapping in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$configMappingInEdit = new \SmartVolution\Model\ConfigMappingInList(); // \SmartVolution\Model\ConfigMappingInList | Config Mapping object containing edited fields

try {
    $apiInstance->updateConfigMapping($configMappingInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfigApi->updateConfigMapping: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configMappingInEdit** | [**\SmartVolution\Model\ConfigMappingInList**](../Model/ConfigMappingInList.md)| Config Mapping object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

